/*
 * Decompiled with CFR 0.152.
 */
package mozilla_training_analyzer;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends AbstractTableModel
implements TableModelListener {
    private int[] indexes = null;
    private Vector sortingColumns = new Vector();
    private boolean ascending = true;
    private TableModel model = null;

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public void setModel(TableModel tableModel) {
        this.model = tableModel;
        this.reallocateIndexes();
    }

    public int lookupRowNum(int n) {
        if (n < 0) {
            return -1;
        }
        return this.indexes[n];
    }

    public int[] lookupRows(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.lookupRowNum(nArray[i]);
        }
        return nArray2;
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        Class<?> clazz = this.model.getColumnClass(n3);
        TableModel tableModel = this.model;
        Object object = tableModel.getValueAt(n, n3);
        Object object2 = tableModel.getValueAt(n2, n3);
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        double d = 0.0;
        if (Number.class.isAssignableFrom(clazz)) {
            double d2 = ((Number)tableModel.getValueAt(n, n3)).doubleValue();
            double d3 = ((Number)tableModel.getValueAt(n2, n3)).doubleValue();
            d = d2 - d3;
        } else {
            String string = object.toString();
            String string2 = object2.toString();
            d = string.compareTo(string2);
        }
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public int compare(int n, int n2) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Integer n3 = (Integer)this.sortingColumns.elementAt(i);
            int n4 = this.compareRowsByColumn(n, n2, n3);
            if (n4 == 0) continue;
            return this.ascending ? n4 : -n4;
        }
        return 0;
    }

    public void reallocateIndexes() {
        this.reallocateIndexes(null);
    }

    public void reallocateIndexes(TableModelEvent tableModelEvent) {
        int n = this.model.getRowCount();
        if (this.indexes == null || n != this.indexes.length) {
            if (tableModelEvent != null && tableModelEvent.getType() == 1 && n == this.indexes.length + 1) {
                int[] nArray = new int[n];
                System.arraycopy(this.indexes, 0, nArray, 0, this.indexes.length);
                nArray[n - 1] = n - 1;
                this.indexes = nArray;
                return;
            }
            if (tableModelEvent != null && tableModelEvent.getType() == -1 && n == this.indexes.length - 1) {
                int[] nArray = new int[n];
                int n2 = tableModelEvent.getFirstRow();
                int n3 = 0;
                for (int i = 0; i < this.indexes.length; ++i) {
                    if (this.indexes[i] != n2) {
                        nArray[i - n3] = this.indexes[i] > n2 ? this.indexes[i] - 1 : this.indexes[i];
                        continue;
                    }
                    n3 = 1;
                }
                this.indexes = nArray;
                return;
            }
            this.indexes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.indexes[i] = i;
            }
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes(tableModelEvent);
        this.fireTableChanged(tableModelEvent);
    }

    public boolean checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("Sorter not informed of a change in model. Perhaps the Sorter was not added as a TableModelListener to the underlying TableModel.");
            return false;
        }
        return true;
    }

    public void sort() {
        if (!this.checkModel()) {
            System.err.println("checkModel() returned false, aborting sort().");
            return;
        }
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public Object getValueAt(int n, int n2) {
        if (!this.checkModel()) {
            System.err.println("checkModel() returned false, getValueAt() may return invalid data.");
        }
        return this.model.getValueAt(this.indexes[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (!this.checkModel()) {
            System.err.println("checkModel() returned false, aborting satValueAt().");
            return;
        }
        this.model.setValueAt(object, this.indexes[n], n2);
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        this.sort();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public int getRowCount() {
        return this.model == null ? 0 : this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model == null ? 0 : this.model.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.model.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.model.isCellEditable(n, n2);
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final TableSorter tableSorter = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Cursor cursor = new Cursor(3);
                Cursor cursor2 = jTable2.getRootPane().getCursor();
                jTable2.getRootPane().setCursor(cursor);
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 1;
                    if (TableSorter.this.sortingColumns.size() > 0 && TableSorter.this.sortingColumns.contains(new Integer(n2))) {
                        TableSorter.this.ascending = !TableSorter.this.ascending;
                    } else {
                        TableSorter.this.ascending = true;
                    }
                    tableSorter.sortByColumn(n2, TableSorter.this.ascending);
                }
                jTable2.getRootPane().setCursor(cursor2);
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }
}

