/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Text;

namespace LocaleInpector
{


internal sealed class Output
{

private Output()
{
}

private static StringBuilder m_h1 = null;
private static StringBuilder m_h2 = null;
private static StringBuilder m_buffer = null;

public static void OpenH1(string name)
{
    if (m_h1 != null) {
        throw(new System.ArgumentNullException());
    }
    if (m_h2 != null) {
        throw(new System.ArgumentNullException());
    }
    m_h1 = new StringBuilder(200);
    m_buffer = m_h1;
    Output.WriteLine(string.Empty);
    Output.WriteLine(string.Empty);
    //Console.WriteLine(new string('%', 79));
    Output.WriteLine(("%%% " + name + " " + new string('%', 79)).Substring(0, 79));
}

public static void OpenH2(string name)
{
    if (m_h1 == null) {
        throw(new System.ArgumentNullException());
    }
    if (m_h2 != null) {
        throw(new System.ArgumentNullException());
    }
    m_h2 = new StringBuilder(200);
    m_buffer = m_h2;
    Output.WriteLine(string.Empty);
    Output.WriteLine(("=== " + name + " " + new string('=', 79)).Substring(0, 79));
}

public static void Close()
{
    if (m_buffer as object == m_h1 as object) {
        Console.Write(m_buffer.ToString());
        m_buffer = null;
        m_h1 = null;
    } else {
        m_h1.Append(m_h2.ToString());
        m_buffer = m_h1;
        m_h2 = null;
    }
}

public static void Clear()
{
    m_buffer.Length = 0;
}

public static void Write(string line)
{
    if (m_buffer == null) {
        Console.Write(line);
    } else {
        m_buffer.Append(line);
    }
}

public static void WriteLine(string line)
{
    if (m_buffer == null) {
        Console.WriteLine(line);
    } else {
        m_buffer.Append(line);
        m_buffer.Append(System.Environment.NewLine);
    }
}

public static bool WriteWarning(string name)
{
    if (Config.Current != null) {
        if (Config.Current.GetPref("general", "warnings") != "true") {
            //if (m_contentIni["general->warnings"].ToString() != "true") {
            return false;
        }
    }
    Output.WriteLine("Message: " + name);
    return true;
}

}//class
}//ns
