/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Collections.Generic;

namespace LocaleInpector
{

internal sealed class Files
{

private Files()
{
}

public static Status Check(string original, string translated)
{
    Output.OpenH2("Files");
    Status stat = new Status();

    List<string> originalFiles = BPIO.GetFileList(original, "*");
    List<string> translatedFiles = BPIO.GetFileList(translated, "*");

    // acha arquivos que faltam

    for (int idx = 0; idx < originalFiles.Count; idx++) {
        if (translatedFiles.Contains(originalFiles[idx])) {
            continue;
        }
        if (originalFiles[idx].EndsWith(".properties") || originalFiles[idx].EndsWith(".dtd") || originalFiles[idx].EndsWith(".dtd")) {
            Output.WriteLine("ERROR: Missing " + originalFiles[idx]);
            stat.Errors++;
        } else {
            // Missing searchplugins/amazondotcom.png
            Output.WriteWarning("Missing " + originalFiles[idx]);
            stat.Warnings++;
        }
    }


    // Find extra files

    string ext = Config.Current.GetPref("files", "del.extra"); 
    string[] ext2 = ext.Split(System.IO.Path.PathSeparator);
    bool autofix = ext2.Length > 1;
    for (int idx3 = 0; idx3 < ext2.Length; idx3++) {
        ext2[idx3] = ext2[idx3].Trim();
    }

    int delQty = 0;
    for (int idx = 0; idx < translatedFiles.Count; idx++) {
        if (originalFiles.Contains(translatedFiles[idx])) {
            continue;
        }

        stat.Warnings++;

        bool deleted = false;
        if (autofix) {
            foreach (string ext4 in ext2) {
                if (translatedFiles[idx].EndsWith(ext4)) {
                    BPIO.DeleteFile(translated + translatedFiles[idx]);
                    deleted = true;
                    delQty++;
                    break;
                }
            }
        }

        Output.WriteWarning("Extra   " + translatedFiles[idx] + (deleted ? " [DELETED]" : string.Empty));
    }

    Output.WriteLine("Original directory has " + originalFiles.Count.ToString() + " files, localization has " + translatedFiles.Count.ToString() + " files (ignoring hidden directories). ");

    if (stat.Empty) {
        Output.Clear();
    }

    if (delQty > 0) {
        Output.WriteLine(delQty.ToString() + " extra files have been deleted.");
    }

    Output.Close();
    return stat;
}

}//class
}//ns