/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient;

import java.awt.Canvas;
import java.io.File;
import java.io.FileNotFoundException;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.util.ParameterCheck;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlCanvas;
import org.mozilla.webclient.BrowserControlImpl;

public class BrowserControlFactory {
    private static boolean appDataHasBeenSet = false;
    private static Class browserControlCanvasClass = null;
    private static String platformCanvasClassName = null;
    private static String browserType = null;

    public BrowserControlFactory() {
        Assert.assert_it(false, "This class shouldn't be constructed.");
    }

    public static void setAppData(String string) throws FileNotFoundException, ClassNotFoundException {
        BrowserControlFactory.setAppData("native", string);
    }

    public static void setAppData(String string, String string2) throws FileNotFoundException, ClassNotFoundException {
        browserType = string;
        if (!appDataHasBeenSet) {
            if (browserType.equals("nonnative")) {
                platformCanvasClassName = "org.mozilla.webclient.wrapper_nonnative.JavaBrowserControlCanvas";
            } else {
                ParameterCheck.nonNull(string2);
                File file = new File(string2);
                if (!file.exists()) {
                    throw new FileNotFoundException("Directory " + string2 + " is not found.");
                }
                Canvas canvas = new Canvas();
                platformCanvasClassName = BrowserControlFactory.determinePlatformCanvasClassName();
            }
            if (platformCanvasClassName == null) {
                throw new ClassNotFoundException("Could not determine BrowserControlCanvas class to load\n");
            }
            browserControlCanvasClass = Class.forName(platformCanvasClassName);
            try {
                BrowserControlImpl.appInitialize(browserType, string2);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("Can't initialize native browser: " + exception.getMessage());
            }
            appDataHasBeenSet = true;
        }
    }

    public static void appTerminate() throws Exception {
        BrowserControlImpl.appTerminate();
    }

    public static BrowserControl newBrowserControl() throws InstantiationException, IllegalAccessException, IllegalStateException {
        if (!appDataHasBeenSet) {
            throw new IllegalStateException("Can't create BrowserControl instance: setAppData() has not been called.");
        }
        Assert.assert_it(null != browserControlCanvasClass);
        BrowserControlCanvas browserControlCanvas = null;
        BrowserControlImpl browserControlImpl = null;
        browserControlCanvas = (BrowserControlCanvas)browserControlCanvasClass.newInstance();
        if (null != browserControlCanvas && null != (browserControlImpl = new BrowserControlImpl(browserType, browserControlCanvas))) {
            browserControlCanvas.initialize(browserControlImpl);
        }
        return browserControlImpl;
    }

    public static void deleteBrowserControl(BrowserControl browserControl) {
        ParameterCheck.nonNull(browserControl);
        ((BrowserControlImpl)browserControl).delete();
    }

    private static String determinePlatformCanvasClassName() {
        String string = null;
        String string2 = System.getProperty("os.name");
        if (null != string2) {
            string = -1 != string2.indexOf("indows") ? "org.mozilla.webclient.wrapper_native.win32.Win32BrowserControlCanvas" : "org.mozilla.webclient.wrapper_native.motif.MotifBrowserControlCanvas";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("doing asserts");
        Assert.setEnabled(true);
        Log.setApplicationName("BrowserControlFactory");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: BrowserControlFactory.java,v 1.5.2.1 2001/09/10 21:42:14 edburns%acm.org Exp $");
        BrowserControlCanvas browserControlCanvas = null;
        BrowserControl browserControl = null;
        try {
            BrowserControlFactory.setAppData("nonnative", stringArray[0]);
            browserControl = BrowserControlFactory.newBrowserControl();
            Assert.assert_it(browserControl != null);
            browserControlCanvas = (BrowserControlCanvas)browserControl.queryInterface("webclient.BrowserControlCanvas");
            Assert.assert_it(browserControlCanvas != null);
        }
        catch (Exception exception) {
            System.out.println("\n BrowserControl not getting created \n");
            System.out.println(exception.getMessage());
        }
    }
}

