/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.mozilla.webclient.BookmarkEntry;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.Navigation;

public class BookmarksFrame
extends JFrame
implements TreeSelectionListener,
MouseListener {
    private JTree tree;
    private JScrollPane scrollPane;
    private BrowserControl bc;
    private Navigation navigation;
    private TreePath currentPath;

    public BookmarksFrame(TreeModel treeModel, BrowserControl browserControl) {
        super("bookmarks");
        this.getContentPane().setLayout(new BorderLayout());
        this.tree = new JTree(treeModel);
        this.scrollPane = new JScrollPane(this.tree);
        this.bc = browserControl;
        try {
            this.navigation = (Navigation)this.bc.queryInterface("webclient.Navigation");
        }
        catch (Exception exception) {
            System.out.println("BookmarksFrame Can't get Navigation from BrowserControl");
        }
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(this);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.currentPath = treeSelectionEvent.getPath();
        if (null == this.currentPath) {
            return;
        }
        System.out.println("debug: edburns: TreePath: " + this.currentPath.toString());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (null == this.currentPath || mouseEvent.getClickCount() < 2) {
            return;
        }
        Object object = this.currentPath.getLastPathComponent();
        if (!(object instanceof BookmarkEntry)) {
            return;
        }
        BookmarkEntry bookmarkEntry = (BookmarkEntry)object;
        if (!bookmarkEntry.isFolder()) {
            this.navigation.loadURL(bookmarkEntry.toString());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

