/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.InvocationEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.awt.AWTSecurityManager;
import sun.awt.MostRecentKeyValue;
import sun.awt.MostRecentThreadAppContext;
import sun.awt.SunClipboard;
import sun.awt.SunToolkit;

public final class AppContext {
    public static final Object EVENT_QUEUE_KEY = new StringBuffer("EventQueue");
    private static Hashtable threadGroup2appContext = null;
    private static AppContext mainAppContext = null;
    private final Hashtable table;
    private final ThreadGroup threadGroup;
    private boolean isDisposed = false;
    private static int numAppContexts;
    private static MostRecentThreadAppContext mostRecentThreadAppContext;
    private long DISPOSAL_TIMEOUT = 5000L;
    private long THREAD_INTERRUPT_TIMEOUT = 1000L;
    private MostRecentKeyValue mostRecentKeyValue = null;

    AppContext(ThreadGroup threadGroup) {
        ++numAppContexts;
        this.table = new Hashtable(2);
        if (threadGroup2appContext == null) {
            threadGroup2appContext = new Hashtable(2, 0.2f);
        }
        this.threadGroup = threadGroup;
        threadGroup2appContext.put(threadGroup, this);
    }

    public static final AppContext getAppContext() {
        AWTSecurityManager aWTSecurityManager;
        AppContext appContext;
        SecurityManager securityManager;
        if (numAppContexts == 1) {
            return mainAppContext;
        }
        final Thread thread = Thread.currentThread();
        AppContext appContext2 = null;
        MostRecentThreadAppContext mostRecentThreadAppContext = AppContext.mostRecentThreadAppContext;
        appContext2 = mostRecentThreadAppContext != null && mostRecentThreadAppContext.thread == thread ? mostRecentThreadAppContext.appContext : (AppContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = threadGroup = thread.getThreadGroup();
                AppContext appContext = (AppContext)threadGroup2appContext.get(threadGroup2);
                while (appContext == null) {
                    if ((threadGroup2 = threadGroup2.getParent()) == null) {
                        throw new RuntimeException("Invalid ThreadGroup");
                    }
                    appContext = (AppContext)threadGroup2appContext.get(threadGroup2);
                }
                ThreadGroup threadGroup3 = threadGroup;
                while (threadGroup3 != threadGroup2) {
                    threadGroup2appContext.put(threadGroup3, appContext);
                    threadGroup3 = threadGroup3.getParent();
                }
                AppContext.mostRecentThreadAppContext = new MostRecentThreadAppContext(thread, appContext);
                return appContext;
            }
        });
        if (appContext2 == mainAppContext && (securityManager = System.getSecurityManager()) != null && securityManager instanceof AWTSecurityManager && (appContext = (aWTSecurityManager = (AWTSecurityManager)securityManager).getAppContext()) != null) {
            appContext2 = appContext;
        }
        return appContext2;
    }

    public void dispose() throws IllegalThreadStateException {
        Object object;
        if (this.threadGroup.parentOf(Thread.currentThread().getThreadGroup())) {
            throw new IllegalThreadStateException("Current Thread is contained within AppContext to be disposed.");
        }
        AppContext appContext = this;
        synchronized (appContext) {
            if (this.isDisposed) {
                return;
            }
            this.isDisposed = true;
        }
        this.releaseClipboard();
        final Object object2 = new Object();
        Runnable runnable = new Runnable(){

            public void run() {
                Frame[] frameArray = Frame.getFrames();
                int n = frameArray.length - 1;
                while (n >= 0) {
                    frameArray[n].dispose();
                    --n;
                }
                Object object = object2;
                synchronized (object) {
                    object2.notifyAll();
                }
            }
        };
        Object object3 = object2;
        synchronized (object3) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                object2.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        runnable = new Runnable(){

            public void run() {
                Object object = object2;
                synchronized (object) {
                    object2.notifyAll();
                }
            }
        };
        Object object4 = object2;
        synchronized (object4) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                object2.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.threadGroup.interrupt();
        long l = System.currentTimeMillis();
        long l2 = l + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.threadGroup.stop();
        l = System.currentTimeMillis();
        l2 = l + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int n = this.threadGroup.activeGroupCount();
        if (n > 0) {
            object = new ThreadGroup[n];
            n = this.threadGroup.enumerate((ThreadGroup[])object);
            int n2 = 0;
            while (n2 < n) {
                threadGroup2appContext.remove(object[n2]);
                ++n2;
            }
        }
        threadGroup2appContext.remove(this.threadGroup);
        object = mostRecentThreadAppContext;
        if (object != null && object.appContext == this) {
            mostRecentThreadAppContext = null;
        }
        try {
            this.threadGroup.destroy();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        this.table.clear();
        --numAppContexts;
    }

    public Object get(Object object) {
        MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
        if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
            return mostRecentKeyValue.value;
        }
        Object object2 = this.table.get(object);
        this.mostRecentKeyValue = new MostRecentKeyValue(object, object2);
        return object2;
    }

    public Object put(Object object, Object object2) {
        MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
        if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
            mostRecentKeyValue.value = object2;
        }
        return this.table.put(object, object2);
    }

    public Object remove(Object object) {
        MostRecentKeyValue mostRecentKeyValue = this.mostRecentKeyValue;
        if (mostRecentKeyValue != null && mostRecentKeyValue.key == object) {
            mostRecentKeyValue.value = null;
        }
        return this.table.remove(object);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public String toString() {
        return this.getClass().getName() + "[threadGroup=" + this.threadGroup.getName() + "]";
    }

    private void releaseClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard instanceof SunClipboard) {
            ((SunClipboard)clipboard).clearAppContext();
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                ThreadGroup threadGroup2 = threadGroup.getParent();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                mainAppContext = new AppContext(threadGroup);
                numAppContexts = 1;
                return mainAppContext;
            }
        });
        mostRecentThreadAppContext = null;
    }
}

