/*-*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

  ***** BEGIN LICENSE BLOCK *****
* Version: MPL 1.1/GPL 2.0/LGPL 2.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is:
* ChattyTunes - a ChatZilla Media Player plugin utilizing the FoxyTunes
* Firefox Extension by Alex Sirota (alex@elbrus.com)
*
* The Initial Developers of the Original Code are:
* Oriyan Hermoni <oriyanh@gmail.com>.
*
* Portions created by Oriyan Hermoni are Copyright (C) 2005
* Oriyan Hermoni. All Rights Reserved.
*
* Contributor(s): Oriyan Hermoni
*                 David Corry <dmcorry@gmail.com> (Spellcheck)
*
* Alternatively, the contents of this file may be used under the terms of
* either the GNU General Public License Version 2 or later (the "GPL"), or
* the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
* in which case the provisions of the GPL or the LGPL are applicable instead
* of those above. If you wish to allow use of your version of this file only
* under the terms of either the GPL or the LGPL, and not to allow others to
* use your version of this file under the terms of the MPL, indicate your
* decision by deleting the provisions above and replace them with the notice
* and other provisions required by the LGPL or the GPL. If you do not delete
* the provisions above, a recipient may use your version of this file under
* the terms of any one of the MPL, the GPL or the LGPL.
*
*
****** END LICENSE BLOCK ******/

plugin.id = "eightball";

plugin.init =
function init(glob) {
    plugin.major = 0;
    plugin.minor = 5;
    plugin.version = plugin.major + "." + plugin.minor;
    plugin.description = "A small 8-ball plugin based on the answers from "
                         "Patrick Jannson's 8-ball script for irssi.";
    plugin.cmdary = [[/* comand name     function               flags    usage*/
                        "8ball",        cmd8ball, CMD_CONSOLE | CMD_NO_HELP, "<question>"]]
}

plugin.disable =
function disable ()
{
    client.commandManager.removeCommands(plugin.cmdary);
    return true;
}

plugin.enable =
function enable ()
{
    client.commandManager.argTypes["question"] = client.commandManager.argTypes["rest"];
    client.commandManager.defineCommands(plugin.cmdary);
    
    return true;
}

function cmd8ball(e)
{
    ballQue = e.question;
    var res = Math.floor(Math.random() * (16)) + 1;
    display('Your question to the 8-ball: "' + ballQue + '"');
    switch (res)
    {
        case 1 :
            ballAns = 'Yes.';
            break;
        case 2 :
            ballAns = 'No.';
            break;
        case 3 :
            ballAns = 'Absolutely.';
            break;
        case 4 :
            ballAns = "My sources say 'No'.";
            break;
        case 5 :
            ballAns = 'Yes, definitely.';
            break;
        case 6 :
            ballAns = 'Most likely.';
            break;
        case 7 :
            ballAns = 'Forget about it.';
            break;
        case 8 :
            ballAns = 'Are you kidding?';
            break;
        case 9 :
            ballAns = 'Go for it.';
            break;
        case 10 :
            ballAns = 'Not now.';
            break;
        case 11 :
            ballAns = 'Looking good.';
            break;
        case 12 :
            ballAns = "Who knows?";
            break;
        case 13 :
            ballAns = "That's a definite 'Yes'.";
            break;
        case 14 :
            ballAns = 'You\'ll have to wait and see.';
            break;
        case 15 :
            ballAns = 'Yes, but only in due time.';
            break;
        case 16 :
            ballAns = 'I have my doubts...';
            break;
        default :
            ballAns = 'It seems that there was an error with the answer of '
                      'the 8-ball. Please try again.';
    }
    
    display("8-ball's answer: \"" + ballAns + '"');
}
