/** Copyright (c) 2007-2008 eMusic.com Inc.
 
This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.  The GNU Lesser General Public License can be viewed by clicking on the following link:  http://www.gnu.org/licenses/lgpl.html#SEC4.  
 
This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

var dlm_web = {

  goThere: function(thisURL, bAppendFREF, bNewTab) {
    if (bAppendFREF) {
      if (thisURL.indexOf("?") == -1) {
        thisURL += "?fref="
      } else {
        thisURL += "&fref="
      }

      thisURL += nsPreferences.copyUnicharPref("eMusic.defaultFREF");
    }

    try {
      var gURIFixup = Components.classes["@mozilla.org/docshell/urifixup;1"]
                          .getService(Components.interfaces.nsIURIFixup);
      var fixedUpURI = gURIFixup.createFixupURI(thisURL, 0);
      
      thisURL = fixedUpURI.spec;
    } catch (ex) {
    }

    var thisReferrer = null;
    
    var mySysInfo = Components.classes["@mozilla.org/system-info;1"]
                      .getService(Components.interfaces.nsIPropertyBag2);

    var myOSVersion = encodeURIComponent(mySysInfo.getProperty("name") + "_" +  
                                    mySysInfo.getProperty("version"));

    var myAppVars  = Components.classes["@mozilla.org/xre/app-info;1"]
                       .getService(Components.interfaces.nsIXULAppInfo)
                       .QueryInterface(Components.interfaces.nsIXULRuntime);
    var myABI = myAppVars.XPCOMABI

    if (eMusicPlatform.ident == "Darwin") {
      var macutils = Components.classes["@mozilla.org/xpcom/mac-utils;1"]
                            .getService(Components.interfaces.nsIMacUtils);

      if (macutils.isUniversalBinary) {
        myABI = "Universal-gcc3";
      }
    }

    thisURL = thisURL.replace("%OS%", myOSVersion)
    thisURL = thisURL.replace("%TARGET%", myABI)

    var formatter = Components.classes["@mozilla.org/toolkit/URLFormatterService;1"]
                      .getService(Components.interfaces.nsIURLFormatter);
    thisURL = formatter.formatURL(thisURL);

    dlm_base.loadExternalURL(thisURL);

    return true;
  }
}


function TriggerInstall(aEvent, aType, aFileName) {
  var params = new Array() 
  params[aFileName] = { URL: aEvent.target.href,
                      toString: function () { return this.URL; }
  };

  if (aType == "xpi") {
    InstallTrigger.install(params);
  } else {
    InstallTrigger.installChrome(InstallTrigger.SKIN, aEvent.target.href, aFileName);
  }

  return true;
}

///////////////////////////////////////////////////////////////////////////////
// modified verion of FillInHTMLTooltip
// http://lxr.mozilla.org/mozilla1.8/source/browser/base/content/browser.js#2646
///////////////////////////////////////////////////////////////////////////////
function FillInHTMLTooltip(tipElement) {
  var retVal = false;
  if (tipElement.namespaceURI == "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul")
    return retVal;

  const XLinkNS = "http://www.w3.org/1999/xlink";

  var titleText = null;
  var titleURL = null
  var XLinkTitleText = null;

  /*while (!(titleText && titleURL) && !XLinkTitleText && tipElement) {*/
  while (!(titleText) && !XLinkTitleText && tipElement) {
    if (tipElement.nodeType == Node.ELEMENT_NODE) {
      titleText = tipElement.getAttribute("title");
      XLinkTitleText = tipElement.getAttributeNS(XLinkNS, "title");

      /*if (tipElement.href) {
        titleURL = tipElement.href;
      };*/
    }
    tipElement = tipElement.parentNode;
  }
  
  var texts = [titleText, XLinkTitleText];
  var tipNode = document.getElementById("tooltip_text");
  var tipURL = document.getElementById("tooltip_url");

  for (var i = 0; i < texts.length; ++i) {
    var t = texts[i];
    if (t && t.search(/\S/) >= 0) {
      // XXX - Short-term fix to bug 67127: collapse whitespace here
      tipNode.setAttribute("value", t.replace(/\s+/g, " ") );
      retVal = true;
    }
  }

  return retVal;
}

///////////////////////////////////////////////////////////////////////////////
// Drag and Drop
///////////////////////////////////////////////////////////////////////////////
var addonsDNDObserver = {
  _ioServ: null,
  _canDrop: false,
  
  _ensureServices: function () {
    if (!this._ioServ)
      this._ioServ = Components.classes["@mozilla.org/network/io-service;1"]
                               .getService(Components.interfaces.nsIIOService);
  },

  // returns a JS object whose properties are used by xpinstall
  _getDataFromDragSession: function (aDragSession, aPosition) {
    var fileData = { };
    // if this fails we do not have valid data to drop
    try {
      var xfer = Components.classes["@mozilla.org/widget/transferable;1"]
                           .createInstance(Components.interfaces.nsITransferable);
      xfer.addDataFlavor("text/x-moz-url");
      xfer.addDataFlavor("application/x-moz-file", "nsIFile");
      aDragSession.getData(xfer, aPosition);

      var flavour = { }, data = { }, length = { };
      xfer.getAnyTransferData(flavour, data, length);
      var selectedFlavour = this.getSupportedFlavours().flavourTable[flavour.value];
      var xferData = new FlavourData(data.value, length.value, selectedFlavour);

      var fileURL = transferUtils.retrieveURLFromData(xferData.data,
                                                      xferData.flavour.contentType);
      fileData.fileURL = fileURL;

      var uri = this._ioServ.newURI(fileURL, null, null);
      var url = uri.QueryInterface(Components.interfaces.nsIURL);
      fileData.fileName = url.fileName;

      switch (url.fileExtension) {
        case "xpi":
          fileData.type = Components.interfaces.nsIUpdateItem.TYPE_EXTENSION;
          break;
        case "jar":
          fileData.type = Components.interfaces.nsIUpdateItem.TYPE_THEME;
          break;
        default:
          return null;
      }
    } catch (e) {
      edebug(e)
      return null;
    }

    return fileData;
  },

  canDrop: function (aEvent, aDragSession) { return this._canDrop; },

  onDragEnter: function (aEvent, aDragSession) {

    // XXXrstrong - bug 269568, GTK2 drag and drop is returning invalid data for
    // dragenter and dragover. To workaround this we always set canDrop to true
    // and just use the xfer data returned in ondrop which is valid.
//@line 1134 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8/WINNT_5.2_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
    this._ensureServices();

    var count = aDragSession.numDropItems;

    for (var i = 0; i < count; ++i) {
      var fileData = this._getDataFromDragSession(aDragSession, i);
      if (!fileData) {
        this._canDrop = false;
        return;
      }
    }
//@line 1145 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8/WINNT_5.2_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
    this._canDrop = true;
  },

  onDragOver: function (aEvent, aFlavor, aDragSession) { },

  onDrop: function(aEvent, aXferData, aDragSession) {

    this._ensureServices();
    
    var xpinstallObj = { };
    var themes = { };
    var xpiCount = 0;
    var themeCount = 0;
    
    var count = aDragSession.numDropItems;
    for (var i = 0; i < count; ++i) {
      var fileData = this._getDataFromDragSession(aDragSession, i);
      if (!fileData)
        continue;

      if (fileData.type == Components.interfaces.nsIUpdateItem.TYPE_EXTENSION) {
        xpinstallObj[fileData.fileName] = fileData.fileURL;
        ++xpiCount;
      } else if (fileData.type == Components.interfaces.nsIUpdateItem.TYPE_THEME) {
        themes[fileData.fileName] = fileData.fileURL;
        ++themeCount;
      }
    }

    if (xpiCount > 0) 
      InstallTrigger.install(xpinstallObj);
    if (themeCount > 0) {
      // XXXrstrong Only allow the install of one theme due to bug 257992
      for (var fileName in themes) {
        InstallTrigger.installChrome(InstallTrigger.SKIN, themes[fileName], fileName);
        break;
      }
    }
  },

  _flavourSet: null,  

  getSupportedFlavours: function () {
    if (!this._flavourSet) {
      this._flavourSet = new FlavourSet();
      this._flavourSet.appendFlavour("text/x-moz-url");
      this._flavourSet.appendFlavour("application/x-moz-file", "nsIFile");
    }
    return this._flavourSet;
  }
};
