/** Copyright (c) 2007-2008 eMusic.com Inc.
 
This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.  The GNU Lesser General Public License can be viewed by clicking on the following link:  http://www.gnu.org/licenses/lgpl.html#SEC4.  
 
This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

if (typeof Ci == "undefined") var Ci = Components.interfaces;
if (typeof Cc == "undefined") var Cc = Components.classes;
if (typeof Cr == "undefined") var Cr = Components.results;

var eObserverService = Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService)
var eBundleService = Cc["@mozilla.org/intl/stringbundle;1"].getService(Ci.nsIStringBundleService);

const NC_NS = "http://home.netscape.com/NC-rdf#"
const dlmgrContractID = "@mozilla.org/download-manager;1"
const dlmgrIID = Ci.nsIDownloadManager
const rdfRes = Ci.nsIRDFResource
const rdfLit = Ci.nsIRDFLiteral
const rdfInt = Ci.nsIRDFInt
const rdfDate = Ci.nsIRDFDate

const VIEW_TRACKS = 0
const VIEW_ALBUMS = 1
const VIEW_AUDIOBOOKS = 2
const VIEW_MEDIA_SYNC = 3
const VIEW_BROWSER = 4

const DL_AUDIOBOOK = "Audiobooks"

var eTrackQueue = new Array();
var eActiveDownloads = new Object();
var eActiveDownloadCount = 0 //eTrackQueue.length;
var ePlaylistQueue = new Array();
var eMainObserver

var eUpdateInterval = null

const nsIThread = Ci.nsIThread;
const ThreadContractID = "@mozilla.org/thread;1";
const addMediaThreadIfc = new Components.Constructor(ThreadContractID, "nsIThread", "init");

//var eThread = Cc[ThreadContractID].createInstance(nsIThread);

if (typeof nsCI == "undefined") var nsCI  = Ci;
if (typeof nsIWebNavigation == "undefined") var nsIWebNavigation = nsCI.nsIWebNavigation;

var gDebugMode = nsPreferences.getBoolPref("eMusic.debugMode");
var gHadDownloadErrors = false;
var gHadDownloadErrorsMsg = null;
var eDefaultServer = null
var eDefaultHomePage = null
var eShowAlerts = true

var eMediaSync = null
var eMediaPlayer = null
var eMediaPlayerIcon = null

var eUpdateInterval = null

if (typeof eDownloadManager == "undefined") {
  var eDownloadManager
}

String.prototype.trim = function() {
  return this.replace(/^\s+|\s+$/g, "");
}

var dlm_base = {
  createBrandingBundle: function() {
    var myBrandingPath = null;
    var myStringBundleService = Cc["@mozilla.org/intl/stringbundle;1"]
                        .getService(Ci.nsIStringBundleService);
    
    myBrandingPath = "chrome://branding/locale/brand.properties"
    
    return myStringBundleService.createBundle(myBrandingPath);
  },

  getWindowType: function() {
    // Relies on Branding Code so can not be run on startup
    var myBrandStrings = dlm_base.createBrandingBundle();

    var thisBrandShortName = myBrandStrings.GetStringFromName("brandShortName")

    switch (thisBrandShortName) {
      case "Mozilla Thunderbird":
      case "Thunderbird":
        return "mail:3pane";
      case "Nvu":
        return "composer:html";
      case "Calendar":
      case "Sunbird":
        return "calendarMainWindow";
      case "eMusic Download Manager":
      case "eMusic Remote":
        return "emusic:window";
      case "Songbird":
        return "Songbird:Main";
      default:
        return "navigator:browser";
    }
  },
  
  toStartup: function() {
    var topWindow = dlm_base.mostRecentWindow(dlm_base.getWindowType());
  
    var params = "chrome,dialog=no,all,centerscreen"

    if (topWindow) {
      topWindow.focus();
    } else {
      window.openDialog('chrome://emusic/content/startup.xul', 'emusic:window', params)
    }
  },

  toOpenWindowByType: function(inType, uri, features, params) {
    var topWindow = dlm_base.mostRecentWindow(inType);
  
    if (!features) { features = "all,centerscreen" }

    if (topWindow) {
      topWindow.focus();
    } else {
      if (params) {
        window.openDialog(uri, "_blank", features, params);
      } else {
        window.openDialog(uri, "_blank", features);
      }
    }
  },

  toErrorConsole: function() {
    toOpenWindowByType("global:console", "chrome://global/content/console.xul", "chrome,all,centerscreen");
  },

  toConfig: function() {
    toOpenWindowByType("Preferences:ConfigManager", "chrome://global/content/config.xul", "chrome,all,centerscreen");
  },
  
  toAbout: function() {
    toOpenWindowByType("eMusic:about", "chrome://emusic/content/about.xul", "modal,chrome,titlebar,centerscreen");
  },

  toAddons: function() {
    toOpenWindowByType("Extension:Manager", "chrome://mozapps/content/extensions/extensions.xul" , "chrome,menubar,extra-chrome,toolbar,centerscreen,resizable");
  },
 
  toOptions: function(panelToFocus) {
    window.openDialog("chrome://browser/content/preferences/preferences.xul", "Browser:Preferences", "chrome,titlebar,toolbar,resizable,centerscreen,dialog=no", panelToFocus);
  },
  
  toDownloads: function() {
    toOpenWindowByType("Download:Manager", "chrome://mozapps/content/downloads/downloads.xul", "chrome,all,centerscreen");
  },

  toWizard: function() {
    window.openDialog('chrome://emusic/content/theWizard.xul', 'setup:wizard', 'chrome,modal,centerscreen,titlebar=no,alwaysRaised=yes,dependent=1', 'menu=true');
    nsPreferences.setIntPref("eMusic.last-selected." + VIEW_ALBUMS, 1)
    //showThisDeck(VIEW_ALBUMS); // replaced by observer refresh in wizard
  },  

  mostRecentWindow: function(windowType) {
    windowType = (windowType) ? windowType : dlm_base.getWindowType();
  
    var wm = Cc["@mozilla.org/appshell/window-mediator;1"].
               getService(Ci.nsIWindowMediator);
    return wm.getMostRecentWindow(windowType);
  },
  
  loadExternalURL: function(url) {
    if (url) {
      var uri = Cc["@mozilla.org/network/io-service;1"].
                    getService(Ci.nsIIOService)
      try {
        uri = uri.newURI(url, null, null);
      } catch (ex) {
        uri = uri.newFileURI(url);
      }
      var protocolSvc = Cc["@mozilla.org/uriloader/external-protocol-service;1"].
                          getService(Ci.nsIExternalProtocolService);
      protocolSvc.loadUrl(uri);
    }
  },
  
  getLocalFileInterface: function(thisPath) {
    try {
      var localFileInterface = Cc["@mozilla.org/file/local;1"].
                                 createInstance(Ci.nsILocalFile);

      localFileInterface.initWithPath(thisPath);

      return localFileInterface;
    } catch (ex) {
      return null;
    }
  },

  fileExists: function(thisPath) {
    try {
      thisPath = dlm_base.scrubPath(thisPath)
      
  		var obj_TargetFile = dlm_base.getLocalFileInterface(thisPath)
  
      return obj_TargetFile.exists()
    } catch (ex) {
      return false;
    }
  },
  
  fileSize: function(thisPath) {
    try {
      thisPath = dlm_base.scrubPath(thisPath)
      
  		var obj_TargetFile = dlm_base.getLocalFileInterface(thisPath)
  
      return obj_TargetFile.fileSize
    } catch (ex) {
      return false;
    }
  },
  
  removeFile: function(thisPath) {
    try {
      thisPath = dlm_base.scrubPath(thisPath)

  		var obj_TargetFile = dlm_base.getLocalFileInterface(thisPath)
  
      if (obj_TargetFile.exists()) {
        obj_TargetFile.remove(false)
      }
    } catch (ex) {
    }
  },

  showThisPath: function(thisPath) {

    if (!thisPath) return false;

    thisPath = dlm_base.scrubPath(thisPath)

    var iPath = this.getLocalFileInterface(thisPath);

    try {
      iPath.reveal();
    } catch (ex) {
      // if reveal failed for some reason (eg on unix it's not currently
      // implemented), send the file: URL to the OS handler for that protocol
      var thisURI = Cc["@mozilla.org/network/io-service;1"]
                    .getService(Ci.nsIIOService)
      try {
        thisURI = thisURI.newURI(iPath, null, null);
      } catch (ex) {
        try {
          thisURI = thisURI.newFileURI(iPath);
        } catch (ex) {
          thisURI = thisURI.newURI(thisPath, null, null);
        }
      }

      var protocolSvc = Cc["@mozilla.org/uriloader/external-protocol-service;1"]
                                  .getService(Ci.nsIExternalProtocolService);
      protocolSvc.loadUrl(thisURI);
    }
    return true;
  },

  clearCache: function() {
    var cacheClass = Cc["@mozilla.org/network/cache-service;1"];
    var cacheService = cacheClass.getService(Ci.nsICacheService);
  
    try {
      cacheService.evictEntries(Ci.nsICache.STORE_ON_DISK);
      cacheService.evictEntries(Ci.nsICache.STORE_IN_MEMORY);
    } catch(ex) {
    }
  },
  
  getContents: function(aURL){
    try {
      var content = "";
      var data = {};

      //http://developer.mozilla.org/en/docs/Reading_textual_data
      var file = this.getLocalFileInterface(aURL);
    
      var fstream = Cc["@mozilla.org/network/file-input-stream;1"]
                      .createInstance(Ci.nsIFileInputStream);
      fstream.init(file, 0x01, 0, 0);
  
      var cstream = Cc["@mozilla.org/intl/converter-input-stream;1"].
                     createInstance(Ci.nsIConverterInputStream);
      cstream.init(fstream, "UTF-8", 1024, Ci.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER);
      
      while (cstream.readString(4096, data)) {
        content += data.value;
      }
  
      cstream.close();
      fstream.close();
    } catch (ex) {
      edebug(ex)
    }
    return content;
  },

  writeContents: function(aFile, aContent) {
    var os = Cc["@mozilla.org/intl/converter-output-stream;1"]
                       .createInstance(Ci.nsIConverterOutputStream);

    var fos = Cc['@mozilla.org/network/file-output-stream;1']
                 .createInstance(Ci.nsIFileOutputStream);

    if (!aFile.exists()) {
      try {
        aFile.create(0x00,0755);
      } catch (ex) {
        edebug(ex);
      }
    }

    fos.init(aFile, 0x20|0x02|0x08, 0755, 0);

    os.init(fos, "UTF-8", 4096, 0x0000);

    os.writeString(aContent);

    os.close();
  },

  quit: function(aForceQuit) {
    dlm_base.flushPreferences();

    if (!aForceQuit) {
      if (eMusicPlatform.ident == "WINNT" && window.extensions && nsPreferences.getBoolPref("extensions.minimizetotray.minimize-on-close")) {
        window.extensions.mook.minimizetotray.minimizeWindow();
        return false;
      // } else {
        // window.close();
      }

    }

    if (typeof canQuitApplication == "function" && canQuitApplication()) {
      var appStartup = Cc['@mozilla.org/toolkit/app-startup;1'].
        getService(Ci.nsIAppStartup);
    
      try {
        if (mediaManagers[eMediaSync].observerObj) {
          mediaManagers[eMediaSync].cleanup();
          mediaManagers[eMediaSync].removeObserver();
        }
      } catch (ex) {
      }

      // eAttemptQuit will try to close each XUL window, but the XUL window can cancel the quit
      // process if there is unsaved data. eForceQuit will quit no matter what.
      var quitSeverity = aForceQuit ? Ci.nsIAppStartup.eForceQuit :
                                      Ci.nsIAppStartup.eAttemptQuit;
      appStartup.quit(quitSeverity);

      return true;
    }

    return false;
  },

  scrub: function(txt) {
    try {
      txt = unescape(txt);

      // Remove specific characters first
      var myRegEx = new RegExp(/[\"|\:|\_|\>|\<|\|\?|]/g);
      txt = txt.replace(myRegEx, " ");
  
      myRegEx = new RegExp(/[*|\/|\\|\#|]/g);
      txt = txt.replace(myRegEx, "-");
  
      // fix extended characters and older emp formats
      myRegEx = new RegExp(/\/g)
      txt = txt.replace(myRegEx, "'");
      
      // Trim any trialing periods
      myRegEx = new RegExp(/\.+$/g) // /\.{1,}$/g;
      txt = txt.replace(myRegEx, " ");

      // final pass to remove multiple spaces, dashes and underscores
      // that might have been created by previous regex
      myRegEx = new RegExp(/\s+/g) // /\s{2,}/g;
      txt = txt.replace(myRegEx, " ");

      myRegEx = new RegExp(/\-+/g)
      txt = txt.replace(myRegEx, "-");

      txt = txt.trim();
      
    } catch (ex) {
      edebug(ex)
    }
    return txt;
  },

  sqlScrub: function(txt, checkType) {

    try {
      txt = unescape(txt);

      if (checkType == "path") {
        var myRegEx = new RegExp(/[']/g);
        txt = txt.replace(myRegEx, "''");
      }
  
      txt = txt.trim();
    } catch (ex) {
    }
    return txt;
  },
  
  scrubPath: function(thisURL) {
    thisURL = thisURL.replace('file://localhost', '') // mac hack
    thisURL = thisURL.replace('file://', '') // linux hack

    try {
      thisURL = decodeURI(thisURL);
      thisURL = unescape(thisURL);
    } catch(ex) {
      thisURL = unescape(thisURL);
    }

    if (eMusicPlatform.ident == "WINNT" && thisURL.indexOf("http") != 0) {
      thisURL = thisURL.replace(/\//g, "\\") // fix slashes on Windows for local files
    }

    return thisURL;
  },

  padZero: function(thisString, thisLength) {

    thisString = thisString.toString();

    if (thisLength == 1) thisLength = 2

    var numZeros = thisLength - thisString.length

    if (numZeros > 0) {
      for (var i = 1; i <= numZeros; i++) {
         thisString = "0" + thisString
      }
    }
    return thisString
  },
  
  getFileExtension: function(thisURL) {
    var urlObj = Cc['@mozilla.org/network/standard-url;1']
                   .createInstance(Ci.nsIURL);
    urlObj.spec = thisURL;

    return urlObj.fileExtension.toLowerCase();
  },

  getFileScheme: function(thisURL) {
    var urlObj = Cc['@mozilla.org/network/standard-url;1']
                   .createInstance(Ci.nsIURL);
    urlObj.spec = thisURL;

    return urlObj.scheme.toLowerCase();
  },

  getSpecialFolder: function(thisType){
    // http://developer.mozilla.org/en/docs/Code_snippets:File_I/O
    var ds = Cc["@mozilla.org/file/directory_service;1"].
                 getService(Ci.nsIProperties);

    try {
      return ds.get(thisType, Ci.nsIFile);
    } catch (ex) {
      try {
        return ds.get(thisType, Ci.nsILocalFile);
      } catch (ex) {
        edebug(ex);
        edebug(thisType);
        return null;
      }
    }
  },
  
  getVendor: function() {
    return Cc['@mozilla.org/xre/app-info;1'].getService(Ci.nsIXULAppInfo).vendor;
  },

  getName: function() {
    //var myLocalStrings = eStringBundleService
    //                       .createBundle("chrome://emusic/locale/emusic.properties");
    //return myLocalStrings.GetStringFromName("appName")
    return Cc['@mozilla.org/xre/app-info;1'].getService(Ci.nsIXULAppInfo).name;
  },

  getBuildID: function() {
    return Cc['@mozilla.org/xre/app-info;1'].getService(Ci.nsIXULAppInfo).appBuildID;
  },

  getAppID: function() {
    return Cc['@mozilla.org/xre/app-info;1'].getService(Ci.nsIXULAppInfo).ID;
  },

  getAppVersion: function() {
    return Cc['@mozilla.org/xre/app-info;1'].getService(Ci.nsIXULAppInfo).version;
  },
  
  getMozIcon: function(thisPath, thisSize) {

    thisSize = (!thisSize) ? "16" : thisSize

    var tmpMozIcon = dlm_base.getLocalFileInterface(thisPath)

    var ioServ = Cc["@mozilla.org/network/io-service;1"].
                   getService(Ci.nsIIOService);

    var fph    = ioServ.getProtocolHandler("file").
                   QueryInterface(Ci.nsIFileProtocolHandler);

    try {
      return "moz-icon://" +  fph.getURLSpecFromFile(tmpMozIcon) + "?size=" + thisSize;
    } catch (ex) {
      return null
    }
  },
  
  popup: function(thisMessage, thisNotifier) {

    if (eMusicPlatform.ident == "Darwin") {
      var gabinit = Cc["@growl.info/application-bridge;1"]
        if (gabinit) {
        var gab = gabinit.getService(Ci.grIApplicationBridge);
        if (gab.growlInstalled) {
          eObserverService.notifyObservers(null, thisNotifier, thisMessage)
          return;
        }
      }
    }

    var alertWindow = dlm_base.mostRecentWindow("alert:alert");

    if (alertWindow) { alertWindow.close() }

    var thisPage = "chrome://emusic/content/newalert.xul"
    var thisChrome = "chrome,dialog=yes,titlebar=no,popup=yes"

    window.openDialog(thisPage, "alert:alert", thisChrome, thisMessage);

  },

  secondsToTime: function(thisSeconds) {
    var S = thisSeconds % 60;
    var M = (thisSeconds - S) / 60 ;

    S = dlm_base.padZero(S, 2);

    return(M + ":" + S);
  },

  browseForApp: function(thisCheckbox, thisCurrentPath, event) {
    var mlocationField = document.getElementById(thisCurrentPath)

    if (!event && mlocationField.value.length > 0) {
      nsPreferences.setUnicharPref("eMusic.defaultMediaPlayerObj", "CustomPlayer")
      return true;
    }

    var mDirPicker = Cc['@mozilla.org/filepicker;1']
                       .createInstance(Ci.nsIFilePicker)

    mDirPicker.init(window, "", mDirPicker.modeOpen);

    try {
      if (mlocationField.value.length > 0) {
        var currentLocation = Cc['@mozilla.org/file/local;1'].createInstance(Ci.nsILocalFile)
        currentLocation.initWithPath(mlocationField.value);
        mDirPicker.displayDirectory = currentLocation;
      }
    } catch (e) {
      edebug(ex);
    }
    
    mDirPicker.appendFilters(Ci.nsIFilePicker.filterApps);
    var retVal = mDirPicker.show();

    if (retVal == mDirPicker.returnOK) {
      var file = mDirPicker.file.QueryInterface(Ci.nsILocalFile);

      mlocationField.value = file.path;

      nsPreferences.mPrefService
        .setComplexValue("eMusic.defaultMediaPlayerCustom", Ci.nsILocalFile, file);

      nsPreferences.setUnicharPref("eMusic.defaultMediaPlayerObj", "CustomPlayer")
    }
    
    return false;
  },
  
  manuallySetPlayer: function(thisCurrentPath) {
    var mlocationField = document.getElementById(thisCurrentPath)
    
    try {
      if (mlocationField && mlocationField.value) {
        mlocationField = dlm_base.getLocalFileInterface(mlocationField.value);
        
        nsPreferences.mPrefService
          .setComplexValue("eMusic.defaultMediaPlayerCustom", Ci.nsILocalFile, mlocationField);
      }
    } catch (ex) {
      edebug(ex)
    }
  },
  
  flushPreferences: function() {
    var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                 .getService(Components.interfaces.nsIPrefService);
    prefService.savePrefFile(null);
  },
  
  verifyDownloadDirectory: function() {
    var folder = dlm_base.getSpecialFolder("Desk");
    folder.append("My eMusic");

    try {
      folder = nsPreferences.mPrefService.getComplexValue("eMusic.download.dir", Ci.nsILocalFile);
    } catch (ex) {
      edebug("Issue with current download directory, resetting download directory to My eMusic on desktop.")
    }

    if (!folder.exists()) {
      try {
        folder.create(0x01,0755);
      } catch (ex) {
        edebug(ex);
      }
    }

    nsPreferences.mPrefService.setComplexValue("eMusic.download.dir", Ci.nsILocalFile, folder);

  }
}

function eMuNotifier(aTopic, aData) {
  eObserverService.notifyObservers(null, aTopic, aData);
}

function eMuObserver() {
  const nsIObserverService = Components.interfaces.nsIObserverService;
  const nsIStringBundleService = Components.interfaces.nsIStringBundleService;

  this.observerService = Components.classes["@mozilla.org/observer-service;1"]
                                    .getService(nsIObserverService);
}

eMuObserver.prototype = {
  init: function init() {
    this.observerList = ["emusic-download-next", "emusic-status-update", "emusic-refresh-list", "quit-application-requested"]
    for (var eTopic in this.observerList) {
      this.observerService.addObserver(this, this.observerList[eTopic], false);
    }
  },

  observe: function observe(aSubject, aTopic, aData) {
    switch (aTopic) {
      case "emusic-download-next":
        if (typeof downloadTrack == "function") {
          downloadTrack();
        }
        break;
      case "emusic-status-update":
        if (document) {
          var thisStatusBar = document.getElementById("statusbar-display")
          if (thisStatusBar) {
            thisStatusBar.setAttribute("label", aData);
          }
        }
        break;
      case "emusic-refresh-list":
        if (typeof showThisDeck == "function") {
        //edebug("Hola!", aTopic, aData);
          showThisDeck(aData);
        }
        break;
      case "quit-application-requested":
        dlm_base.flushPreferences();

        var cancelQuit = aSubject.QueryInterface(Ci.nsISupportsPRBool);
        cancelQuit.data = false;

        toggleTotalProgress(true)

        if (eTrackQueue.length > 0 || eActiveDownloadCount > 0) {
          var myPrompts = Cc["@mozilla.org/embedcomp/prompt-service;1"]
                .getService(Ci.nsIPromptService);
          var myLocalStrings = eBundleService.createBundle("chrome://emusic/locale/emusic.properties");

          var retVal  = myPrompts.confirm(window, myLocalStrings.GetStringFromName("activeDownloadsTitle"), 
                                              myLocalStrings.GetStringFromName("activeDownloadsPrompt"));

          if (!retVal) {
            cancelQuit.data = true;
          } else {
            var lastSelected = nsPreferences.getIntPref("eMusic.last-selected." + eCurrentDeck)
            eDownloadsView.PauseResumeAll(true, true);
            nsPreferences.setIntPref("eMusic.last-selected." + eCurrentDeck, lastSelected)
          }
        }

        if (!cancelQuit.data && nsPreferences.getIntPref("eMusic.download.retention") == 1) {
          thisSQL = "delete from downloads where download_state = 1";
          eDownloadsDB.mDBConn.executeSimpleSQL(thisSQL);
        }

        break;
      default:
        Components.utils.reportError("Unexpected topic - " + aTopic);
    }
  },

  cleanUp: function() {
    if (this.observerService) {
      for (var eTopic in this.observerList) {
        this.observerService.addObserver(this, this.observerList[eTopic], false);
      }
    }
  }
};

function edebug() {
  var mConsoleService = Cc["@mozilla.org/consoleservice;1"]
         .getService(Ci.nsIConsoleService)

  try {
    mConsoleService.logStringMessage("eMusic_DLM: " + Array.join(arguments, ": ") + "\n");
  } catch (ex) {
  }
}

function addMediaThread(runable) {
  // These settings came from some source I found, they may not be correct.
  // eThread.init(runable, 0, Ci.nsIThread.PRIORITY_HIGH, 
                           // Ci.nsIThread.SCOPE_LOCAL, 
                           // Ci.nsIThread.STATE_JOINABLE);
  // eThread.join();
  var th = new addMediaThreadIfc(runable, 0, 
                         nsIThread.PRIORITY_NORMAL,
                         nsIThread.SCOPE_LOCAL,
                         nsIThread.STATE_UNJOINABLE);
  return th;
}

//var debug = edebug;

if (typeof toErrorConsole == "undefined")       var toErrorConsole = dlm_base.toErrorConsole; 
if (typeof toJavaScriptConsole == "undefined")  var toJavaScriptConsole = dlm_base.toErrorConsole;
if (typeof toOpenWindowByType == "undefined")   var toOpenWindowByType = dlm_base.toOpenWindowByType;
if (typeof toAddons == "undefined")             var toAddons = dlm_base.toAddons;
if (typeof openAddonsMgr == "undefined")        var openAddonsMgr = dlm_base.toAddons;
if (typeof openExternal == "undefined")         var openExternal = dlm_base.loadExternalURL;
if (typeof gPrefService == "undefined")         var gPrefService = Cc["@mozilla.org/preferences-service;1"]
                                                                      .getService( Ci.nsIPrefBranch);

if (typeof dlm_web == "object" && typeof openUILink == "undefined") var openUILink = dlm_web.goThere; // keep for generic bindings


function assocSort(oAssoc) {
  var idx; var key; var arVal = []; var arValKey = []; var oRes = {};

  for (key in oAssoc) {
    arVal[arVal.length] = oAssoc[key];
    arValKey[oAssoc[key]] = key;
  }

  arVal.sort();

  for (idx in arVal)
    oRes[arValKey[arVal[idx]]] = arVal[idx];
  return oRes;
}

function prepMediaManagers(iconSize) {
  var tblBody = document.getElementById("mediaTbl")

  var thisMediaSync = nsPreferences.copyUnicharPref("eMusic.defaultMediaSync")

  if (!iconSize) iconSize = 16
  
  if (tblBody) {
    tblBody = tblBody.tBodies[0];
  }
  
  var prefWindow = document.getElementById("BrowserPreferences");
  if (prefWindow){
    var emusicWindow = dlm_base.mostRecentWindow("emusic:window");
    if (emusicWindow) {
      mediaManagers = emusicWindow.mediaManagers;
    } else {
    }
  }

  var tmpMediaManagers = new Array()
  for (key in mediaManagers) {
    tmpMediaManagers.push(key);
  }

  tmpMediaManagers.sort();

  var alternateBars = 0

  for (thisManager in tmpMediaManagers) {
    thisManager = tmpMediaManagers[thisManager]
    try {
      var tmpInit = mediaManagers[thisManager].init();
      
      if (!tmpInit) continue
      
      // edebug(mediaManagers[thisManager].getAppName() + ": " + tmpInit)
      // edebug(mediaManagers[thisManager].getAppPath())
      
      if (tblBody) {
        var mozIconPath = dlm_base.getMozIcon(mediaManagers[thisManager].getAppPath(), iconSize)

        var newRow = tblBody.insertRow(1);
        if (alternateBars%2) {
          newRow.setAttribute("class", "rOdd")
        } else {
          newRow.setAttribute("class", "rEven")
        }

        var newCell = newRow.insertCell(0);
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("width", iconSize)
        newCell.setAttribute("align", "center")
        var newInput = document.createElement("image");
        newInput.setAttribute("src", mozIconPath)
        newInput.setAttribute("height", iconSize)
        newInput.setAttribute("width", iconSize)
        newInput.setAttribute("alt", "")
        newInput.setAttribute("onclick", "mediaManagers['" + thisManager + "'].launch(); event.stopPropagation();")
        newCell.appendChild(newInput)

        var HTMLNS = "http://www.w3.org/1999/xhtml";

        newCell = newRow.insertCell(1)
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("align", "center")
        newInput = document.createElementNS(HTMLNS, "html:input")
        newInput.setAttribute("type", "radio")
        newInput.setAttribute("id", "sync-" + thisManager)
        newInput.setAttribute("name", "sync")
        newInput.setAttribute("onclick", "mediaManagers['" + thisManager + "'].setAsDefaultSync();")
        if (thisManager == thisMediaSync) {
          newInput.setAttribute("checked", "")
        }
        newCell.appendChild(newInput)

        newCell = newRow.insertCell(2);
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("onclick", "mediaManagers['" + thisManager + "'].setAsDefaultSync();")
        newCell.appendChild(document.createTextNode(mediaManagers[thisManager].getAppName()));

        newCell = newRow.insertCell(3);
        //newCell.setAttribute("width", "10")
        newCell.setAttribute("class", "mediaTitleCenterCell")

        var newCell = newRow.insertCell(4);
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("width", iconSize)
        newCell.setAttribute("align", "center")
        var newInput = document.createElement("image");
        newInput.setAttribute("src", mozIconPath)
        newInput.setAttribute("height", iconSize)
        newInput.setAttribute("width", iconSize)
        newInput.setAttribute("alt", "")
        newInput.setAttribute("onclick", "mediaManagers['" + thisManager + "'].launch(); event.stopPropagation();")
        newCell.appendChild(newInput)

        newCell = newRow.insertCell(5)
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("align", "center")
        newInput = document.createElementNS(HTMLNS, "html:input")
        newInput.setAttribute("type", "radio")
        newInput.setAttribute("name", "player")
        newInput.setAttribute("id", "player-" + thisManager)
        newInput.setAttribute("onclick", "mediaManagers['" + thisManager + "'].setAsDefaultPlayer();")
        if (thisManager == nsPreferences.copyUnicharPref('eMusic.defaultMediaPlayerObj')) {
          newInput.setAttribute("checked", "")
        }
        newCell.appendChild(newInput);

        newCell = newRow.insertCell(6);
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("onclick", "mediaManagers['" + thisManager + "'].setAsDefaultPlayer();")
        newCell.appendChild(document.createTextNode(mediaManagers[thisManager].getAppName()));

        alternateBars++
      }
    } catch (ex) {
      edebug(ex);
    }
  }
}

function getRDFProperty(aID, aProperty, aDS) {
  
  if (!aID) return ""

  var rdf = Cc["@mozilla.org/rdf/rdf-service;1"]
              .getService(Ci.nsIRDFService);

  if (!aDS) {
    aDS = eDownloadManager.datasource;
  }

  var propertyArc = rdf.GetResource(NC_NS + aProperty);
  
  var res = rdf.GetResource(aID);
  var node = aDS.GetTarget(res, propertyArc, true);

  if (!node) return "";

  try {
    node = node.QueryInterface(Ci.nsIRDFLiteral);
    return node.Value;
  } catch (ex) {
    try {
      node = node.QueryInterface(Ci.nsIRDFInt);
      return node.Value;
    } catch (ex) {
      try {
        node = node.QueryInterface(Ci.nsIRDFDate);
        return node.Value;
      } catch (ex) {
        node = node.QueryInterface(Ci.nsIRDFResource);
        return node.Value;
      }
    }
  }
  return "";
}

function switchFocus(elem) {
  var mediator = Components.classes["@mozilla.org/rdf/datasource;1?name=window-mediator"].getService();
  mediator.QueryInterface(Components.interfaces.nsIWindowDataSource);

  var resource = elem.getAttribute('id');
  var switchwindow = mediator.getWindowForResource(resource);

  if (switchwindow){
    switchwindow.focus();
  }
}

function refreshDefaultPlayer() {
  var prefs = nsPreferences.mPrefService;
  var branchService = Cc["@mozilla.org/preferences-service;1"]
                        .getService(Ci.nsIPrefBranch);

  eMediaSync = nsPreferences.copyUnicharPref("eMusic.defaultMediaSync")
  eMediaPlayer = nsPreferences.copyUnicharPref("eMusic.defaultMediaPlayerObj")

  // check if current syncing preference is no longer installed or is disabled, reset it
  if (eMediaSync != "NoSync" && mediaManagers && (!mediaManagers[eMediaSync] || !mediaManagers[eMediaSync].isInstalled())) {
    nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "NoSync")

    if (mediaManagers["WMP"] && mediaManagers["WMP"].isInstalled()) {
      nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "WMP")
    }

    if (mediaManagers["Winamp"] && mediaManagers["Winamp"].isInstalled()) {
      nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "Winamp")
    }

    if (mediaManagers["iTunes"] && mediaManagers["iTunes"].isInstalled()) {
      nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "iTunes")
    }

    eMediaSync = nsPreferences.copyUnicharPref("eMusic.defaultMediaSync")
  }

  // check again in case default syncing is not installed or is disabled, then set to no sync
  if (mediaManagers && !mediaManagers[eMediaSync] && !branchService.prefHasUserValue("eMusic.defaultMediaSync")) {
    nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "NoSync")
    eMediaSync = "NoSync";
  }

  // check if current player preference is not installed or disabled and reset it
  if (eMediaPlayer != "CustomPlayer" && mediaManagers && !mediaManagers[eMediaPlayer] && branchService.prefHasUserValue("eMusic.defaultMediaPlayerObj")) {
    branchService.clearUserPref("eMusic.defaultMediaPlayerObj")
    eMediaPlayer = nsPreferences.copyUnicharPref("eMusic.defaultMediaPlayerObj")
  }

  if (branchService.prefHasUserValue("eMusic.defaultMediaPlayerCustom")) {
    var mediaCustomPlayerApp = prefs.getComplexValue("eMusic.defaultMediaPlayerCustom",
                                 Ci.nsILocalFile);

    var mlocationField = document.getElementById("player-CustomPlayerPath")
    if (mlocationField) {
      mlocationField.value = mediaCustomPlayerApp.path;
    }
  }

  var emusicWindow = dlm_base.mostRecentWindow("emusic:window");
  var wizardWindow = dlm_base.mostRecentWindow("emusic:wizard");
  var prefWindow = dlm_base.mostRecentWindow("emusic:preferences");

  if (!eMediaPlayer || !eMediaSync 
      || (emusicWindow && !emusicWindow.document.getElementById("player-" + eMediaPlayer))
      || (emusicWindow && !emusicWindow.document.getElementById("sync-" + eMediaSync))) {
    edebug("Error in selecting Media Player and/or Default Syncing Icons");
    edebug(eMediaPlayer, eMediaSync)
    return;
  }

  if (emusicWindow) {
    emusicWindow.document.getElementById("player-" + eMediaPlayer).checked = true;
    emusicWindow.document.getElementById("sync-" + eMediaSync).checked = true;
  }

  if (wizardWindow) {
    wizardWindow.document.getElementById("sync-" + eMediaSync).checked = true;
    if (eMediaPlayer != "CustomPlayer") {
      wizardWindow.document.getElementById("player-" + eMediaPlayer).checked = true;
    }
  }
  
  if (prefWindow) {
    prefWindow.document.getElementById("sync-" + eMediaSync).checked = true;
    if (eMediaPlayer != "CustomPlayer") {
      prefWindow.document.getElementById("player-" + eMediaPlayer).checked = true;
    }
  }

  var mediaPlayerButton = document.getElementById("defaultPlayerButton")
  if (mediaPlayerButton) {
    if (eMediaSync == "NoSync") {
      document.getElementById("launchPlayerLabel").setAttribute("hidden", true);
      mediaPlayerButton.src = "chrome://emusic/skin/syncDisable_small.png";
    } else if (mediaManagers[eMediaSync]) {
      document.getElementById("launchPlayerLabel").setAttribute("hidden", false);
      document.getElementById("launchPlayerLabel").value = "launch " + mediaManagers[eMediaSync].getAppName();

      eMediaPlayerIcon = dlm_base.getMozIcon(mediaManagers[eMediaSync].getAppPath(), "16")
      mediaPlayerButton.src = eMediaPlayerIcon;
    }
  }
}

function DefaultPlayer() {
  this.observerObj = null
  this.observerInitialized = false

  this.appName = "System Default" // default name can be overwritten by getAppName()
  this.corePlayerObj = "DefaultPlayer"  // must match constructor name
  this.arrRegAppPath = new Array  // registry keys to try to find install base and/or exe name
  this.arrFileAppPath = new Array // hardcoded uri to do dumb look up if registries or other lookups fail
  this.arrRegMediaLibraryPath = new Array  // registry keys to search for music library
  this.arrRegAppVersion= new Array // registry keys to find app version (if needed)
  this.arrAppName = new Array
  this.appPath = null

  this.observer = {
    QueryInterface: function (iid) {
      if (iid.equals(Ci.nsISupports) || iid.equals(Ci.nsIObserver))
        return this;

      throw Components.results.NS_ERROR_NO_INTERFACE;
    },

    observe: function (subject, topic, data) {
      edebug("OBSERVER", topic, data, subject);
    }
  }
}

DefaultPlayer.prototype = {
  init: function() {
    // initialize all settings
    return false;
  },
  
  launch: function() {
  },
  
  syncMedia: function(thisFile) {
  },
  
  setAsDefaultPlayer: function() {
    nsPreferences.setUnicharPref("eMusic.defaultMediaPlayer", this.corePlayerObj)
    nsPreferences.setUnicharPref("eMusic.defaultMediaPlayerObj", this.corePlayerObj)
    edebug(this.appName + " set as default playa")
  },
  
  setAsDefaultSync: function(){
    nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "NoSync")
    edebug("syncing disabled")
  },
  
  isInstalled: function() {
    return true;
  },
  
  getAppName: function() {
    return this.appName;
  },
  
  getMediaFolder: function() {
    return null;
  },

  canSync: function() {
  },
  
  canPlay: function() {
  },
  
  getAppPath: function() { // just in case we need to do customize
    return this.appPath
  },
  
  getAppExecFilename: function() {
  },
  
  getAppVersion: function() {
    return null;
  },
  
  initObserver: function() {
    this.observerInitialized = true;
  },

  removeObserver: function() {
  },
  
  cleanup: function() {
  }
  
}

if (typeof mediaManagers == "undefined") {
  var mediaManagers = new Array
  mediaManagers["DefaultPlayer"] = new DefaultPlayer
}

function sqliteObj() {
}

sqliteObj.prototype = {
  file: "",
  createStatement: "",
  storageService: Cc["@mozilla.org/storage/service;1"]
                    .getService(Ci.mozIStorageService),
  mDBConn: "",
  insertParams1: "",
  insertParams2: "",

	init: function(dbfile){
    if (dbfile) { this.file = dbfile}

		var db = dlm_base.getSpecialFolder("ProfD");
		db.append(this.file);

		this.mDBConn = this.storageService.openDatabase(db);
  }

}

var eDownloadsDB = new sqliteObj

eDownloadsDB.init("edownloads.sqlite");
