/*
    * WINNT for Windows NT, 2000, XP and later
    * Linux for all Linux versions
    * Darwin for all MacOS X versions 
    */

var eMusicPlatform = {
  flashRoot: "AppData",
  height: "600",
  width: "800",
  xOffset: "0",
  yOffset: "0",
  windowState: "",

  ident: Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo)
                  .QueryInterface(Components.interfaces.nsIXULRuntime)
                  .OS,
  
  newline: "\r\n",
  
  downloadDirectory: null,
  
  firstTimeRun: function() {
    var thisRegBase = eMusicRegistry.eMusicBaseReg;

    var prefs = nsPreferences.mPrefService;
    var branchService = Components.classes["@mozilla.org/preferences-service;1"]
                                   .getService(Components.interfaces.nsIPrefBranch);

    // -- download directory settings 
    var thisPath = dlm_base.getSpecialFolder("Desk");
    thisPath.append("My eMusic");

    /* --- old registry entries (Windows Only) */
    eMusicPlatform.downloadDirectory = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "DownloadDirectory")

    if (eMusicPlatform.downloadDirectory) {
      try {
        thisPath = dlm_base.getLocalFileInterface(eMusicPlatform.downloadDirectory);
      } catch (ex) {
      }
    }

    if (branchService.prefHasUserValue("eMusic.download.dir")) {
      try {
        thisPath = prefs.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile)    
      } catch (ex) {
        edebug(ex)
      }
    } else  {
      prefs.setIntPref("eMusic.download.folderList", 2);
    }
    
    if (!thisPath.exists()) {
      // Make sure that path can and are created
      try {
        thisPath.create(0x01,0755);
      } catch (ex) {
        edebug(ex);
      }
    }

    try {
      prefs.setComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile, thisPath);
      prefs.setComplexValue("eMusic.download.downloadDir", Components.interfaces.nsILocalFile, thisPath);
    } catch (ex) {
      dlm_base.verifyDownloadDirectory()
    }

    nsPreferences.setBoolPref("extensions.hyper.firsttime", false);
    nsPreferences.setBoolPref("extensions.hyper.inpagesuggestion", false);
    nsPreferences.setBoolPref("extensions.hyper.inpagesuggestionA", false);

  },
  
  minimizeWindow: function() {
    window.minimize();
  },
  
  zoomWindow: function() {
    if (window.windowState == STATE_NORMAL) {
      window.maximize();
    } else {
      window.restore();
    }
  }
}


var nsIWindowsRegKey = Components.interfaces.nsIWindowsRegKey;

var winRegKeys = new Array

winRegKeys["HKCU"] = nsIWindowsRegKey.ROOT_KEY_CURRENT_USER
winRegKeys["HKLM"] = nsIWindowsRegKey.ROOT_KEY_LOCAL_MACHINE
winRegKeys["HKCR"] = nsIWindowsRegKey.ROOT_KEY_CLASSES_ROOT

var eMusicRegistry = {

  eMusicBaseReg: "Software\\eMusic\\eMusic Download Manager\\Application",

  getValue: function(thisKey, thisBase, thisReg) {
    var registryObj = Components.classes["@mozilla.org/windows-registry-key;1"]
                        .createInstance(nsIWindowsRegKey);
    var retVal = null;

    try {
      registryObj.open(thisKey, thisBase, nsIWindowsRegKey.ACCESS_READ);
  
      if (registryObj.hasValue(thisReg)) {
        switch (registryObj.getValueType(thisReg)) {
          case registryObj.TYPE_BINARY:
            retVal = registryObj.readBinaryValue(thisReg);
            break;
          case registryObj.TYPE_INT:
            retVal = registryObj.readIntValue(thisReg);
            break;
          case registryObj.TYPE_INT64:
            retVal = registryObj.readInt64Value(thisReg);
            break;
          default: //case registryObj.TYPE_STRING:
            retVal = registryObj.readStringValue(thisReg);
            break;
        }
      }
  
      registryObj.close();
  
      return retVal;
    } catch (ex) {
      registryObj.close();
      return null;
    }                                                                           
  },

  setValue: function(thisKey, thisBase, thisReg, thisValue, thisType) {

    var registryObj = Components.classes["@mozilla.org/windows-registry-key;1"]
                        .createInstance(nsIWindowsRegKey);
    var retVal = null; 
    

    try {
      registryObj.open(thisKey, thisBase, nsIWindowsRegKey.ACCESS_ALL);                                                
  
      if (!thisType) thisType = registryObj.TYPE_STRING

      if (registryObj.hasValue(thisReg)) {
        thisType = registryObj.getValueType(thisReg)
      }
  
      switch (thisType) {
        case registryObj.TYPE_BINARY:
          retVal = registryObj.writeBinaryValue(thisReg, thisValue);
          break;
        case registryObj.TYPE_INT:
          retVal = registryObj.writeIntValue(thisReg, thisValue);
          break;
        case registryObj.TYPE_INT64:
          retVal = registryObj.writeInt64Value(thisReg, thisValue);
          break;
        default: //case registryObj.TYPE_STRING:
          retVal = registryObj.writeStringValue(thisReg, thisValue);
          break;
      }

      registryObj.close();
  
      return retVal;                                                                           
    } catch (ex) {
      edebug(ex)
      registryObj.close();
      return null;
    }                                                                           
  },
  
  resetStartup: function() {

    try {
      var PROXY_BASE = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings"
      var proxyAutoConfigURL = eMusicRegistry.getValue(winRegKeys["HKCU"], PROXY_BASE, "AutoConfigURL")
        
      var proxyProxyEnable = eMusicRegistry.getValue(winRegKeys["HKCU"], PROXY_BASE, "ProxyEnable");
      
      if (proxyAutoConfigURL && proxyAutoConfigURL != null) {
        nsPreferences.setUnicharPref("network.proxy.autoconfig_url", proxyAutoConfigURL)
        nsPreferences.setIntPref("network.proxy.type", 2)
      //} else {
        // nsPreferences.setIntPref("network.proxy.type", 0)
      }

      if (proxyProxyEnable == "1") {
        var proxyProxyServer = eMusicRegistry.getValue(winRegKeys["HKCU"], PROXY_BASE, "ProxyServer");
        proxyProxyServer = proxyProxyServer.replace(";;", ";");
        proxyProxyServer = proxyProxyServer.split(";");

        var proxyProxyServerObj = proxyProxyServer[0].split(":");
        
        proxyProxyServerObj[0] =  proxyProxyServerObj[0].replace("http=", "")

        //edebug(proxyProxyServerObj[0], proxyProxyServerObj[1])

        nsPreferences.setUnicharPref("network.proxy.http", proxyProxyServerObj[0])
        nsPreferences.setIntPref("network.proxy.http_port", proxyProxyServerObj[1])
        
        nsPreferences.setUnicharPref("network.proxy.ssl", proxyProxyServerObj[0])
        nsPreferences.setIntPref("network.proxy.ssl_port", proxyProxyServerObj[1])

        nsPreferences.setIntPref("network.proxy.type", 1)
        nsPreferences.setBoolPref("network.proxy.share_proxy_settings", true)
        
      }
    } catch (ex) {
      edebug("Error reading Network Proxy settings\n\n", ex)
    }

    //http://developer.mozilla.org/en/docs/Accessing_the_Windows_Registry_Using_XPCOM
    var registryObj = Components.classes["@mozilla.org/windows-registry-key;1"]
                        .createInstance(nsIWindowsRegKey);

    var REG_BASE1 = "eMusicList\\shell\\open\\command";

    var installFolder = dlm_base.getSpecialFolder("resource:app");
  	installFolder.append("emusic_dlm.exe");
    
    try { // avoid non-admin access, ie: vista
      //registryObj.open(winRegKeys["HKCR"], REG_BASE1, nsIWindowsRegKey.ACCESS_WRITE);
      registryObj.create(winRegKeys["HKCR"], REG_BASE1, nsIWindowsRegKey.ACCESS_WRITE);
      registryObj.writeStringValue("", '"' + installFolder.path + '" "%1"');
      registryObj.close();
    } catch (ex) {
      edebug(ex);
      edebug("Couldn't write launch setting to registry, must have admin rights");
      registryObj.close();
    }
    
    try {
      var myLocalStrings = eStringBundleService
                             .createBundle("chrome://emusic/locale/emusic.properties");
      var appVersion = Components.classes['@mozilla.org/xre/app-info;1']
                         .getService(Components.interfaces.nsIXULAppInfo).version

      var REG_BASE3 = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + myLocalStrings.GetStringFromName("appName");

      registryObj.create(winRegKeys["HKLM"], REG_BASE3, nsIWindowsRegKey.ACCESS_WRITE);
      registryObj.writeStringValue("DisplayName", myLocalStrings.GetStringFromName("appName") + " " + appVersion);
      registryObj.writeStringValue("DisplayVersion", appVersion);

      registryObj.close();
    } catch (ex) {
      registryObj.close();
    }
  }

}

var legacyImport = {
  thisPausedDownloads: null,
  trackTotal: 0,
  currentTrack: 0,
  allTracks: null,

  init: function() {
    // import old download library
    var thisRegBase = eMusicRegistry.eMusicBaseReg;
    legacyImport.thisPausedDownloads = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "TempDirectory")

    if (legacyImport.thisPausedDownloads) {
      legacyImport.thisPausedDownloads += "\\PausedDownloads.xml";

      try {
        var obj_TargetFile = dlm_base.getLocalFileInterface(legacyImport.thisPausedDownloads);

        if (obj_TargetFile.exists()) {
          eWizard.importLegacy = true;
        }
      } catch (ex) {
        edebug(ex)
      }
    }
  },
  
  legacyKickOff: function() {
    var thisRegBase = eMusicRegistry.eMusicBaseReg;

    /* --- old registry entries (Windows Only) */
    eMusicPlatform.downloadDirectory = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "DownloadDirectory")

    if (eMusicPlatform.downloadDirectory) {
      var thisPath = dlm_base.getLocalFileInterface(eMusicPlatform.downloadDirectory);
      prefs.setComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile, thisPath);
      prefs.setComplexValue("eMusic.download.downloadDir", Components.interfaces.nsILocalFile, thisPath);
    }

    var thisFileNamingTemplate      = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "FileNamingTemplate")
    var thisFileNamingSeparator     = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "FileNamingSeparator")
    var thisCreateAlbumDirectory    = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "CreateAlbumDirectory")
    var thisCreateArtistDirectory   = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "CreateArtistDirectory")
    var thisAutoClearCancelled      = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "AutoClearCancelled")
    var thisQuitWhenDone            = eMusicRegistry.getValue(winRegKeys["HKCU"], thisRegBase, "QuitWhenDone")
    
    if (thisFileNamingSeparator)    nsPreferences.setUnicharPref("eMusic.FileNamingSeparator", thisFileNamingSeparator);
    if (thisFileNamingTemplate)     nsPreferences.setUnicharPref("eMusic.FileNamingTemplate", thisFileNamingTemplate);
    
    if (thisCreateAlbumDirectory)   nsPreferences.setBoolPref("eMusic.CreateAlbumDirectory", thisCreateAlbumDirectory);
    if (thisCreateArtistDirectory)  nsPreferences.setBoolPref("eMusic.CreateArtistDirectory", thisCreateArtistDirectory);
    if (thisAutoClearCancelled)     nsPreferences.setBoolPref("eMusic.AutoClearCancelled", thisAutoClearCancelled);
    if (thisQuitWhenDone)           nsPreferences.setBoolPref("eMusic.QuitWhenDone", thisQuitWhenDone);
    
    // import filenaming template
    if (thisFileNamingTemplate) {
      var NameParts = thisFileNamingTemplate.split(thisFileNamingSeparator)

      nsPreferences.setBoolPref("eMusic.template.track", true);
      nsPreferences.setBoolPref("eMusic.template.artist", false);

      for (var i = 0; i < NameParts.length; i++) {
        if (NameParts[i] != "track") {
          nsPreferences.setBoolPref("eMusic.template." + NameParts[i], true);
        }
      }
    }

    document.getAnonymousElementByAttribute(document.getElementById('eWizard'), 'anonid', 'Header')
      .setAttribute("label", "Importing Download Manager 3.0 Settings...")

    document.getElementById("importButtons").hidden = true;

    document.getElementById('eWizard').getButton("back").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("next").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "true")
    document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "true")

    var thisCountStatus = document.getElementById("import-count")
    thisCountStatus.setAttribute("value", "");

    var thisStatusBar = document.getElementById("status-display")
    thisStatusBar.setAttribute("value", "Preparing DLM 3.0 Track List...");

    setTimeout(function(){legacyImport.parseLegacy()}, 100);

    return true;
  },

  parseLegacy: function() {

    var thisCountStatus = document.getElementById("import-count")

    var thisStatusBar = document.getElementById("status-display")
    thisCountStatus.setAttribute("style", "font-size: 45px; font-weight: bold;")

    var baseStatusMsg = "Importing DLM 3.0 Track List"
    thisStatusBar.setAttribute("value", baseStatusMsg);

    document.getElementById("skipImport").hidden = false;

    var myDownloadList = dlm_base.getContents(legacyImport.thisPausedDownloads)

    // make the eMusic mess correct base64 - from original perl script y@._-@+/=@
    myDownloadList = myDownloadList.replace(/\./g,"+");
    myDownloadList = myDownloadList.replace(/\_/g,"/");
    myDownloadList = myDownloadList.replace(/\-/g,"=");

    var parsed64 = atob(myDownloadList)
    var decryptedEMP = rc4Decrypt("kljsdmcjh3,m4hod87lkjh43iuydfkjhsdufyklmnsdfysd8of34kh", parsed64)

//edebug(decryptedEMP)
    var xmlParser = new DOMParser();
    var xmlDoc = xmlParser.parseFromString(decryptedEMP, "text/xml");

    // Traverse through all tracks that are available
    legacyImport.allTracks = xmlDoc.getElementsByTagName("TRACK");

    legacyImport.trackTotal = legacyImport.allTracks.length

    eDownloadsDB.mDBConn.beginTransactionAs(eDownloadsDB.mDBConn.TRANSACTION_DEFERRED);

    setTimeout(legacyImport.insertLegacy, 100);
  },

  insertLegacy: function() {

    var thisCountStatus = document.getElementById("import-count")
    var thisStatusBar = document.getElementById("status-display")
    //var thisCount
  
    try {
      var thisTrack = legacyImport.allTracks[legacyImport.currentTrack];
      var objDownloadItem = {};
      
      var TRACKURL = thisTrack.getElementsByTagName("LOCATION")[0].firstChild.data;

      // http://dl.emusic.com/dl/key/11107474/15983768/Big_Bang_Theory_Theme.mp3
      var splitAttack = TRACKURL.split("/");

      objDownloadItem["ALBUMID"]     = splitAttack[5];
      objDownloadItem["ALBUM"]       = thisTrack.getElementsByTagName("ALBUM")[0].firstChild.data;
      objDownloadItem["ALBUMURL"]    = "http://www.emusic.com/";
      objDownloadItem["ALBUMART"]    = thisTrack.getElementsByTagName("ALBUMART")[0].firstChild.data;
      objDownloadItem["ARTIST"]      = thisTrack.getElementsByTagName("ARTIST")[0].firstChild.data;
      objDownloadItem["ARTISTID"]    = 0;
      objDownloadItem["ARTISTURL"]   = "http://www.emusic.com/";
      objDownloadItem["GENRE"]       = thisTrack.getElementsByTagName("GENRE")[0].firstChild.data;
      objDownloadItem["GENREID"]     = 0;
      objDownloadItem["GENREURL"]    = "http://www.emusic.com/";
      objDownloadItem["LABEL"]       = "";
      objDownloadItem["LABELID"]     = 0;
      objDownloadItem["LABELURL"]    = "http://www.emusic.com/";
      objDownloadItem["STYLES"]      = "";
     
      objDownloadItem["TRACKID"]     = splitAttack[6];
      if (typeof thisTrack.getElementsByTagName("SAVENAME")[0] != "undefined") {
        objDownloadItem["LOCALFILE"]   = thisTrack.getElementsByTagName("SAVENAME")[0].firstChild.data;  //thisTrack.getElementsByTagName("FILENAME")[0].firstChild.data;
      } else {
        objDownloadItem["LOCALFILE"]   = ""
      }
      objDownloadItem["TRACKURL"]    = TRACKURL;
      objDownloadItem["TITLE"]       = thisTrack.getElementsByTagName("TITLE")[0].firstChild.data;
      objDownloadItem["TRACKNUM"]    = thisTrack.getElementsByTagName("TRACKNUM")[0].firstChild.data;
      objDownloadItem["DURATION"]    = dlm_base.secondsToTime(thisTrack.getElementsByTagName("DURATION")[0].firstChild.data);
      objDownloadItem["DISCNUM"]     = 1;
      objDownloadItem["DISCCOUNT"]   = 1;
      objDownloadItem["TRACKCOUNT"]  = 0;

      if (objDownloadItem["LOCALFILE"] && objDownloadItem["LOCALFILE"] != "" &&
          objDownloadItem["ALBUMID"] && objDownloadItem["ALBUMID"] && 
          objDownloadItem["ALBUMID"] != "" && objDownloadItem["ALBUMID"] != "0") {
        //sqliteInsertDownload(objDownloadItem, true);
        var newDate = new Date()
        var sqlUpgradeStatement = eDownloadsDB.mDBConn.createStatement("INSERT INTO albums(albumid, album, album_url, album_art_url, artist, artist_id, artist_url, genre, genre_id, genre_url, label_name, label_id, label_url, styles, percent_complete) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

        sqlUpgradeStatement.bindInt32Parameter(0, objDownloadItem["ALBUMID"]);
        sqlUpgradeStatement.bindUTF8StringParameter(1, objDownloadItem["ALBUM"]);
        sqlUpgradeStatement.bindUTF8StringParameter(2, objDownloadItem["ALBUMURL"]);
        sqlUpgradeStatement.bindUTF8StringParameter(3, objDownloadItem["ALBUMART"]);
        sqlUpgradeStatement.bindUTF8StringParameter(4, objDownloadItem["ARTIST"]);
        sqlUpgradeStatement.bindInt32Parameter(5, objDownloadItem["ARTISTID"]);
        sqlUpgradeStatement.bindUTF8StringParameter(6, objDownloadItem["ARTISTURL"]);
        sqlUpgradeStatement.bindUTF8StringParameter(7, objDownloadItem["GENRE"]);
        sqlUpgradeStatement.bindInt32Parameter(8, objDownloadItem["GENREID"]);
        sqlUpgradeStatement.bindUTF8StringParameter(9, objDownloadItem["GENREURL"]);
        sqlUpgradeStatement.bindUTF8StringParameter(10, objDownloadItem["LABEL"]);
        sqlUpgradeStatement.bindInt32Parameter(11, objDownloadItem["LABELID"]);
        sqlUpgradeStatement.bindUTF8StringParameter(12, objDownloadItem["LABELURL"]);
        sqlUpgradeStatement.bindUTF8StringParameter(13, objDownloadItem["STYLES"]);
        sqlUpgradeStatement.bindInt32Parameter(14, 100);

        try {
          var rc =  sqlUpgradeStatement.executeStep();
        } catch (ex) {
          edebug(eDownloadsDB.mDBConn.lastErrorString)
          //edebug(ex)
        } finally {
          sqlUpgradeStatement.reset();
        }
  
        sqlUpgradeStatement = eDownloadsDB.mDBConn.createStatement("INSERT INTO downloads(trackid, filename, src_url, album_id, album, track_name, track_number, track_count, duration, disc_number, disc_count, start_date, end_date, download_state, percent_complete) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

        sqlUpgradeStatement.bindInt32Parameter(0, objDownloadItem["TRACKID"]);
        sqlUpgradeStatement.bindUTF8StringParameter(1, objDownloadItem["LOCALFILE"]);
        sqlUpgradeStatement.bindUTF8StringParameter(2, objDownloadItem["TRACKURL"]);
        sqlUpgradeStatement.bindInt32Parameter(3, objDownloadItem["ALBUMID"]);
        sqlUpgradeStatement.bindUTF8StringParameter(4, objDownloadItem["ALBUM"]);
        sqlUpgradeStatement.bindUTF8StringParameter(5, objDownloadItem["TITLE"]);
        sqlUpgradeStatement.bindInt32Parameter(6, objDownloadItem["TRACKNUM"]);
        sqlUpgradeStatement.bindInt32Parameter(7, objDownloadItem["TRACKCOUNT"]);
        sqlUpgradeStatement.bindUTF8StringParameter(8, objDownloadItem["DURATION"]);
        sqlUpgradeStatement.bindInt32Parameter(9, objDownloadItem["DISCNUM"]);
        sqlUpgradeStatement.bindInt32Parameter(10, objDownloadItem["DISCCOUNT"]);
        sqlUpgradeStatement.bindUTF8StringParameter(11, newDate.getTime());
        sqlUpgradeStatement.bindUTF8StringParameter(12, newDate.getTime());
        sqlUpgradeStatement.bindInt32Parameter(13, 1);
        sqlUpgradeStatement.bindInt32Parameter(14, 100);

        try {
          rc =  sqlUpgradeStatement.executeStep();
        } catch (ex) {
          edebug(eDownloadsDB.mDBConn.lastErrorString)
          //edebug(ex)
        } finally {
          sqlUpgradeStatement.reset();
        }
      }
    } catch (ex) {
      edebug(ex)
    }
    
    legacyImport.currentTrack++
    
    thisCountStatus.setAttribute("value", legacyImport.currentTrack);

    thisStatusBar.setAttribute("value", "Importing " + legacyImport.trackTotal +
                               " previous tracks.");

    if (legacyImport.currentTrack < legacyImport.trackTotal) {
      setTimeout(legacyImport.insertLegacy, 0)
    } else {
      eDownloadsDB.mDBConn.commitTransaction();

      thisCountStatus.setAttribute("value", legacyImport.trackTotal);
      thisStatusBar.setAttribute("value", "Importing Complete!");

      eMuNotifier("emusic-refresh-list", null);

      document.getElementById('eWizard').getPageById("welcome").setAttribute("next", "player")
      document.getElementById("skipImport").hidden = true;
      document.getElementById('eWizard').getButton("back").setAttribute("disabled", "false");
      document.getElementById('eWizard').getButton("next").setAttribute("disabled", "false");
      document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "false")
      document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "false")
    }

  }
}

eMusicRegistry.resetStartup();
