var prefs = nsPreferences.mPrefService;

var eWizard = {

  firstTime: false,

  importLegacy: false,

  init: function() {

    setTimeout(function() {window.focus();}, 500);

    if (typeof legacyImport == "object") {
      legacyImport.init()

      if (!eWizard.importLegacy) {
        document.getElementById('eWizard').getPageById("welcome").setAttribute("next", "folder")
      }
    }
    
    var buttonNext = document.getElementById('eWizard').getButton("next")
    var buttonBack = document.getElementById('eWizard').getButton("back")
    var buttonFinish = document.getElementById('eWizard').getButton("finish")
    var buttonCancel = document.getElementById('eWizard').getButton("cancel")

    var osPlatform = eMusicPlatform.ident
    var thisTagList = document.getElementsByTagName("button");

    // workaround for linux button issue, button.css, tags buttons with osname
    for (var i = 0; i < thisTagList.length; i++) {
      thisTagList[i].setAttribute("platform", osPlatform);
    }

    buttonNext.setAttribute("platform", osPlatform);
    buttonNext.setAttribute("disabled", "false");
    buttonNext.setAttribute("label", "NEXT");

    buttonBack.setAttribute("platform", osPlatform);
    buttonBack.setAttribute("label", "BACK");
    buttonBack.setAttribute("collapsed", "true");

    buttonFinish.setAttribute("platform", osPlatform);
    buttonFinish.setAttribute("label", "FINISH");

    buttonCancel.setAttribute("platform", osPlatform);
    buttonCancel.setAttribute("label", "CANCEL");

    if (window.arguments && window.arguments[0]) {
      document.getElementById('eWizard').setAttribute("onwizardfinish", "")
      document.getElementById('eWizard').setAttribute("onwizardcancel", "")
    }

    try {
      edebug("Test for network connectivity, fallback to Auto-detect if fails");
      var req = new XMLHttpRequest();
      req.open("HEAD", "http://www.emusic.com", true);
      req.channel.loadFlags |= Components.interfaces.nsIRequest.LOAD_BYPASS_CACHE;

      req.onreadystatechange = function (aEvt) {
        try {
          if (req.readyState && req.readyState == 4) {
            if (req.status && req.status == 200) {
              edebug("Direct Connection is Working.");
            } else {
              setTimeout(function() {eWizard.tryAutoProxy();}, 0);
            }
          }
        } catch (ex) {
          edebug("Error Checking Direct Connections/n", ex);
          setTimeout(function() {eWizard.tryAutoProxy();}, 0);
        }
      };
      req.send(null);
    } catch (ex) {
      edebug("Error Checking Direct Connections/n", ex);
      setTimeout(function() {eWizard.tryAutoProxy();}, 0);
    }

  },

  tryAutoProxy: function() {
    try {
      edebug("Direct Connection Failed: Auto-Proxy test enabled");
      nsPreferences.setIntPref("network.proxy.type", 4);

      /* Test for network connectivity, fallback to Auto-detect if fails */
      var req = new XMLHttpRequest();
      req.open("HEAD", "http://www.emusic.com", true);
      req.channel.loadFlags |= Components.interfaces.nsIRequest.LOAD_BYPASS_CACHE;

      req.onreadystatechange = function (aEvt) {
        try {
          if (req.readyState && req.readyState == 4) {
            if (req.status && req.status == 200) {
              edebug("Auto-Proxy Connection is Working.");
            } else {
              edebug("Connection Error! Is your firewall set to allow eMusic Download Manager access?");
              edebug("Please make sure your firewall software is set to allow eMusic Download Manager and/or xulrunner.exe internet access");
              edebug(ex)

              nsPreferences.setIntPref("network.proxy.type", 0);

              setTimeout(function() {
                  dlm_base.popup("Connection Error! Is your firewall set to allow eMusic Download Manager access?", "dlm-downloading");
                  }, 0);
            }
          }
        } catch (ex) {
          edebug("Connection Error! Is your firewall set to allow eMusic Download Manager access?");
          edebug("Please make sure your firewall software is set to allow eMusic Download Manager and/or xulrunner.exe internet access");
          edebug(ex)

          nsPreferences.setIntPref("network.proxy.type", 0);

          setTimeout(function() {
              dlm_base.popup("Connection Error! Is your firewall set to allow eMusic Download Manager access?", "dlm-downloading");
              }, 0);
        }
      };

      req.send(null);
    } catch (ex) {
      edebug("Error Checking Auto-proxy servers/n", ex);
      nsPreferences.setIntPref("network.proxy.type", 0);
    }

  },

  populateMediaManagers: function() {
    if (!eWizard.firstTime) {
      prepMediaManagers(16);
      refreshDefaultPlayer();

      var i =0 
      for (key in mediaManagers) {
        i++
      }

      if (i == 1 && document.getElementById('eWizard')) {
        document.getElementById('eWizard').advance();
      }
      
      eWizard.firstTime = true;
    }
  },

  disableNext: function() {
    document.getElementById('eWizard').getButton("back").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("back").setAttribute("collapsed", "false");
    document.getElementById('eWizard').getButton("next").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "true")
    document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "true")
  },
  
  skipImport: function() {
    document.getElementById('eWizard').getButton("next").setAttribute("disabled", "false");
    document.getElementById('eWizard').getButton("cancel").setAttribute("disabled", "false")
    document.getElementById('eWizard').getButton("finish").setAttribute("disabled", "false")
    document.getElementById('eWizard').advance();
  },

  skipFinishPage: function() {
    if (window.arguments && window.arguments[0]) {
      document.getElementById('eWizard').getPageById("player").removeAttribute("next");
      document.getElementById('eWizard').setAttribute("firstpage", "false");
      document.getElementById('eWizard').setAttribute("lastpage", "true");
    }
  },
  
  readDownloadDirPref: function () {
    /**
     * Initializes the download folder widget based on the folder as stored in
     * preferences.
     */
    document.getElementById('eWizard').getButton("back").setAttribute("collapsed", "false");

    var bundlePreferences = document.getElementById("bundlePreferences");
    var downloadFolder = document.getElementById("downloadFolder");

    dlm_base.verifyDownloadDirectory();
    var currentDirPref = prefs.getComplexValue("eMusic.download.dir", Ci.nsILocalFile)    

    var dirDesktop = this._getDownloadsFolder("Desktop");
    var dirDownloads = this._getDownloadsFolder("Downloads");

    var dirMyEmusic = dirDesktop.clone();
    dirMyEmusic.append("My eMusic")
    
    switch (currentDirPref.path) {
      case dirDesktop.path:
      case "":
        downloadFolder.value = bundlePreferences.getString("desktopFolderName");
        break;
      case dirMyEmusic.path:
        downloadFolder.value = "My eMusic";
        break;
      case dirDownloads.path:
        downloadFolder.value = bundlePreferences.getString("myDownloadsFolderName");
        break;
      default:
        downloadFolder.value = currentDirPref.path;
    }

    var ios = Cc["@mozilla.org/network/io-service;1"]
                .getService(Ci.nsIIOService);
    if (currentDirPref.path != dirMyEmusic.path) {
      document.getElementById("downloadImage").src = dlm_base.getMozIcon(currentDirPref.path);
    }

    // don't override the preference's value in UI
    return undefined;
  },

  chooseFolder: function () {
    /**
     * Displays a file picker in which the user can choose the location where
     * downloads are automatically saved, updating preferences and UI in
     * response to the choice, if one is made.
     */
    const nsIFilePicker = Ci.nsIFilePicker;
    var fp = Cc["@mozilla.org/filepicker;1"]
               .createInstance(nsIFilePicker);
    var bundlePreferences = document.getElementById("bundlePreferences");
    var title = bundlePreferences.getString("chooseDownloadFolderTitle");
    fp.init(window, title, nsIFilePicker.modeGetFolder);

    const nsILocalFile = Ci.nsILocalFile;
    var customDirPref = prefs.getComplexValue("eMusic.download.dir", Ci.nsILocalFile)    

    if (customDirPref.path) {
      fp.displayDirectory = customDirPref;
    }

    fp.appendFilters(nsIFilePicker.filterAll);

    if (fp.show() == nsIFilePicker.returnOK) {
      var file = fp.file.QueryInterface(nsILocalFile);
      var currentDirPref = document.getElementById("downloadFolder");
      prefs.setComplexValue("eMusic.download.dir", Ci.nsILocalFile, file);
      prefs.setComplexValue("eMusic.download.downloadDir", Ci.nsILocalFile, file);

      nsPreferences.setIntPref("eMusic.download.folderList", this._folderToIndex(file));

      this.readDownloadDirPref();
    }
  },

  _folderToIndex: function (aFolder) {
    /**
    * Determines the type of the given folder.
    *
    * @param   aFolder
    *          the folder whose type is to be determined
    * @returns integer
    *          0 if aFolder is the Desktop or is unspecified,
    *          1 if aFolder is the Downloads folder,
    *          2 otherwise
    */
    if (!aFolder || aFolder.equals(this._getDownloadsFolder("Desktop")))
      return 0;
    else if (aFolder.equals(this._getDownloadsFolder("Downloads")))
      return 1;
    return 2;
  },

  _getDownloadsFolder: function (aFolder) {
    /**
     * Returns the Downloads folder.  If aFolder is "Desktop", then the Downloads
     * folder returned is the desktop folder; otherwise, it is a folder whose name
     * indicates that it is a download folder and whose path is as determined by
     * the XPCOM directory service from aFolder.
     *
     * @throws if aFolder is not "Desktop" or "Downloads"
     */
    var fileLocator = Cc["@mozilla.org/file/directory_service;1"]
                        .getService(Ci.nsIProperties);
    var dir = fileLocator.get(this._getSpecialFolderKey(aFolder),
                              Ci.nsILocalFile);
    if (aFolder != "Desktop") {
      dir.append("My Downloads"); // XXX l12y!
    }

    return dir;
  },

  _getSpecialFolderKey: function (aFolderType) {
    /**
     * Gets the platform-specific key to be fed to the directory service for the
     * given special folder.
     *
     * @param   aFolder
     *          either of the strings "Desktop" or "Downloads"
     * @returns the platform-specific key for the location, which may be used with
     *          the XPCOM directory service
     */

    if (aFolderType == "Desktop")
      return "Desk";

    if (aFolderType == "Downloads") {
//@line 353 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8-release/WINNT_5.2_Depend/mozilla/browser/components/preferences/main.js"
      switch (eMusicPlatform.ident) {
        case "WINNT":
          return "Pers"
          break;
        case "Linux":
          return "Home"
          break;
        default:
          return "UsrDocs"
       }
    }
//@line 361 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8-release/WINNT_5.2_Depend/mozilla/browser/components/preferences/main.js"

      throw "ASSERTION FAILED: folder type should be 'Desktop' or 'Downloads'";
  },

  selectMode: function(thisMode) {
    nsPreferences.setUnicharPref("eMusic.modeSwitch", thisMode)
    document.getElementById('eWizard').advance();
  }
}