/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "MPL"); you may not use this file
 * except in compliance with the MPL. You may obtain a copy of
 * the MPL at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the MPL is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the MPL for the specific language governing
 * rights and limitations under the MPL.
 * 
 * The Original Code is Enigmail.
 *
 * The Initial Developer of this code is Patrick Brunschwig.
 * Portions created by Patrick Brunschwig <patrick.brunschwig@gmx.net> are
 * Copyright (C) 2003 Patrick Brunschwig. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License (the "GPL"), in which case
 * the provisions of the GPL are applicable instead of
 * those above. If you wish to allow use of your version of this
 * file only under the terms of the GPL and not to allow
 * others to use your version of this file under the MPL, indicate
 * your decision by deleting the provisions above and replace them
 * with the notice and other provisions required by the GPL.
 * If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

// Uses: chrome://enigmail/content/enigmailCommon.js

// Initialize enigmailCommon
EnigInitCommon("enigmailAttachmentsDialog");


var gArguments=arguments;
const ENIG_INPUT=0;
const ENIG_RESULT=1;

function enigmailAttachDlgLoad() {
   DEBUG_LOG("enigmailAttachmentsDialog.js: Load\n");

   var dialog=document.getElementById("attachmentsDialog");
   dialog.setAttribute("title", EnigGetString("enigPrompt"));

   var optionSel=document.getElementById("enigmailAttachOptions");
   descNotFound=document.getElementById("enigPgpMimeDetails");
   if (gArguments[ENIG_INPUT].inlinePossible) {
     descNotFound.firstChild.data = EnigGetString("pgpMimeNote", EnigGetString("second"));
   }
   else {
     descNotFound.firstChild.data = EnigGetString("pgpMimeNote", EnigGetString("first"));
   }

   var selected=EnigGetPref("encryptAttachments");
   if (! selected)
      selected=0;

   var node = optionSel.firstChild;
   var nodeCount=0;
   while (node) {
      if (!gArguments[ENIG_INPUT].inlinePossible && nodeCount==1) {
      // disable inline PGP option
        node.disabled=true;
      }
      else if (!gArguments[ENIG_INPUT].pgpMimePossible && nodeCount==2) {
      // disable PGP/MIME option
        node.disabled=true;
      }
      else if (nodeCount == selected) {
        optionSel.selectedItem=node;
        optionSel.value=selected;
      }

      ++nodeCount;
      node=node.nextSibling;
   }

}


function enigmailAttachDlgAccept() {
  DEBUG_LOG("enigmailAttachDlgAccept.js: Accept\n");

  var optionSel=document.getElementById("enigmailAttachOptions");

  if (optionSel) {
     gArguments[ENIG_RESULT].selected = optionSel.value;
     EnigSetPref("encryptAttachments", optionSel.value);
  }

}

