#!/bin/sh

echo "<?xml version=\"1.0\"?>

<RDF xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"
     xmlns:em=\"http://www.mozilla.org/2004/em-rdf#\">

  <Description about=\"urn:mozilla:install-manifest\">
    <em:id>firekeeper@mozdev.org</em:id>
    <em:version>$FK_VERSION</em:version>
    <em:type>2</em:type> <!-- type=extension --> 
    <em:name>Firekeeper</em:name>
    <em:description>
      Intrusion Detection and Prevention System for Firefox
    </em:description>
    <em:creator>Jan Wrobel</em:creator>
    <em:homepageURL>http://firekeeper.mozdev.org</em:homepageURL>
    <em:updateURL>$UPDATE_URL</em:updateURL>
    
    <!-- Target Application this extension can install into, 
         with minimum and maximum supported versions. --> 
    <em:targetApplication>
      <Description>
	<em:id>{ec8030f7-c20a-464f-9b0e-13a3a9e97384}</em:id>
        <em:minVersion>$MIN_VERSION</em:minVersion>
        <em:maxVersion>$MAX_VERSION</em:maxVersion>
      </Description>
    </em:targetApplication>
       
  </Description>      
</RDF>
" > install.rdf;

echo "
<?php                                                               
  header('Content-type: text/xml');
  \$expire = 'Expires: ' . gmdate('D, d M Y H:i:s', time() + 60) . ' GMT';
  header(\$expire);                                      
?>

<RDF:RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"
	 xmlns=\"http://www.mozilla.org/2004/em-rdf#\">

<RDF:Description about=\"urn:mozilla:extension:firekeeper@mozdev.org\">
  <updates>
    <RDF:Seq>
      <RDF:li>
	
	<RDF:Description>
	  <version>$FK_VERSION</version>
	  <targetApplication>
	    <RDF:Description>
	      <id>{ec8030f7-c20a-464f-9b0e-13a3a9e97384}</id>
	      <minVersion>$MIN_VERSION</minVersion>
	      <maxVersion>$MAX_VERSION</maxVersion>
	      <updateLink>
		http://downloads.mozdev.org/firekeeper/$INSTALL_FILE
	      </updateLink>
	    </RDF:Description>
	  </targetApplication>
	</RDF:Description>

	
      </RDF:li>
    </RDF:Seq>
  </updates>    

</RDF:Description>
</RDF:RDF>
"> update\-$PLATFORM.rdf.php