/*$Id: alert.js,v 1.17 2007/09/18 20:02:47 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

var url = null;
var sentence = null;
var rule = null;
var details = null;

function alertInit()
{	
	getServices();
	url = window.arguments[0];
	rule = window.arguments[1];
	sentence = window.arguments[2];
	details = window.arguments[3];
	
	var urlLabel = document.getElementById('url-label');
	urlLabel.setAttribute('value', url);

	if (rule.msg){
		var msgLabel = document.getElementById('msg-label');
		msgLabel.setAttribute('value', "*** " + rule.msg + " ***");
	}
	if (!sentence){
		hideElement('action-groupbox');
		document.title = "Firekeeper log entry";
	}
	
	var count = {};
	var references = rule.getReferences(count);

	if (count.value){
		showElement("references");
	}
	
	var refnode = document.getElementById("references");	
	for(var i = 0; i < count.value; i++){
		var link = document.createElement("label");
		var refurl = ""; 
		if (references[i].system == "url"){
			refurl = references[i].refId;
			if (refurl.length < 8 || 
			    refurl.substring(0, 7) != "http://")
				refurl = "http://" + refurl;
		}
		else if (references[i].system == "bugtraq")
			refurl = "http://www.securityfocus.com/bid/" 
				+ references[i].refId;
		else if (references[i].system == "cve")
			refurl = "http://cve.mitre.org/cgi-bin/cvename.cgi?name=" 
				+ references[i].refId;
		else if (references[i].system == "nessus")
			refurl = "http://cgi.nessus.org/plugins/dump.php3?id=" 
				+ references[i].refId;
		else if (references[i].system == "mcafee")
			refurl = "http://vil.nai.com/vil/dispVirus.asp?virus_k=" 
				+ references[i].refId;
		
		link.setAttribute("class", "url");
		link.setAttribute("value", refurl);
		link.setAttribute("onclick", "viewURL('" + refurl + "');");
		refnode.appendChild(link);
	}	

}


function block()
{
	if (sentence)
		sentence.action = sentence.BLOCK; 
	close();
}

function allow()
{	
	sentence.action = sentence.AUDIT; 
	close();
}

function whitelistDialog()
{
	var options = "chrome,modal=yes,resizable,centerscreen";
	window.openDialog("chrome://firekeeper/content/add2list.xul",
			  "_blank", options, "whitelist", window.arguments[0], rule, window);	
}

function blacklistDialog()
{
	var options = "chrome,modal=yes,resizable,centerscreen";
	window.openDialog("chrome://firekeeper/content/add2list.xul",
			  "_blank", options, "blacklist", window.arguments[0], rule, window); 
	
}

function blacklist(options)
{
	rulesLoader.blacklist(options);
	sentence.action = sentence.BLOCK; 
	close();
}

function whitelist(options)
{
	rulesLoader.whitelist(options);
	sentence.action = sentence.DONT_AUDIT; 
	close();
}

function showDetails()
{
	var options = "chrome,modal=yes,resizable,centerscreen";
	window.openDialog("chrome://firekeeper/content/alertdetails.xul",
			  "_blank", options, rule, url, details); 
}
