/*$Id: fkResponseDetails.h,v 1.1 2007/09/05 21:55:20 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006,2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKRESPONSEDETAILS_H
#define FKRESPONSEDETAILS_H

#include "fkIResponseDetails.h"

/*
  Stores details about HTTP response to let the user inspect 
  suspicious data.
 */
class fkResponseDetails : public fkIResponseDetails
{
 public:
	NS_DECL_ISUPPORTS
        NS_DECL_FKIRESPONSEDETAILS



        fkResponseDetails(const char *headers, int headers_len,
			  const char *body, int body_len,
			  int body_offset);
	virtual ~fkResponseDetails();
 private:

	char *headers;
	char *hexheaders;
	int headers_len;
	char *body;
	int body_len;
	char *hexbody;
	int body_offset;
	char *toPrintableString(const char *, int);
	char *toHexString(const char *, int);
};

#endif
