/*$Id: fkRuleReference.cpp,v 1.6 2007/09/17 22:18:56 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006,2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "nsMemory.h"
#include "nsCRT.h"
#include "fkRuleReference.h"
#include "Error.h"


NS_IMPL_ISUPPORTS1(fkRuleReference, fkIRuleReference)

fkRuleReference::fkRuleReference(): 
		system(nsnull), refId(nsnull)
{
	TRACE("constructor %08x", this);
}

NS_IMETHODIMP 
fkRuleReference::Init(const reference *ref)
{
	if (!ref)
		return NS_ERROR_NULL_POINTER;
	
	if (ref->system){
		system = nsCRT::strdup(ref->system);	
		if (!system)
			return NS_ERROR_OUT_OF_MEMORY;
	}

	if (ref->refId){
		refId = nsCRT::strdup(ref->refId);	
		if (!refId)
			return NS_ERROR_OUT_OF_MEMORY;		
	}
	return NS_OK;
}

fkRuleReference::~fkRuleReference()
{
	TRACE("destructor %08x", this);
	if (system){
		nsMemory::Free(system);
	}
	if (refId){
		nsMemory::Free(refId);
	}
}

/* attribute string system; */
NS_IMETHODIMP fkRuleReference::GetSystem(char **aSystem)
{
	if (!aSystem)
		return NS_ERROR_NULL_POINTER;
	*aSystem = nsnull;

	if(system){
		*aSystem = nsCRT::strdup(system);	
		if (!*aSystem)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}


/* attribute string refId; */
NS_IMETHODIMP fkRuleReference::GetRefId(char **aRefId)
{
	if (!aRefId)
		return NS_ERROR_NULL_POINTER;
	*aRefId = nsnull;

	if(refId){
		*aRefId = nsCRT::strdup(refId);	
		if (!*aRefId)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

