/*$Id: Rules.cpp,v 1.6 2007/02/13 00:11:14 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "Rules.h"
#include "Error.h"

/*TODO: this should be configurable*/
/*action id is an index of action on this list*/
const char *knownActions[]={"pass", "drop", "alert"};

Rules::Rules()
{
	rulesVersion = 0;
}

/*call after constructor*/
int Rules::init()
{
	TRACE("initializing rules (%d types known)", sizeof(knownActions));
	noContentRules.clear();

	if (searchAPI->search_init(sizeof(knownActions) / sizeof(char *)) < 0)
		return -1;
	return 0;
}


Rules::~Rules()
{
	
}

/*Remove all rules and prepare to load new ones*/
void Rules::resetRules()
{
	TRACE("reseting rules");
	rulesVersion++;
	searchAPI->search_free();
	RuleSet::iterator it;
	set<Rule *>::iterator it3;
	
	for(it = ruleSet.begin(); it != ruleSet.end(); ++it)
		for(it3 = it->second.begin(); it3 != it->second.end(); ++it3){
			(*it3)->reset();
			delete *it3;
		}
	ruleSet.clear();
	init();
}

/*Add rule to a ruleset*/
void Rules::addRule(Rule *rule)
{
	list<PatternMatchData>::iterator it;

	FK_ASSERT(0 <= rule->actionID && rule->actionID < NACTIONS);
	
	TRACE("adding new rule. Action = %s. Number of rules = %d", 
	      rule->action, ruleSet.size());
	ruleSet[rule->actionID].insert(rule);	

	/*Add all patterns specified by *_content options to multipatern
	  search engine*/
	for(it = rule->url_content.begin(); it != rule->url_content.end(); 
	    it++)		
		searchAPI->search_add(URL_CONTENT, it->pattern_buf, 
				      it->pattern_size,  it->nocase, &*it);

	for(it = rule->headers_content.begin(); 
	    it != rule->headers_content.end(); it++)
		searchAPI->search_add(HEADERS_CONTENT, it->pattern_buf, 
				      it->pattern_size, 
				      it->nocase, &*it);

	for(it = rule->body_content.begin(); it != rule->body_content.end(); 
	    it++)
		searchAPI->search_add(BODY_CONTENT, it->pattern_buf, 
				      it->pattern_size, it->nocase, &*it);
	
	if (!rule->url_content.size() &&
	    !rule->headers_content.size() &&
	    !rule->body_content.size())
		noContentRules[rule->actionID].insert(rule);	
}


/*
  Get rules version to check out if rules are still valid.
  When new rules are loaded version is increased and old ones 
  should not be used.
*/
unsigned int 
Rules::getRulesVersion()
{
	return rulesVersion;
}

RuleSet* 
Rules::getNoContentRuleSet()
{
	return &noContentRules;
}

