/*$Id: judge.js,v 1.22 2008/05/18 10:29:00 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006,2007 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */


function fill(n)
{
	if (n <= 9)
		return "0" + n;
	else
		return "" + n;
}

function getTime()
{
	var now = new Date();
	return "" + now.getFullYear()+"." + now.getMonth() + "." + now.getDate() + " " +
		fill(now.getHours()) + ":" + fill(now.getMinutes()) + ":" + 
		fill(now.getSeconds());

}

function LogEntry(url, rule, details)
{
	this.url = url;
	this.rule = rule;
	this.details = details;	
	this.shortmsg = getTime() + " ";

	if (rule.action == "drop"){
		this.shortmsg += "Blacklisted";
	}
	else if (rule.action == "pass"){
		this.shortmsg += "Whitelisted";
	}
	else if (rule.action == "alert"){
		this.shortmsg += "Alert      ";
	}
	if (url)
		this.shortmsg += "  " + url +"; ";	
	if (rule.msg)
		this.shortmsg += rule.msg;

	this.fullMsg = function(){
		var res = "================ FIREKEEPER LOG ENTRY ================\n"
		res += this.shortmsg + "\n";
		res += "DETAILS: \n";
		res += getDetails(this.rule, this.url, this.details, 0);
		if (this.details){
			res += "\nHEX RESPONSE: \n";
			res +=  getHexResponse(this.details);
		}
		res += "\n\n";
		return res;
	}
}

function fkJudge() 
{

	this.ContractID = JUDGE_CONTRACTID;
	
	this.cid = Components.ID("4f1522b9-8aa1-436a-b3cd-3f087847e2ee");
	this.logEnabled = true;
	this.blockAlerts = false;
	this.log = new Array();
	this.autoLogStream = null;
	
	/*nsISupports*/
	this.QueryInterface = function(iid) {
		if (iid.equals(Components.interfaces.nsISupports) || 
		    iid.equals(Components.interfaces
			       .nsISupportsWeakReference)         ||
		    iid.equals(Components.interfaces.fkIJudge)    ||
		    iid.equals(Components.interfaces.nsIObserver)
		    )
		return this;
		
		//dump("Unimplemented fkJudge interface " + iid + "\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
	
	this.init = function() {
		//Register fkJudge
		Components.manager.QueryInterface(Components.interfaces
						  .nsIComponentRegistrar)
		.registerFactory(this.cid, "Firekeeper Judge", 
				 this.ContractID, new judgeFactory(this));

		this.prefs = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService)
		.getBranch("extensions.firekeeper.");

		this.setBlockAlerts();
		this.setLogEnabled();
		this.register();		
		this.getAutoLogStream();
	}	
	
	this.getAutoLogStream = function(){
		this.autoLogStream = null;
		if (!this.prefs){
			return;
		}
		var autolog = this.prefs.getBoolPref('log_automatically');
		
		if (!autolog){
			return;
		}
		
		this.autoLogStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
		.createInstance(Components.interfaces.nsIFileOutputStream);
		
		try{
			var file = this.prefs.getComplexValue("auto_log_file", Components.interfaces.nsILocalFile);
			this.autoLogStream.init(file, 0x02 | 0x08 | 0x10 | 0x40, 0600, 0); // write, create, truncate
			//alert("auto log stream initialized");
		}catch(e){
			dump("Firekeeper: can't write to the log file " + e);
			this.autoLogStream = null;
			this.prefs.setBoolPref("log_automatically", false);
			return;
		}

	}

	this.setBlockAlerts = function(){
		if (!this.prefs){
			return;
		}
		this.blockAlerts = this.prefs.getBoolPref('blockalerts');
	}

	this.setLogEnabled = function(){
		if (!this.prefs){
			return;
		}
		this.logEnabled = this.prefs.getBoolPref('log_enabled');
		if (!this.logEnabled)
			this.log.splice(0, this.log.length);
	}

	this.appendLog = function(logEntry){
		this.log.push(logEntry);
		if (this.autoLogStream){
			try{
				this.write(this.autoLogStream, logEntry.fullMsg());				   
			}catch(e){
				dump("Firekeeper: Can't write to the log file " + e);
				this.autoLogStream = null;
				this.prefs.setBoolPref("log_automatically", false);
			}
		}
	}
	
	/*fkIJudge*/
	/*Decide what to do when rule is broken.*/
	this.judge = function(url, rule, sentence, details){
		dump("judge called url = " + url + "\nfid = " 
		     + rule.fid + "\naction = " 
		     + rule.action + "\nmsg = " + rule.msg + "\n");		
		
		if (this.logEnabled){
			dump("appending log");
			this.appendLog(new LogEntry(url, rule, details));
		}
			      
		if (rule.action == "drop" || (this.blockAlerts && rule.action == "alert")){
			sentence.action = sentence.BLOCK;
		}
		else if (rule.action == "pass"){
			sentence.action = sentence.DONT_AUDIT;
		}
		else if (rule.action == "alert"){
			//Ask user what to do.
			//modal rox
			var options = "chrome,modal=yes,resizable,centerscreen";
			/*block by default*/
			sentence.action = sentence.BLOCK;

			window.openDialog("chrome://firekeeper/content/alert.xul",
					  "_blank", options, 
					  url, rule, sentence, details); 
			
		}
		
	}

	this.getLog = function(cnt){
		if (cnt){
			cnt.value = this.log.length;
		}
		return this.log;
	}
	
	this.write = function(foStream, str){
		foStream.write(str, str.length);
	}

	this.saveLog = function(file){
		var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
		.createInstance(Components.interfaces.nsIFileOutputStream);
		
		
		try{
			foStream.init(file, 0x02 | 0x08 | 0x20, 0600, 0); // write, create, truncate
		}catch(e){
			alert("Can't write to the log file " + e);
			return false;
		}
		
		for(var i = 0; i < this.log.length; i++){			
			this.write(foStream, this.log[i].fullMsg());			
		}
		foStream.close();	
		return true
	}

	this.register = function()
	{
		this.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2);
		this.prefs.addObserver("log_automatically", this, true);
		this.prefs.addObserver("log_details_cnt", this, true);
		this.prefs.addObserver("log_enabled", this, true);
		this.prefs.addObserver("blockalerts", this, true);
	}

	this.unregister = function()
	{
		if(!this.prefs) {
			return;
		}

		this.prefs.removeObserver("log_automatically", this);
		this.prefs.removeObserver("log_detail_cnt", this);
		this.prefs.removeObserver("log_enabled", this);
		this.prefs.removeObserver("blockalerts", this);
	}

	this.observe = function(aSubject, aTopic, aData)
	{
		if(aTopic != "nsPref:changed"){
			return;
		}
		
		this.setLogEnabled();
		this.getAutoLogStream();
		this.setBlockAlerts();
	}
}

function judgeFactory(judge){
	this.judge = judge;
	
	/*nsIFactory*/
	this.createInstance = function(outer, iid) {
		if (outer != null){
			dump("Exception outer != null\n");
			throw Components.results.NS_ERROR_NO_AGGREGATION;
		}
		if (iid.equals(Components.interfaces.fkIJudge) ||
		    iid.equals(Components.interfaces.nsISupports)){
			    return this.judge;
		    }
		dump("Exception no interface\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
			 
	/*nsISupports*/
	this.QueryInterface = function(iid) {
		if (iid.equals(Components.interfaces.nsISupports) ||
		    iid.equals(Components.interfaces
			       .nsISupportsWeakReference)         ||
		    iid.equals(Components.interfaces.nsIFactory)){
			    return this;
		    }
			
		dump("Unimplemented factory interface " + iid + "\n");
		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
}




