/*$Id: fkRuleReference.cpp,v 1.3 2006/08/20 16:39:54 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "nsMemory.h"
#include "nsCRT.h"
#include "fkRuleReference.h"
#include "Error.h"


NS_IMPL_ISUPPORTS1(fkRuleReference, fkIRuleReference)

fkRuleReference::fkRuleReference(const reference *ref)
{
	TRACE("constructor %08x", this);
	this->ref = ref;
}

fkRuleReference::~fkRuleReference()
{
	TRACE("destructor %08x", this);
}

/* attribute string system; */
NS_IMETHODIMP fkRuleReference::GetSystem(char **aSystem)
{
	if (!aSystem)
		return NS_ERROR_NULL_POINTER;
	*aSystem = nsnull;

	if(ref->system){
		*aSystem = nsCRT::strdup(ref->system);	
		if (!*aSystem)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}


/* attribute string ruleId; */
NS_IMETHODIMP fkRuleReference::GetRuleId(char **aRuleId)
{
	if (!aRuleId)
		return NS_ERROR_NULL_POINTER;
	*aRuleId = nsnull;

	if(ref->ruleId){
		*aRuleId = nsCRT::strdup(ref->ruleId);	
		if (!*aRuleId)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

