;
; Installer script
;
;
; $Id: installer.nsi,v 1.5 2003/08/10 22:23:18 seb Exp $
;
; Usage
;  $ makensis /DHELP installer.nsi
;
; Compiler
;   NSIS 2.0 cvs <http://nsis.sourceforge.net/>
;   with UPX 1.2.4 <http://upx.sourceforge.net>
;
; Author
;   Sbastien Delahaye <seb@delahaye.net>
;
; Contributors
;   Abdulkadir Topal <abdultopal@yahoo.de>
;   Vedran Miletic <riva_station@yahoo.com>
;   Tom Sommer <webmaster@tsn.dk>
;   Michele Dal Corso <mdalco@tiscali.it>
;

;
;
; Version: MPL 1.1/GPL 2.0/LGPL 2.1
;
; The contents of this file are subject to the Mozilla Public License Version 
; 1.1 (the "License"); you may not use this file except in compliance with 
; the License. You may obtain a copy of the License at 
; http://www.mozilla.org/MPL/
;
; Software distributed under the License is distributed on an "AS IS" basis,
; WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
; for the specific language governing rights and limitations under the
; License.
;
; The Original Code is a Windows installer for Phoenix using NSIS2.
;
; The Initial Developer of the Original Code is
; Sbastien Delahaye <seb@delahaye.net>.
; Portions created by the Initial Developer are Copyright (C) 2002
; the Initial Developer. All Rights Reserved.
;
; Contributors:
;   Abdulkadir Topal <abdultopal@yahoo.de>
;   Vedran Miletic <riva_station@yahoo.com>
;   Tom Sommer <webmaster@tsn.dk>
;   Michele Dal Corso <mdalco@tiscali.it>
; 
; Alternatively, the contents of this file may be used under the terms of
; either of the GNU General Public License Version 2 or later (the "GPL"),
; or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
; in which case the provisions of the GPL or the LGPL are applicable instead
; of those above. If you wish to allow use of your version of this file only
; under the terms of either the GPL or the LGPL, and not to allow others to
; use your version of this file under the terms of the MPL, indicate your
; decision by deleting the provisions above and replace them with the notice
; and other provisions required by the GPL or the LGPL. If you do not delete
; the provisions above, a recipient may use your version of this file under
; the terms of any one of the MPL, the GPL or the LGPL.
;


;
; Redirect people to the readme file.
;

!ifdef HELP
  !system '"type" README.txt'
  !verbose 0
    !error
  !verbose 3
!endif


;
; Modify this with the full path to the folder where this script stays.
; Do not forget the last "\"!
;

!define SCRIPTDIR "c:\savefileshere\friedfox\"

;
; Added for Friedfox by Asheesh Laroia
; This hard-codes the install directory
;

!define INSTDIR "%APPLICATIONDATA\firedfox\"


;
; This is the name (without ext) of the installer. Default is "installer".
; You don't need to modify this unless you want to rename all the files of
; the installation script.
;

!define SCRIPTNAME "installer"


;
; Installer version
;

!define SCRIPTVERSION "0.1"


;
; Include the conf
;

!include "${SCRIPTDIR}${SCRIPTNAME}.conf.nsh"


;
; Include Modern UI
;

!include "MUI.nsh"
!define MUI_ICON "${NSISDIR}\Contrib\Icons\setup.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Icons\normal-uninstall.ico"


;
; Distribution section. Define DIST and UPX when you want to distribute your
; installer, it's a lot more optimized. You don't need them for tests.
;

!include "${SCRIPTDIR}${SCRIPTNAME}.macros.nsh"
!ifdef DIST
  !insertmacro DIST bzip2 force on
  !insertmacro MUI_RESERVEFILE_WELCOMEFINISHPAGE
  !ifdef UPX
    !packhdr tmp.dat "${UPXDIR} ${UPXOPT} tmp.dat"
  !endif
!else
  !insertmacro DIST zlib off off
!endif


;
; Whole text definition
;

!define MUI_BrandingText "${MUI_PRODUCT} Installer v${SCRIPTVERSION}"

!define MUI_WELCOMEPAGE
!ifdef LICENSEFILE
  !define MUI_LICENSEPAGE
  LicenseData "${LICENSEFILE}"
!endif
!define MUI_COMPONENTSPAGE
  !define MUI_COMPONENTSPAGE_SMALLDESC
!define MUI_DIRECTORYPAGE
!define MUI_FINISHPAGE
!define MUI_FINISHPAGE_RUN "$INSTDIR\${EXE}"
!define MUI_FINISHPAGE_NOREBOOTSUPPORT

!define MUI_ABORTWARNING

!define MUI_UNINSTALLER
!define MUI_UNCONFIRMPAGE


;
; Sets the configuration. You shouldn't have to edit those lines. See above
; for clean configuration.
;

OutFile "${OUTDISK}${OUTDIR}${OUTFILE}"
SetOverwrite on
!ifdef WEB
  SpaceTexts none
  ; We can't know the size of the unzipped builds, so better not showing the
  ; "Space required" line, eh?
!endif
InstallDir "$APPDATA\friedfox"
InstallDirRegKey HKLM "Software\${BRAND}\${NAME}" "InstallDir"
AutoCloseWindow false
ShowInstDetails nevershow
ShowUninstDetails show


;
; Language files
;

; !define LANG "en"
!include "${SCRIPTDIR}${SCRIPTNAME}.${LANG}.nsh"
Caption "${CAPTION}"


;
; Main section
; We copy the files to $INSTDIR
;

Section "${NAME_SecCopy}" SecCopy
  SectionIn RO
  SetOutPath "$INSTDIR"
  !ifdef WEB
    NSISDL::download "${WEBPATH}${WEBFILE}" "$TEMP\${WEBFILE}"
    Pop $0
    StrCmp $0 "success" tozip abortdownload
    abortdownload:
      Abort "${ERR_download}"
    tozip:
      ZipDLL::extractall "$TEMP\${WEBFILE}" "$TEMP"
      ; ZipDLL has grown hugely lately, try using an old version
      ; to make the webby setup smaller.
      StrCmp $0 "success" next abortzip
    abortzip:
      Abort "${ERR_unzip}"
    next:
      CopyFiles /SILENT "$TEMP\${TEMPFOLDER}\*" "$INSTDIR"
      Goto done
    done:
  !else
    ;!ifdef UPX
    ;  !insertmacro UPXPACK on
    ;!endif
    File /r "${FROMDIR}"
  !endif
SectionEnd


;
; Subsection about shortcuts (desktop, startmenu, quicklaunch)
;

SubSection /e "${NAME_SecAddShortcuts}" SecAddShortcuts

  Section "${NAME_SecAddDesktopShortcut}" SecAddDesktopShortcut
    CreateShortCut "$DESKTOP\${DESC_DesktopShortcut}.lnk" \
      "$INSTDIR\${EXE}" "" "$INSTDIR\${EXE}" 0
  SectionEnd

  Section "${NAME_SecAddStartShortcuts}" SecAddStartShortcuts
    CreateDirectory "$SMPROGRAMS\${DESC_StartDir}"
    CreateShortCut "$SMPROGRAMS\${DESC_StartDir}\${DESC_StartUninst}.lnk" \
      "$INSTDIR\${UNINSTALLER}" "" "$INSTDIR\${UNINSTALLER}" 0
    CreateShortCut "$SMPROGRAMS\${DESC_StartDir}\${DESC_StartProg}.lnk" \
      "$INSTDIR\${EXE}" "" "$INSTDIR\${EXE}" 0
  SectionEnd

  Section "${NAME_SecAddQuicklaunchShortcut}" SecAddQuicklaunchShortcut
    CreateShortCut "$QUICKLAUNCH\${DESC_Quicklaunch}.lnk" \
      "$INSTDIR\${EXE}" "" "$INSTDIR\${EXE}" 0
  SectionEnd

SubSectionEnd


;
; Post-install section (creation of the uninstaller, registry writing)
;

Section -post
  WriteUninstaller "$INSTDIR\${UNINSTALLER}"
!ifndef WEB
  WriteRegStr HKLM "Software\${BRAND}\${NAME}" "Date" "${DATE}"
!endif

  WriteRegStr HKLM "Software\${BRAND}\${NAME}" "InstallDir" "$INSTDIR"
  WriteRegStr HKLM \
    "Software\Microsoft\Windows\CurrentVersion\App Paths\${EXE}" \
    "" "$INSTDIR\${EXE}"
  WriteRegStr HKLM \
    "Software\Microsoft\Windows\CurrentVersion\App Paths\${EXE}" \
    "Path" "$INSTDIR\"
  WriteRegStr HKLM \
    "Software\Microsoft\Windows\CurrentVersion\Uninstall\${GROUP}${NAME}" \
    "DisplayName" "${MUI_PRODUCT}"

!ifndef WEB
  WriteRegStr HKLM \
    "Software\Microsoft\Windows\CurrentVersion\Uninstall\${GROUP}${NAME}" \
     "DisplayVersion" "${MUI_VERSION}"
!endif

  WriteRegStr HKLM \
    "Software\Microsoft\Windows\CurrentVersion\Uninstall\${GROUP}${NAME}" \
    "UninstallString" '"$INSTDIR\${UNINSTALLER}"'
  WriteRegDWORD HKLM \
    "Software\Microsoft\Windows\CurrentVersion\Uninstall\${GROUP}${NAME}" \
    "NoModify" 1
  WriteRegDWORD HKLM \
    "Software\Microsoft\Windows\CurrentVersion\Uninstall\${GROUP}${NAME}" \
    "NoRepair" 1

  ; stuff from http://plugindoc.mozdev.org/phoenix.html
  ; with these keys, flash, shockwave, java and realone installers will find
  ; Phoenix.
  WriteRegStr HKLM "Software\${GROUP}\${NAME}" "GeckoVer" "1.0.1"
  WriteRegStr HKLM "Software\${GROUP}\${NAME}\bin" "PathToExe" \
    "$INSTDIR\${EXE}"
  WriteRegStr HKLM "Software\${GROUP}\${NAME}\Extensions" "Plugins" \
    "$INSTDIR\Plugins"
  WriteRegStr HKLM "Software\${GROUP}\${NAME}\Extensions" "Components" \
    "$INSTDIR\Components"

  WriteRegStr HKLM "Software\${BRAND}\${GROUP}" "CurrentVersion" "1.0"

  ; stuff from http://bugzilla.mozilla.org/show_bug.cgi?id=193883#c15 to
  ; enable support for Windows Media Player 9 in Firebird
  ;WriteRegStr HKLM "Software\Microsoft\MediaPlayer\ShimInclusionList\${EXE}" \
  ;  "" ""

!ifdef WEB
  Delete "$TEMP\${WEBFILE}"
  Rmdir /r "$TEMP\${TEMPFOLDER}"
!else
  !ifdef UPX
    !insertmacro UPXPACK off
  !endif
!endif
SectionEnd


;
; Uninstall section.
;

Section Uninstall
  MessageBox MB_YESNO|MB_ICONQUESTION $(un.DESC_rmProfiles) IDNO desktop
  ReadRegStr $R0 HKLM "Software\Microsoft\Windows NT\CurrentVersion" \
    CurrentVersion
  StrCmp $R0 "" w9x ntxp

  ntxp:
    ReadRegStr $R1 HKCU \
      "SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders" \
      AppData ; gets %AppData% for the current user
    IfFileExists "$R1\phoenix" "" desktop ; hard-coding sucks
      RMDir /r "$R1\phoenix" ; hard-coding sucks
      Goto desktop

  w9x:
    IfFileExists "$WINDIR\Application Data\phoenix" \
      "" desktop ; hard-coding sucks
      RMDir /r "$WINDIR\Application Data\phoenix" ; hard-coding sucks
      Goto desktop

  desktop:
    IfFileExists "$DESKTOP\${MUI_PRODUCT}.lnk" rmdesktop quicklaunch
      rmdesktop:
        Delete "$DESKTOP\${MUI_PRODUCT}.lnk"
        goto quicklaunch
  
  quicklaunch:
    IfFileExists "$QUICKLAUNCH\${MUI_PRODUCT}.lnk" rmquicklaunch startmenu
      rmquicklaunch:
        Delete "$QUICKLAUNCH\${MUI_PRODUCT}.lnk"
        goto startmenu
  
  startmenu:
    IfFileExists "$SMPROGRAMS\${MUI_PRODUCT}" rmstartmenu rmall
      rmstartmenu:
        RMDir /r "$SMPROGRAMS\${MUI_PRODUCT}"
        goto rmall
  
  rmall:
    IfFileExists "$INSTDIR\${EXE}" remove removed
      remove:
        DeleteRegKey HKLM \
          "Software\Microsoft\Windows\CurrentVersion\Uninstall\${GROUP}${NAME}"
        DeleteRegKey HKLM "Software\${GROUP}\${NAME}"
        DeleteRegKey HKLM "Software\${BRAND}\${NAME}"
        DeleteRegKey HKLM "Software\${BRAND}\${GROUP}"
        DeleteRegKey HKLM \
          "Software\Microsoft\Windows\CurrentVersion\App Paths\${EXE}"
        DeleteRegKey HKLM \
          "Software\Microsoft\MediaPlayer\ShimInclusionList\${EXE}"
        Delete "$INSTDIR\${UNINSTALLER}"
        RMDir /r "$INSTDIR"
        goto removed
  
  removed:
SectionEnd


;
; Descriptions
;

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopy} $(DESC_SecCopy)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAddShortcuts} $(DESC_SecAddShortcuts)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAddDesktopShortcut} \
    $(DESC_SecAddDesktopShortcut)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAddStartShortcuts} \
    $(DESC_SecAddStartShortcuts)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAddQuicklaunchShortcut} \
    $(DESC_SecAddQuicklaunchShortcut)
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END
!system "$APPDATA\friedfox\firefox.exe"

;
; Include the functions
;
  
!include "${SCRIPTDIR}${SCRIPTNAME}.functions.nsh"

; eof
