/* indicime.js 
 * Copyright (C) 2006 Surekha Sastry <surekhasastry@gmail.com>
 * Copyright (C) 2006 Srinivasa Raghavan <raghavan.kandala@gmail.com>
 */

/* ***** BEGIN LICENSE BLOCK *****
  * indicime.js is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.

  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330,
  * Boston, MA 02111-1307, USA.
  *
  * ***** END LICENSE BLOCK *****/
// Javascript functions for IME

var prevKey = new String();
var mapFound = false;
var firstEntry = false;
var unicodeArray; 
var convertFlag = false;
var combFlag = false;
var combMaxLength;

/* The Symbolic Constants that represent the xmlHttpResponse state */
var READY_STATE_UNINITIALIZED = 0;
var READY_STATE_LOADING = 1;
var READY_STATE_LOADED = 2;
var READY_STATE_INTERACTIVE = 3;
var READY_STATE_COMPLETE = 4;

/* The xmlHttpRequest object/variable */
var xmlHttpRequest = null;

/*
 * Add the event listener to all the Iframes in the document. 
 */
function init()
{
  var frames = document.getElementsByTagName("iframe");
  for(var i=0;i<frames.length;i++)
    {
      if (window.addEventListener)
	frames[i].contentDocument.addEventListener("keypress",eventCaptured, false);
    }

   window.addEventListener("keypress",eventCaptured,false);
}

function eventCaptured(evt)
{
    if (convertFlag && !(evt.ctrlKey || evt.altKey))
    {
        handleCharacter(evt);
    }
}

/** Returns the xmlHttpRequest object **/
function getXmlHttpRequest()
{
  var req = null;
  if (window.XMLHttpRequest)
  {
      req = new XMLHttpRequest();
  }
  else if (typeof ActiveXObject != "undefined")
  {
      req = new ActiveXObject("Microsoft.XMLHTTP");
  }
  return req;
}

/** Returns the URL with which the current community is being accessed */
function getKeyboardMappingURL(form)
{
  var url = new String(document.location);
  var keyboardIndex = parseInt(form.options[form.options.selectedIndex].value);

  switch(keyboardIndex)
  {
     case 0 : url = "inscript.properties";break;
     case 1 : url = "wx.properties";break;
  }
  readMapping(url);
  return url;
}



/** This function calls the 'url' using the method passed and calls
    'readyStateChangeCallback' in response **/
function readMapping(url, params, httpMethod)
{
  if (httpMethod == null)
  {
    httpMethod = "GET";
  }
  xmlHttpRequest = getXmlHttpRequest();
  if (xmlHttpRequest != null)
    {
      xmlHttpRequest.onreadystatechange = getMappingData;
      xmlHttpRequest.open(httpMethod, url, true);
      xmlHttpRequest.setRequestHeader("Content-Type", "text/html;charset=UTF-8;");
      xmlHttpRequest.send(params);
    }
}


/** This function is called in response to the xmlHttpRequest called
    in readContent. This function checks if the RSS Feeds is
    configured and acts accordingly **/
function getMappingData()
{
  var readyState = xmlHttpRequest.readyState;
  var data = null;
   if (readyState == READY_STATE_COMPLETE)
    {
      data = xmlHttpRequest.responseText;
      if (data != null)
      {
	buildMappingArray(data);
      }
    }
 }


function buildMappingArray(str)
{
    unicodeArray = new Array();
    var separator = "\n";

    var tokenizer = new StringTokenizer(str,separator);

    while (tokenizer.hasMoreTokens())
    {
        var separator1 = "=";
        var token      = tokenizer.nextToken();
        var tokenizer1 = new StringTokenizer(token,separator1);

        while(tokenizer1.hasMoreTokens())
        {
            var key      = tokenizer1.nextToken();
            var value    = tokenizer1.nextToken();
            unicodeArray[key] = value;
        }
    }
}

/*
 * Captures the keyCode and the characterCode of the key pressed.
 * If the keyCode or characterCode is in the ASCII range, fetch
 * the mapping for the key if exists dispatch new event with the
 * character fetched from the map. If it does not exist, then
 * return the key pressed.
 */
function handleCharacter(event) 
{
    var keyCode = event.keyCode ? event.keyCode :
       event.charCode ? event.charCode :
       event.which ? event.which : void 0;

    combMaxLength = unicodeArray["combMaxLength"];

    if( keyCode < 2304 && keyCode != 8)
    {
        var key = String.fromCharCode(keyCode);

	if (keyCode !=8)
        {
            prevKey = prevKey + key;
	}
        if (prevKey.length > combMaxLength)
        {
            prevKey = prevKey.substring(1, prevKey.length);
        }

        var targetKeyCode = getUnicodeChar(prevKey, key);

        if (targetKeyCode != keyCode)
        {
            if(combFlag)
            {
		combFlag = false;
       	        var new_event = document.createEvent("KeyEvents");
	        new_event.initKeyEvent("keypress", true, true, window, 
			               false, false, false, false, 
			               8, 0);
	        event.target.dispatchEvent(new_event); 
	    }
       	    var new_event1 = document.createEvent("KeyEvents");
	    new_event1.initKeyEvent("keypress", true, true, window, 
			           false, false, false, false, 
			           0, (targetKeyCode+parseInt(offset)));
	    event.target.dispatchEvent(new_event1); 
	    event.preventDefault();
	    //	    event.stopPropagation();
        }
   }
   return;
}

/*
 * Returns the mapping for the key passed if exists, otherwise
 * return the key.
 */ 
function getUnicodeChar(keys, curKey)
{
   var key = new String(keys);
   var unicodeChar = new String();
   var unicodeCharCode = curKey.charCodeAt(0);
   var mapFound = false;
   while(key.length > 0)
   { 
          // check for the keycombination (prevkey + key)
          unicodeChar = String.fromCharCode(unicodeArray[key]);
          if (unicodeChar.charCodeAt(0) >= 2304)
	  {
             mapFound = true;
             if(key.length > 1)
             {
                combFlag = true;
             }
             break;
         }
         else
         {
             key = key.substring(1,key.length);
             continue;
         }
   }
   // Handle special cases for Tamil
   if (mapFound)
   {
       if ( offset == 640) // if the chosen language is TAMIL
       {
           switch (unicodeChar)
	   {
               case '\u0916' : //kha
               case '\u0917' : //ga
               case '\u0918' : { unicodeChar = '\u0915'; break; } //gha
               case '\u0920' : //cha
               case '\u0921' : //ja
               case '\u0922' : { unicodeChar = '\u091F'; break; } //jha
               case '\u0925' :
               case '\u0926' :
               case '\u0927' : { unicodeChar = '\u0924'; break; }
               case '\u092B' :
               case '\u092C' :
               case '\u092D' : { unicodeChar = '\u092A'; break; }
           }
        }
	unicodeCharCode = unicodeChar.charCodeAt(0);
   }
   return unicodeCharCode;
}

/*
 * Gets the language selected and passed it on to setLanguageOffset()
 * method to set the offset for the chosen language.
 */
function getLanguage(formObj)
{
  var languageIndex = formObj.options[formObj.options.selectedIndex].value;
  convertFlag = true;
  setLanguageOffset(languageIndex);
}

/*
 * Sets the offset for the selected language.
 */
function setLanguageOffset(selectedLanguage)
{
   switch(selectedLanguage) 
   {
      case '-1': 
      {
         offset = 0;
         convertFlag = false;
         break;
      } 
      case '0': 
      {
         offset = 0;
         convertFlag = true;
         break;
      } 
      case '1': 
      {
         offset = (128*1);
         convertFlag = true;
         break;
      } 
      case '2': 
      {
         offset = (128*2);
         convertFlag = true;
         break;
      } 
      case '3': 
      {
         offset = (128*3);
         convertFlag = true;
         break;
      } 
      case '4': 
      {
         offset = (128*4);
         convertFlag = true;
         break;
      } 
      case '5': 
      {
         offset = (128*5);
         convertFlag = true;
         break;
      } 
      case '6': 
      {
         offset = (128*6);
         convertFlag = true;
         break;
      } 
      case '7': 
      {
         offset = (128*7);
         convertFlag = true;
         break;
      } 
      case '8': 
      {
         offset = (128*8);
         convertFlag = true; 
         break;
      } 
      case '9': 
      {
         offset = (128*9);
         convertFlag = true; 
         break;
      } 
   }
  return offset;
}


/*
   Constructor.
   Split up a material string based upong the separator.

   Param    -  material, the String to be split up.
   Param    -  separator, the String to look for within material. Should be
               something like "," or ".", not a regular expression.
*/
function StringTokenizer (material, separator)
{
    // Attributes.
    this.material       = material;
    this.separator      = separator;

    // Operations.
    this.getTokens      = getTokens;
    this.nextToken      = nextToken;
    this.countTokens    = countTokens;
    this.hasMoreTokens  = hasMoreTokens;
    this.tokensReturned = tokensReturned;

    // Initialisation code.
    this.tokens         = this.getTokens();
    this.tokensReturned = 0;

}

/*
   Go through material, putting each token into a new array.

   Return      - the array with all the tokens in it.
*/
function getTokens()
{
    // Create array of tokens.
    var tokens = new Array();
    var nextToken;

    // If no separators found, single token is the material string itself.
    if (this.material.indexOf (this.separator) < 0)
    {
        tokens [0] = this.material;
        return tokens;
    }

    // Establish initial start and end positions of the first token.
    start = 0;
    end = this.material.indexOf (this.separator, start);

    // Counter for how many tokens were found.
    var counter = 0;

    // Go through material, token at a time.
    var trimmed;
    
    while (this.material.length - start >= 1)
    {
        nextToken = this.material.substring (start, end);
        start = end + 1;
	
        if (this.material.indexOf (this.separator, start + 1) < 0)
        {
            end = this.material.length;
        }
        else
        {
            end = this.material.indexOf (this.separator, start + 1);
        }

        trimmed = trim (nextToken);

        // Remove any extra separators at start.
        while (trimmed.substring(0, this.separator.length) == this.separator) 
        {
            trimmed = trimmed.substring (this.separator.length);
        }
	
        trimmed = trim(trimmed);
        if (trimmed == "") 
        {
            continue;
        }
	
        tokens [counter] = trimmed;
        counter ++;
     }

    // Return the initialised array.
    return tokens;
}


/*
   Return a count of the number of tokens in the material.

   Return      - int number of tokens in material.
*/
function countTokens()
{
    return this.tokens.length;
}


/*
   Tests if there are more tokens available from this tokenizer's string. If
   this method returns true, then a subsequent call to nextToken
   will successfully return a token.

   Return      true if more tokens, false otherwise.
*/
function hasMoreTokens()
{
    if (this.tokensReturned < this.tokens.length)
    {
        return true;
    }
    else
    {
        return false;
    }
}

function tokensReturned()
{
    return this.tokensReturned;
}

function trim (strToTrim) 
{
   return(strToTrim.replace(/^\s+|\s+$/g, ''));
}

/*
   Get next token in material.

   Return      - next token in material.
*/
function nextToken()
{
    if (this.tokensReturned >= this.tokens.length)
    {
        return null;
    }
    else
    {
        var returnToken = this.tokens [this.tokensReturned];
        this.tokensReturned ++;
        return returnToken;
    }

}

// End of js for IME.

