/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package org.mozilla.jrex.navigation;

/**
* Interface WebNavigationConstants contains navigation related constants.
* @author <a href="mailto:jrex_moz@yahoo.com">C.N.Medappa</a>
* @version 1.0
*/
public interface WebNavigationConstants{

	public final int LOAD_FLAGS_MASK = 65535;

	/**
	* loadURI() specific flags
	*/

	/**
	* Normal load flag.
	*/
	public final int LOAD_FLAGS_NONE = 0;

	/**
	* Meta-refresh flag.  The cache is bypassed.  This type of load is
	*                     usually the result of a meta-refresh tag, or a HTTP
	*                     'refresh' header.
	*/
	public final int LOAD_FLAGS_IS_REFRESH = 16;

	/**
	* Link-click flag.
	*/
	public final int LOAD_FLAGS_IS_LINK = 32;

	/**
	* Bypass history flag.
	*/
	public final int LOAD_FLAGS_BYPASS_HISTORY = 64;

	/**
	* Replace history entry flag.
	*/
	public final int LOAD_FLAGS_REPLACE_HISTORY = 128;

	public final int LOAD_FLAGS_BYPASS_CACHE = 256;

	public final int LOAD_FLAGS_BYPASS_PROXY = 512;

	public final int LOAD_FLAGS_CHARSET_CHANGE = 1024;

	/**
	* Stop() flags:
	*/
	/**
	* Stop all network activity.  This includes both active network loads and
	* pending meta-refreshes.
	*/
	public final int STOP_NETWORK = 1;

	/**
	* Stop all content activity.  This includes animated images, plugins and
	* pending Javascript timeouts.
	*/
	public final int STOP_CONTENT = 2;

	/**
	* Stop all activity.
	*/
	public final int STOP_ALL = 3;

	/**
	* Indicates information type page-info.
	*/
	public static final short TYPE_PAGE_INFO	= 0;

	/**
	* Indicates information type security-info.
	*/
	public static final short TYPE_SEC_INFO		= 1;
}