/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "JRexInputStream.h"
using namespace JREX_JNI_UTIL;

NS_IMPL_ISUPPORTS1(JRexInputStream, nsIInputStream)

JRexInputStream::JRexInputStream(jobject stream):mIsClosed(PR_FALSE){
    JNIEnv *jenv = JRex_GetEnv(0);
	JREX_LOGLN("JRexInputStream()--> **** jenv<"<<jenv<<"> ****")
    if(jenv && stream)
		mJavaInputStream=jenv->NewGlobalRef(stream);
	else{
		JREX_LOGLN("JRexInputStream()--> **** CREATION FAILED!!!!!!!!!****")
		throw NS_ERROR_NULL_POINTER;
	}
	JREX_LOGLN("JRexInputStream()--> **** mJavaInputStream<"<<mJavaInputStream<<"> ****")
}

JRexInputStream::~JRexInputStream(){
	JNIEnv *jenv = JRex_GetEnv(0);
    JREX_LOGLN("~JRexInputStream()--> **** jenv<"<<jenv<<"> ****")
    if(jenv && mJavaInputStream){
		if(!mIsClosed)Close();
		JREX_LOGLN("~JRexInputStream()--> **** deleting global ref ****")
		jenv->DeleteGlobalRef(mJavaInputStream);
	}
	JREX_LOGLN("~JRexInputStream()--> **** Done ****")
}

NS_IMETHODIMP JRexInputStream::Close(){
	mIsClosed=PR_TRUE;
	JNIEnv *jenv = JRex_GetEnv(0);
	JREX_LOGLN("Close()--> **** jenv<"<<jenv<<"> ****")
	if(IS_NULL(jenv))return NS_ERROR_FAILURE;

	jenv->CallVoidMethod(mJavaInputStream,closeMID);
	if (jenv->ExceptionOccurred()) {
		JREX_LOGLN("Close()--> Failed with Exception ****")
		jenv->ExceptionDescribe();
		return NS_ERROR_FAILURE;
	}
	JREX_LOGLN("Close()--> DONE ****")
	return NS_OK;
}


NS_IMETHODIMP JRexInputStream::Available(PRUint32 *_retval){
	NS_ENSURE_ARG_POINTER(_retval);
	JNIEnv *jenv = JRex_GetEnv(0);
	JREX_LOGLN("Available()--> **** jenv<"<<jenv<<"> ****")
	if(IS_NULL(jenv))return NS_ERROR_FAILURE;

	jint available=jenv->CallIntMethod(mJavaInputStream,availableMID);
	JREX_LOGLN("Available()--> **** available<"<<available<<"> ****")
    if (jenv->ExceptionOccurred()) {
		JREX_LOGLN("Available()--> Failed with Exception ****")
		jenv->ExceptionDescribe();
		*_retval=0;
		return NS_ERROR_FAILURE;
    }
	*_retval=available;
	mBytesAvailable=available;
    JREX_LOGLN("Available()--> **** *_retval<"<<*_retval<<"> ****")
    return NS_OK;
}


NS_IMETHODIMP JRexInputStream::Read(char *aBuf, PRUint32 aCount, PRUint32 *_retval){
	NS_ENSURE_ARG_POINTER(aBuf);
	NS_ENSURE_ARG_POINTER(_retval);

	JNIEnv *jenv = JRex_GetEnv(0);
	PRUint32 count=0;

	JREX_LOGLN("Read()--> **** jenv<"<<jenv<<"> aCount<"<<aCount<<">****")
	if(IS_NULL(jenv))return NS_ERROR_FAILURE;

	Available(&count);
	count=aCount>mBytesAvailable?mBytesAvailable:aCount;
	if(count<=0)goto clean;
	JREX_LOGLN("Read()--> **** count<"<<count<<"> ****")

	jbyte* memArr;
	jbyteArray myArray;
	jint bytesRead;

	myArray=jenv->NewByteArray(count);
	bytesRead=jenv->CallIntMethod(mJavaInputStream,readMID,myArray,0,(jint)count);
	JREX_LOGLN("Read()--> **** bytesRead <"<<bytesRead<<"> ****")
    if (jenv->ExceptionOccurred()) {
		jenv->ExceptionDescribe();
		jenv->DeleteLocalRef(myArray);
		goto clean;
    }
    memArr=jenv->GetByteArrayElements(myArray,0);
    memcpy(aBuf,memArr,bytesRead);
    jenv->ReleaseByteArrayElements(myArray,memArr,JNI_ABORT);
    jenv->DeleteLocalRef(myArray);

    *_retval=bytesRead<0?0:bytesRead;
    return NS_OK;

   clean:
   JREX_LOGLN("Read()--> **** BRANCHED TO CLEAN ****")
   	*_retval=0;
   	return NS_OK;
}


NS_IMETHODIMP JRexInputStream::ReadSegments(nsWriteSegmentFun aWriter, void * aClosure, PRUint32 aCount, PRUint32 *_retval){
	NS_ENSURE_ARG_POINTER(_retval);

	nsresult rv=NS_OK;
	char* from=nsnull;
	PRUint32 rVal=0;
	PRUint32 count=0;

	JREX_LOGLN("ReadSegments()--> ****  mBytesAvailable<"<<mBytesAvailable<<"> aCount<"<<aCount<<"> ****")
	Available(&count);
	count=aCount>mBytesAvailable?mBytesAvailable:aCount;
	if(count<=0)goto clean;
	JREX_LOGLN("ReadSegments()--> **** count<"<<count<<"> ****")

	from = (char *)nsMemory::Alloc(count);
	if(!from){
		JREX_LOGLN("ReadSegments()--> **** MALLOC FAILED!!! ****")
		rv= NS_ERROR_OUT_OF_MEMORY;
		goto clean;
	}

	Read(from, count, &rVal);
	JREX_LOGLN("ReadSegments()--> ****  rVal<"<<rVal<<"> ****")
	if(rVal<=0)goto clean;

	rv = aWriter(this, aClosure, from,0, rVal, _retval);
	JREX_LOGLN("ReadSegments()--> **** rv<"<<rv<<"> _retval<"<<_retval<<">****")
	if(NS_FAILED(rv))// errors returned from the writer is not propogated.
		*_retval=0;
	nsMemory::Free(from);
	return NS_OK;
clean:
	JREX_LOGLN("ReadSegments()--> **** BRANCHED TO CLEAN ****")
	if(from)
		nsMemory::Free(from);
	*_retval=0;
	return rv;
}

NS_IMETHODIMP JRexInputStream::IsNonBlocking(PRBool *_retval){
	*_retval = PR_FALSE;
    return NS_OK;
}
