/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


	#include "JRexWindow.h"

	static NS_DEFINE_CID(kIOServiceCID, NS_IOSERVICE_CID);

	NS_IMETHODIMP JRexWindow::GetCanGoBack(PRBool *aCanGoBack) {
		NS_ENSURE_ARG_POINTER(aCanGoBack);
		JREX_LOGLN("GetCanGoBack()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		if(IsEventQThread())
			return mWebNavigation->GetCanGoBack(aCanGoBack);
		PRBool canBack=PR_FALSE;
		nsresult rv=ExecInEventQ(this,CAN_BACK,nsnull,PR_TRUE,HandleNavigationEvent,DestroyNavigationEvent,(void**)&canBack);
		JREX_LOGLN("GetCanGoBack()--> **** canBack<"<<canBack<<"> ****")
		if (NS_SUCCEEDED(rv))
			*aCanGoBack=canBack;
		JREX_LOGLN("GetCanGoBack()--> **** aCanGoBack<"<<aCanGoBack<<"> ****")
		return rv;
	}


	NS_IMETHODIMP JRexWindow::GetCanGoForward(PRBool *aCanGoForward) {
		NS_ENSURE_ARG_POINTER(aCanGoForward);
		JREX_LOGLN("GetCanGoForward()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		if(IsEventQThread())
			return mWebNavigation->GetCanGoForward(aCanGoForward);

		PRBool canForward=PR_FALSE;
		nsresult rv=ExecInEventQ(this,CAN_FORWARD,nsnull,PR_TRUE,HandleNavigationEvent,DestroyNavigationEvent,(void**)&canForward);
		JREX_LOGLN("GetCanGoForward()--> **** canForward<"<<canForward<<"> ****")
		if (NS_SUCCEEDED(rv))
			*aCanGoForward=canForward;
		JREX_LOGLN("GetCanGoForward()--> **** aCanGoForward<"<<aCanGoForward<<"> ****")
		return rv;
	}


	NS_IMETHODIMP JRexWindow::GoBack(void) {
		JREX_LOGLN("GoBack()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		if(IsEventQThread()){
			PRBool canBack=PR_FALSE;
			mWebNavigation->GetCanGoBack(&canBack);
			if(canBack==PR_TRUE)
				mWebNavigation->GoBack();
			return NS_OK;
		}
		nsresult rv=ExecInEventQ(this,GO_BACK,nsnull,PR_FALSE, HandleNavigationEvent,DestroyNavigationEvent,nsnull);
		JREX_LOGLN("GoBack()--> **** rv<"<<rv<<"> ****")
		return rv;
 	}


	NS_IMETHODIMP JRexWindow::GoForward(void) {
		JREX_LOGLN("GoForward()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		if(IsEventQThread()){
			PRBool canForward=PR_FALSE;
			mWebNavigation->GetCanGoForward(&canForward);
			if(canForward==PR_TRUE)
				mWebNavigation->GoForward();
			return NS_OK;
		}
		nsresult rv=ExecInEventQ(this,GO_FORWARD,nsnull,PR_FALSE, HandleNavigationEvent,DestroyNavigationEvent,nsnull);
		JREX_LOGLN("GoForward()--> **** rv<"<<rv<<"> ****")
		return rv;
	}


	NS_IMETHODIMP JRexWindow::GotoIndex(PRInt32 index) {
		JREX_LOGLN("GotoIndex()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		if(IsEventQThread())
			return mWebNavigation->GotoIndex(index);
		nsresult rv=ExecInEventQ(this,GO_TO_INDEX,(void*)index,PR_FALSE,HandleNavigationEvent,DestroyNavigationEvent,nsnull);
		JREX_LOGLN("GotoIndex()--> **** rv<"<<rv<<"> ****")
		return rv;
	}

  	NS_IMETHODIMP JRexWindow::LoadURI(const char *uri, PRUint32 loadFlags, const char *referrer, nsIInputStream *postData, nsIInputStream *headers) {
		JREX_LOGLN("LoadURI()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		if(IsEventQThread()){
			nsIURI *refUri=nsnull;
			if(NOT_NULL(referrer)){
				nsCOMPtr<nsIURI> tempRefUri;
				JREX_LOGLN("LoadURI()--> **** referrer NOT NULL ***")
				nsresult rv;
				nsCOMPtr<nsIIOService> service(do_GetService(kIOServiceCID,&rv));
				JREX_LOGLN("LoadURI()--> **** do_GetService rv<"<<rv<<"> ***")
				if (service){
					nsEmbedCString spec(referrer);
					rv=service->NewURI(spec, nsnull, nsnull, getter_AddRefs(tempRefUri));
					JREX_LOGLN("LoadURI()--> **** NewURI rv<"<<rv<<"> ***")
					if(NS_SUCCEEDED(rv))
						NS_ADDREF(refUri=tempRefUri.get());
					JREX_LOGLN("LoadURI()--> **** refUri<"<<(PRUint32)refUri<<"> ***")
				}
			}
			//nsCOMPtr<nsIInputStream> postIn;
			//if(NOT_NULL(postData))
			//	NS_NewBufferedInputStream(getter_AddRefs(postIn), postData, 8192);
			return mWebNavigation->LoadURI(NS_ConvertASCIItoUCS2(uri).get(),loadFlags,refUri,postData,headers);
		}

		nsresult rv=NS_OK;
	   	LoadURIEventData* eventData = new LoadURIEventData;
		if (eventData) {
			JREX_LOGLN("LoadURI()--> **** eventData Created ****")
			nsEmbedCString tempUri(uri);
			eventData->uri=ToNewCString(tempUri);
			eventData->loadFlags=loadFlags;
			if(NOT_NULL(referrer)){
				nsEmbedCString tempReferrer(referrer);
				eventData->referrer=ToNewCString(tempReferrer);
			}else
				eventData->referrer=nsnull;
			eventData->postData=postData;
			eventData->headers=headers;
			rv=ExecInEventQ(this,LOAD,eventData,PR_FALSE,HandleNavigationEvent,DestroyNavigationEvent,nsnull);
			if (NS_FAILED(rv)){
				CRTFREEIF(eventData->uri);
				CRTFREEIF(eventData->referrer);
				delete eventData;
			}
			JREX_LOGLN("LoadURI()--> **** ExecNavigationEvent rv<"<<rv<<"> Created ****")
		}else
			rv=NS_ERROR_OUT_OF_MEMORY;
		return rv;
	}

	NS_IMETHODIMP JRexWindow::OpenWindow(PRUint16 type, const char *uri, const char *referrer, const char *windowName, const char *feature){
		JREX_LOGLN("OpenWindow()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		nsresult rv=NS_OK;
		if(IsEventQThread()){
			nsCOMPtr<nsIDOMWindow> newWindow;
			return OpenWindowInternal(type, uri, referrer, windowName, feature, getter_AddRefs(newWindow));
		}
	   	OpenWindowEventData* eventData = new OpenWindowEventData;
		if (eventData) {
			JREX_LOGLN("OpenWindow()--> **** eventData Created ****")
			eventData->type=type;

			nsEmbedCString tempUri(uri);
			eventData->uri=ToNewCString(tempUri);

			if(NOT_NULL(referrer)){
				nsEmbedCString tempReferrer(referrer);
				eventData->referrer=ToNewCString(tempReferrer);
			}else
				eventData->referrer=nsnull;

			if(NOT_NULL(windowName)){
				nsEmbedCString tempWindowName(windowName);
				eventData->windowName=ToNewCString(tempWindowName);
			}else
				eventData->windowName=nsnull;

			if(NOT_NULL(feature)){
				nsEmbedCString tempFeature(feature);
				eventData->feature=ToNewCString(tempFeature);
			}else
				eventData->feature=nsnull;

			rv=ExecInEventQ(this,OPEN_WINDOW,eventData,PR_FALSE,HandleNavigationEvent,DestroyNavigationEvent,nsnull);
			if (NS_FAILED(rv)){
				CRTFREEIF(eventData->uri);
				CRTFREEIF(eventData->referrer);
				CRTFREEIF(eventData->windowName);
				CRTFREEIF(eventData->feature);
				delete eventData;
			}
			JREX_LOGLN("OpenWindow()--> **** ExecNavigationEvent rv<"<<rv<<"> Created ****")
		}else
			rv=NS_ERROR_OUT_OF_MEMORY;
		return rv;
	}


	NS_IMETHODIMP JRexWindow::Reload(PRUint32 reloadFlags) {
		JREX_LOGLN("Reload()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		if(IsEventQThread())
			return mWebNavigation->Reload(reloadFlags);
		nsresult rv=ExecInEventQ(this,RELOAD,(void*)reloadFlags,PR_FALSE,HandleNavigationEvent,DestroyNavigationEvent,nsnull);
		JREX_LOGLN("Reload()--> **** rv<"<<rv<<"> ****")
		return rv;
	}

	NS_IMETHODIMP JRexWindow::Stop(PRUint32 stopFlags) {
		JREX_LOGLN("Stop()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		if(IsEventQThread())
			return mWebNavigation->Reload(stopFlags);

		nsresult rv=ExecInEventQ(this,STOP,(void*)stopFlags,PR_FALSE,HandleNavigationEvent,DestroyNavigationEvent,nsnull);
		JREX_LOGLN("Stop()--> **** rv<"<<rv<<"> ****")
		return rv;
	}

	NS_IMETHODIMP JRexWindow::GetDocument(nsIDOMDocument * *aDocument) {
		JREX_LOGLN("GetDocument()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		if(IsEventQThread())
			return mWebNavigation->GetDocument(aDocument);

		nsCOMPtr<nsIDOMDocument> mydoc;
		nsresult rv=ExecInEventQ(this,GET_DOC,nsnull,PR_TRUE,HandleNavigationEvent,DestroyNavigationEvent,getter_AddRefs(mydoc));
		JREX_LOGLN("GetDocument()--> **** rv<"<<rv<<"> mydoc<"<<mydoc.get()<<">****")
		if (NS_SUCCEEDED(rv))
			NS_IF_ADDREF(*aDocument=mydoc.get());
		return rv;
	}

	NS_IMETHODIMP JRexWindow::GetCurrentURI(nsIURI * *aCurrentURI) {
		JREX_LOGLN("GetCurrentURI()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		if(IsEventQThread())
			return mWebNavigation->GetCurrentURI(aCurrentURI);

		nsIURI* myURI;
		nsresult rv=ExecInEventQ(this,GET_CUR_URI,nsnull,PR_TRUE,HandleNavigationEvent,DestroyNavigationEvent,(void**)&myURI);
		JREX_LOGLN("GetCurrentURI()--> **** rv<"<<rv<<"> myURI<"<<(PRUint32)myURI<<">****")
		if (NS_SUCCEEDED(rv))
			*aCurrentURI=myURI;
		return rv;
	}

	NS_IMETHODIMP JRexWindow::GetReferringURI(nsIURI * *aReferringURI) {
		JREX_LOGLN("GetReferringURI()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		if(IsEventQThread())
			return mWebNavigation->GetReferringURI(aReferringURI);

		nsCOMPtr<nsIURI> myURI;
		nsresult rv=ExecInEventQ(this,GET_REF_URI,nsnull,PR_TRUE,HandleNavigationEvent,DestroyNavigationEvent,getter_AddRefs(myURI));
		JREX_LOGLN("GetReferringURI()--> **** rv<"<<rv<<"> myURI<"<<myURI.get()<<">****")
		if (NS_SUCCEEDED(rv))
			*aReferringURI=myURI.get();
		return rv;
	}

	NS_IMETHODIMP JRexWindow::GetSessionHistory(nsVoidArray* hisArray, PRInt32* maxLength) {
		JREX_LOGLN("GetSessionHistory()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		if(IsEventQThread())
			return GetSessionHistoryInternal(hisArray,maxLength);

		PRInt32 tempMaxLen=0;
		nsresult rv=ExecInEventQ(this,GET_SESSION,hisArray,PR_TRUE,HandleNavigationEvent,DestroyNavigationEvent,(void**)&tempMaxLen);
		JREX_LOGLN("GetSessionHistory()--> **** rv<"<<rv<<"> tempMaxLen<"<<tempMaxLen<<">****")
		if (NS_SUCCEEDED(rv))
			*maxLength=tempMaxLen;
		return rv;
	}

	NS_IMETHODIMP JRexWindow::SetSessionHistory(nsISHistory* aSessionHistory) {
		JREX_LOGLN("SetSessionHistory()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		return NS_OK;
		if(mBrowCreated==PR_FALSE)return NS_OK;
		if(IsEventQThread())
			return mWebNavigation->SetSessionHistory(aSessionHistory);

		nsresult rv=ExecInEventQ(this,SET_SESSION,aSessionHistory,PR_FALSE,HandleNavigationEvent,DestroyNavigationEvent,nsnull);
		JREX_LOGLN("SetSessionHistory()--> **** rv<"<<rv<<"> ****")
		return rv;
	}

	nsresult JRexWindow::GetSessionHistoryInternal(nsVoidArray* hisArray, PRInt32* maxLength) {
		NS_ENSURE_ARG_POINTER(hisArray);
		nsCOMPtr<nsISHistory> history;
		nsresult rv=mWebNavigation->GetSessionHistory(getter_AddRefs(history));
		JREX_LOGLN("GetSessionHistoryInternal()--> **** GetSessionHistory rv<"<<rv<<"> ****")
		if (NS_FAILED(rv) || IS_NULL(history))
			return rv;
		JREX_LOGLN("GetSessionHistoryInternal()--> **** GetSessionHistory Done!!! ****")

		PRInt32 count=0;
		rv=history->GetCount(&count);
		JREX_LOGLN("GetSessionHistoryInternal()--> **** GetCount rv<"<<rv<<"> count<"<<count<<"> ****")
		if(count<=0)return rv;

		rv=history->GetMaxLength(maxLength);
		JREX_LOGLN("GetSessionHistoryInternal()--> *** GetMaxLength rv<"<<rv<<"> maxLength<"<<(*maxLength)<<"> ***")

		PRBool hasElem = PR_FALSE;
		nsCOMPtr<nsISimpleEnumerator> sEnum;
		rv=history->GetSHistoryEnumerator(getter_AddRefs(sEnum));
		JREX_LOGLN("GetSessionHistoryInternal()--> **** GetSHistoryEnumerator rv<"<<rv<<"> ****")
		if (NS_FAILED(rv))return rv;
		JREX_LOGLN("GetSessionHistoryInternal()--> **** GetSHistoryEnumerator Done!!! ****")

		rv=sEnum->HasMoreElements(&hasElem);
		while(NS_SUCCEEDED(rv) && hasElem==PR_TRUE){
			nsCOMPtr<nsISupports> entry;
			rv=sEnum->GetNext(getter_AddRefs(entry));
			JREX_LOGLN("GetSessionHistoryInternal()--> **** GetNext rv<"<<rv<<"> ****")
			if (NS_FAILED(rv))continue;

			nsCOMPtr<nsIHistoryEntry> hisEntry=do_QueryInterface(entry,&rv);
			JREX_LOGLN("GetSessionHistoryInternal()--> *** do_QueryInterface rv<"<<rv<<"> ***")

			if(NS_SUCCEEDED(rv) && NOT_NULL(hisEntry)){
				HistoryEntry *myEntry= new HistoryEntry;
				if(IS_NULL(myEntry))continue;

				nsCOMPtr<nsIURI> myUri;
				rv=hisEntry->GetURI(getter_AddRefs(myUri));
				JREX_LOGLN("GetSessionHistoryInternal()--> *** GetURI rv<"<<rv<<"> ***")

				if(NS_SUCCEEDED(rv) && NOT_NULL(myUri)){
					JREX_LOGLN("GetSessionHistoryInternal()--> *** NOT_NULL uri ***")
					nsEmbedCString spec;
					rv=myUri->GetSpec(spec);
					JREX_LOGLN("GetSessionHistoryInternal()--> *** GetSpec rv<"<<rv<<"> ***")
					myEntry->uri=NS_SUCCEEDED(rv)?ToNewCString(spec):nsnull;
				}else
					myEntry->uri=nsnull;
				JREX_LOGLN("GetSessionHistoryInternal()--> *** myEntry->uri<"<<(PRUint32)myEntry->uri<<"> ***")

				nsXPIDLString title;
				rv=hisEntry->GetTitle(getter_Copies(title));
				JREX_LOGLN("GetSessionHistoryInternal()--> *** GetTitle rv<"<<rv<<"> ***")
				myEntry->title=NS_SUCCEEDED(rv)?ToNewCString(title):nsnull;
				JREX_LOGLN("GetSessionHistoryInternal()--> *** myEntry->title<"<<myEntry->title<<"> ***")

				rv=hisEntry->GetIsSubFrame(&myEntry->isSubFrame);
				JREX_LOGLN("GetSessionHistoryInternal()--> *** rv<"<<rv<<"> isSubFrame<"<<(myEntry->isSubFrame==PR_TRUE)<<"> ***")
				hisArray->AppendElement(myEntry);
			}
			rv=sEnum->HasMoreElements(&hasElem);
			JREX_LOGLN("GetSessionHistoryInternal()--> *** hasElem<"<<(hasElem==PR_TRUE?"TRUE":"FALSE")<<"> ***")
		}
		return NS_OK;
	}


	nsresult JRexWindow::OpenWindowInternal(PRUint16 type,const char *aUrl, const char *ref,
												const char *aName, const char *aFeatures,
													nsIDOMWindow **_retval){
		NS_ENSURE_ARG_POINTER(_retval);
		nsresult rv;
		nsCOMPtr<nsISupportsArray> block;
		switch(type){
			case TYPE_PAGE_INFO:
			{
				block=do_CreateInstance(NS_SUPPORTSARRAY_CONTRACTID,&rv);
				JREX_LOGLN("OpenWindowInternal()--> **** do_CreateInstance nsISupportsArray rv<"<<rv<<"> ****")

				nsCOMPtr<nsIDOMWindow> parent;
				rv=mWebBrowser->GetContentDOMWindow(getter_AddRefs(parent));
				JREX_LOGLN("OpenWindowInternal()--> **** GetContentDOMWindow rv<"<<rv<<"> ****")
				if (NS_FAILED(rv))return rv;

				nsCOMPtr<nsIDOMDocument> doc;
				rv=parent->GetDocument(getter_AddRefs(doc));
				JREX_LOGLN("OpenWindowInternal()--> **** GetDocument rv<"<<rv<<"> ****")
				if (NS_FAILED(rv))return rv;
				rv=block->InsertElementAt(nsnull,0);
				rv|=block->InsertElementAt(doc,0);
				JREX_LOGLN("OpenWindowInternal()--> **** InsertElementAt rv<"<<rv<<"> ****")
				if (NS_FAILED(rv))return rv;
				break;
			}
			default:
				return NS_OK;
		};
		nsCOMPtr<nsIWindowWatcher> windowWatcher = do_GetService(NS_WINDOWWATCHER_CONTRACTID, &rv);
		JREX_LOGLN("OpenWindowInternal()--> **** do_GetService windowWatcher rv<"<<rv<<"> ****")
		if (NS_FAILED(rv))return rv;

		nsCOMPtr<nsIDOMWindow> parent;
		rv=mWebBrowser->GetContentDOMWindow(getter_AddRefs(parent));
		JREX_LOGLN("OpenWindowInternal()--> **** GetContentDOMWindow rv<"<<rv<<"> ****")
		if (NS_FAILED(rv))return rv;

		nsCOMPtr<nsIDOMWindow> newWindow;
		rv=windowWatcher->OpenWindow(parent,aUrl,aName,aFeatures,block,getter_AddRefs(newWindow));
		JREX_LOGLN("OpenWindowInternal()--> **** windowWatcher OpenWindow rv<"<<rv<<"> ****")
		if(NS_SUCCEEDED(rv))
			NS_IF_ADDREF(*_retval=newWindow.get());
		return *_retval ? NS_OK : NS_ERROR_FAILURE;
	}



	void* PR_CALLBACK JRexWindow::HandleNavigationEvent(PLEvent* aEvent){
		JRexBasicEvent* event = NS_REINTERPRET_CAST(JRexBasicEvent*, aEvent);
		nsresult rv=NS_OK;
		JREX_LOGLN("HandleNavigationEvent()--> **** JRexWindow <"<<event->window<<"> ****")
		if(JRexWindow::IsWindowAvailable(event->window)==PR_FALSE)
			return (void*)rv;
		switch(event->eventType){
			case LOAD:
			{
				LoadURIEventData* evtData = NS_REINTERPRET_CAST(LoadURIEventData*, event->eventData);
				JREX_LOGLN("HandleNavigationEvent()--> **** evtData <"<<evtData<<"> ****")
				nsIURI *refUri=nsnull;
				if(NOT_NULL(evtData->referrer)){
					nsCOMPtr<nsIURI> tempRefUri;
					JREX_LOGLN("LoadURI()--> **** referrer NOT NULL ***")
					nsresult rv;
					nsCOMPtr<nsIIOService> service(do_GetService(kIOServiceCID,&rv));
					JREX_LOGLN("LoadURI()--> **** do_GetService rv<"<<rv<<"> ***")
					if (service){
						nsEmbedCString spec(evtData->referrer);
						rv=service->NewURI(spec, nsnull, nsnull, getter_AddRefs(tempRefUri));
						JREX_LOGLN("LoadURI()--> **** NewURI rv<"<<rv<<"> ***")
						if(NS_SUCCEEDED(rv))
							NS_ADDREF(refUri=tempRefUri.get());
						JREX_LOGLN("LoadURI()--> **** refUri<"<<(PRUint32)refUri<<"> ***")
					}
				}
				//nsCOMPtr<nsIInputStream> postIn;
				//if(NOT_NULL(evtData->postData))
				//	NS_NewBufferedInputStream(getter_AddRefs(postIn), evtData->postData, 8192);
				rv =event->window->mWebNavigation->LoadURI(NS_ConvertASCIItoUCS2(evtData->uri).get(),
							   evtData->loadFlags,refUri,evtData->postData,evtData->headers);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation LoadURI rv<"<<rv<<"> ****")
				break;
			}
			case CAN_BACK:
			{
				PRBool canBack=PR_FALSE;
				rv=event->window->mWebNavigation->GetCanGoBack(&canBack);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GetCanGoBack canBack<"<<(canBack==PR_TRUE)<<"> rv<"<<rv<<"> ****")
				return (void*)canBack;
			}
			case CAN_FORWARD:
			{
				PRBool canForward=PR_FALSE;
				rv=event->window->mWebNavigation->GetCanGoForward(&canForward);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GetCanGoForward canForward<"<<(canForward==PR_TRUE)<<"> rv<"<<rv<<"> ****")
				return (void*)canForward;
			}
			case GO_BACK:
			{
				PRBool canBack=PR_FALSE;
				event->window->mWebNavigation->GetCanGoBack(&canBack);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation canBack <"<<(canBack==PR_TRUE)<<"> ****")
				if(canBack==PR_TRUE)
					rv=event->window->mWebNavigation->GoBack();
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GoBack rv<"<<rv<<"> ****")
				break;
			}
			case GO_FORWARD:
			{
				PRBool canForward=PR_FALSE;
				event->window->mWebNavigation->GetCanGoForward(&canForward);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation canForward <"<<(canForward==PR_TRUE)<<"> ****")
				if(canForward==PR_TRUE)
					rv=event->window->mWebNavigation->GoForward();
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GoForward rv<"<<rv<<"> ****")
				break;
			}
			case GO_TO_INDEX:
			{
				rv=event->window->mWebNavigation->GotoIndex((PRInt32)event->eventData);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GotoIndex index<"<<event->eventData<<"> rv<"<<rv<<"> ****")
				break;
			}
			case RELOAD:
			{
				rv=event->window->mWebNavigation->Reload((PRInt32)event->eventData);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation Reload flags<"<<event->eventData<<"> rv<"<<rv<<"> ****")
				break;
			}
			case STOP:
			{
				rv=event->window->mWebNavigation->Stop((PRInt32)event->eventData);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation Stop flags<"<<event->eventData<<"> rv<"<<rv<<"> ****")
				break;
			}
			case GET_CUR_URI:
			{
				nsCOMPtr<nsIURI> myURI;
				rv=event->window->mWebNavigation->GetCurrentURI(getter_AddRefs(myURI));
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GetCurrentURI myURI<"<<myURI<<"> rv<"<<rv<<"> ****")
				nsIURI* temp=nsnull;
				if(NS_SUCCEEDED(rv))
					NS_IF_ADDREF(temp=myURI.get());
				return temp;
			}
			case GET_REF_URI:
			{
				nsCOMPtr<nsIURI> myURI;
				rv=event->window->mWebNavigation->GetReferringURI(getter_AddRefs(myURI));
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GetReferringURI myURI<"<<myURI<<"> rv<"<<rv<<"> ****")
				nsIURI* temp=nsnull;
				if(NS_SUCCEEDED(rv))
					NS_IF_ADDREF(temp=myURI.get());
				return temp;
			}
			case GET_DOC:
			{
				nsCOMPtr<nsIDOMDocument> myDoc;
				rv=event->window->mWebNavigation->GetDocument(getter_AddRefs(myDoc));
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GetDocument myDoc<"<<myDoc<<"> rv<"<<rv<<"> ****")
				nsIDOMDocument* temp=nsnull;
				if(NS_SUCCEEDED(rv))
					NS_IF_ADDREF(temp=myDoc.get());
				return temp;
			}
			case GET_SESSION:
			{
				PRInt32 maxLen=0;
				nsVoidArray* vArray = NS_REINTERPRET_CAST(nsVoidArray*, event->eventData);
				rv=event->window->GetSessionHistoryInternal(vArray, &maxLen);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation GetSessionHistoryInternal eventData<"<<event->eventData<<"> rv<"<<rv<<"> ****")
				return (void*)maxLen;
			}
			case SET_SESSION:
			{
				rv=event->window->mWebNavigation->SetSessionHistory((nsISHistory *)event->eventData);
				JREX_LOGLN("HandleNavigationEvent()--> **** mWebNavigation SetSessionHistory eventData<"<<event->eventData<<"> rv<"<<rv<<"> ****")
				break;
			}
			case OPEN_WINDOW:
			{
				OpenWindowEventData* evtData = NS_REINTERPRET_CAST(OpenWindowEventData*, event->eventData);
				JREX_LOGLN("HandleNavigationEvent()--> **** type<"<<evtData->type<<"> uri<"
											<<(PRUint32)evtData->uri<<"> referrer<"
											<<(PRUint32)evtData->referrer<<"> windowName<"
											<<(PRUint32)evtData->windowName<<"> feature<"
											<<(PRUint32)evtData->feature<<"> ****")

				nsCOMPtr<nsIDOMWindow> newWindow;
				nsresult rv=event->window->OpenWindowInternal(evtData->type, evtData->uri, evtData->referrer, evtData->windowName, evtData->feature, getter_AddRefs(newWindow));
				JREX_LOGLN("HandleNavigationEvent()--> **** OpenWindowInternal rv<"<<rv<<"> ****")
				break;
			}
			default:
			{
				JREX_LOGLN("HandleNavigationEvent()--> **** EVENT TYPE<"<<event->eventType<<"> not handled!!! ****")
			}
		};
		JREX_LOGLN("HandleNavigationEvent()--> **** returning rv<"<<rv<<"> ****")
		return (void*)rv;
	}

	void PR_CALLBACK  JRexWindow::DestroyNavigationEvent(PLEvent* aEvent){
		JRexBasicEvent* event = NS_REINTERPRET_CAST(JRexBasicEvent*, aEvent);
		JREX_LOGLN("DestroyNavigationEvent()--> **** window <"<<event->window<<"> ****")
		if(event->eventData){
			if(event->eventType==LOAD){
				LoadURIEventData* evtData = NS_REINTERPRET_CAST(LoadURIEventData*, event->eventData);
				delete evtData;
			}else
			if(event->eventType==OPEN_WINDOW){
				OpenWindowEventData* evtData = NS_REINTERPRET_CAST(OpenWindowEventData*, event->eventData);
				delete evtData;
			}
		}
		delete event;
	}


