/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "org_mozilla_jrex_ui_JRexCanvas.h"
#include "JRex_JNI_util.h"
#include "JRexWindow.h"
#include "JRexCanvas.h"

#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
	#include <X11/Shell.h>
	#include <gtk/gtk.h>
	#include <gdk/gdk.h>
#endif

using namespace JREX_JNI_UTIL;

jfieldID JRexCanvasFields::peerID;
jfieldID JRexCanvasFields::xID;
jfieldID JRexCanvasFields::yID;
jfieldID JRexCanvasFields::widthID;
jfieldID JRexCanvasFields::heightID;

inline nsNativeWidget GetNativeWindowPointer(JNIEnv *env, jobject component){
	JREX_LOGLN("GetNativeWindowPointer()--> **** Inside ****")

	JAWT awt;
	awt.version=JAWT_VERSION_1_4;
	jboolean rv=JAWT_GetAWT(env, &awt);
	if(rv==JNI_FALSE)
		ThrowJRexException(env, "GetNativeWindowPointer()-->Could not get JAWT, is component HEADLESS ?",0);
	JREX_LOGLN("GetNativeWindowPointer()--> **** GOT JAWT ****")

	JAWT_DrawingSurface* ds=awt.GetDrawingSurface(env,component);
	if(IS_NULL(ds))
		ThrowJRexException(env, "GetNativeWindowPointer()-->Could not get JAWT_DrawingSurface",0);
	JREX_LOGLN("GetNativeWindowPointer()--> **** GOT JAWT_DrawingSurface ****")

	jint lock = ds->Lock(ds);
	if(lock & JAWT_LOCK_ERROR)
		ThrowJRexException(env, "GetNativeWindowPointer()-->Could not lock DrawingSurface JAWT_LOCK_ERROR",0);
	JREX_LOGLN("GetNativeWindowPointer()--> **** LOCKED JAWT_DrawingSurface ****")

	JAWT_DrawingSurfaceInfo* dsInf=ds->GetDrawingSurfaceInfo(ds);
	if(IS_NULL(dsInf))
		ThrowJRexException(env, "GetNativeWindowPointer()-->Could not get JAWT_DrawingSurfaceInfo",0);
	JREX_LOGLN("GetNativeWindowPointer()--> **** GOT JAWT_DrawingSurfaceInfo ****")

#if defined(XP_WIN32) || defined(XP_OS2)
	nsNativeWidget mainWnd=((JAWT_Win32DrawingSurfaceInfo*)dsInf->platformInfo)->hwnd;
#elif defined(XP_CARBON) || defined(XP_COCOA)
	nsNativeWidget mainWnd=((JAWT_Win32DrawingSurfaceInfo*)dsInf->platformInfo)->fQDWindow;
#else
	Display *myDis=((JAWT_X11DrawingSurfaceInfo*)dsInf->platformInfo)->display;
	Window myWin=(Window)((JAWT_X11DrawingSurfaceInfo*)dsInf->platformInfo)->drawable;
	JREX_LOGLN("GetNativeWindowPointer()--> **** Display<"<<myDis<<"> myWin<"<<myWin<<">****")
	if(myWin==0)myWin=XDefaultRootWindow(myDis);//what is this?
	nsNativeWidget mainWnd=(nsNativeWidget)myWin;
#endif
	JREX_LOGLN("GetNativeWindowPointer()--> **** mainWnd<"<<mainWnd<<"> ****")
	if(IS_NULL(mainWnd))
		ThrowJRexException(env, "GetNativeWindowPointer()-->Could not get handle to main Window",0);//does this occur?

	JREX_LOGLN("GetNativeWindowPointer()--> **** GOT THE MAIN WINDOW POINTER <"<<mainWnd<<"> ****")

	ds->FreeDrawingSurfaceInfo(dsInf);
	JREX_LOGLN("GetNativeWindowPointer()--> **** FreeDrawingSurfaceInfo done ****")
	ds->Unlock(ds);
	JREX_LOGLN("GetNativeWindowPointer()--> **** Unlock done ****")
	awt.FreeDrawingSurface(ds);
	JREX_LOGLN("GetNativeWindowPointer()--> **** FreeDrawingSurface done ****")
	return mainWnd;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    initIDs
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_initIDs
  (JNIEnv *env, jclass cls){
	JREX_TRY
    JRexCanvasFields::peerID	= env->GetFieldID(cls, "jrexPeer", "I");
    JREX_LOGLN("JRexCanvas_initIDs()--> **** peerID <"<<JRexCanvasFields::peerID<<"> ****")
    JRexCanvasFields::xID		= env->GetFieldID(cls, "x", "I");
    JREX_LOGLN("JRexCanvas_initIDs()--> **** xID <"<<JRexCanvasFields::xID<<"> ****")
    JRexCanvasFields::yID		= env->GetFieldID(cls, "y", "I");
    JREX_LOGLN("JRexCanvas_initIDs()--> **** yID <"<<JRexCanvasFields::yID<<"> ****")
    JRexCanvasFields::heightID	= env->GetFieldID(cls, "height", "I");
    JREX_LOGLN("JRexCanvas_initIDs()--> **** heightID <"<<JRexCanvasFields::heightID<<"> ****")
    JRexCanvasFields::widthID	= env->GetFieldID(cls, "width", "I");
    JREX_LOGLN("JRexCanvas_initIDs()--> **** widthID <"<<JRexCanvasFields::widthID<<"> ****")
    JREX_CATCH(env)
}


/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    createPeer
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CreatePeer
  (JNIEnv *env, jobject jrexCanvas, jint waitKey){
	if(!gXpcomRunning)return;
	JREX_TRY
#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
	JREX_LOGLN("CreatePeer()--> **** MOZ_WIDGET_GTK ***")
	nsNativeWidget mainWnd=nsnull;
#else
	JREX_LOGLN("CreatePeer()--> **** WIN32 ***")
	nsNativeWidget mainWnd=GetNativeWindowPointer(env,jrexCanvas);
#endif
	JREX_LOGLN("CreatePeer()--> **** mainWnd <"<<mainWnd<<"> ****")
	JRexWindow *window=new JRexWindow(mainWnd,waitKey);
	if(IS_NULL(window))
		ThrowJRexException(env, "**** createPeer-->  Could not create native JRexWindow ****",0);
	env->SetIntField(jrexCanvas, JRexCanvasFields::peerID,(jint)window);
	JREX_LOGLN("CreatePeer()--> **** SetIntField <"<<window<<"> ****")
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexCanvas
 * Method:    AbortPeerCreation
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_AbortPeerCreation
  (JNIEnv *env, jclass jrexCanvas, jint waitKey){
	if(!gXpcomRunning)return;
	JREX_TRY
		JREX_LOGLN("AbortPeerCreation()--> **** waitKey <"<<waitKey<<"> ****")
		JRexWindow::AbortWindowCreation(waitKey);
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RealizePeer
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_GotVisual
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("GotVisual()--> **** JRexWindow <"<<window<<"> ****")
	if(IS_NULL(window)
			|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** GotVisual()-->YOU DO NOT EXIST!!! ****",0);//does this occur?
		return;
	}
	nsNativeWidget parentWnd=GetNativeWindowPointer(env,jrexCanvas);
	window->GotVisual(parentWnd);
	JREX_CATCH(env)
#endif
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RealizePeer
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_RealizePeer
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("RealizePeer()--> **** JRexWindow <"<<window<<"> ****")
	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** RealizePeer()-->YOU DO NOT EXIST!!! ****",0);//does this occur?
		return;
	}
    PRInt32 x		= env->GetIntField(jrexCanvas, JRexCanvasFields::xID);
    PRInt32 y		= env->GetIntField(jrexCanvas, JRexCanvasFields::yID);
    PRInt32 width	= env->GetIntField(jrexCanvas, JRexCanvasFields::widthID);
    PRInt32 height	= env->GetIntField(jrexCanvas, JRexCanvasFields::heightID);

	JREX_LOGLN("RealizePeer()--> **** Calling window->show x<"<<x<<"> y<"<<y<<"> width<"<<width<<"> height<"<<height<<">****")
	nsresult rv =window->Show(x,y,width,height);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** RealizePeer()-->  JRexWindow show Failed ****",rv);
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    destroyPeer
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_DestroyPeer
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("DestroyPeer()--> **** JRexWindow <"<<window<<"> ****")
	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** DestroyPeer()-->YOU DO NOT EXIST!!! ****",0);//does this occur?
		return;
	}
	PRBool modal=PR_FALSE;
	window->IsWindowModal(&modal);
	if(modal)//in case of modal, window is internally destroyed.
		window->ModalDispose();
	else
		window->Dispose();
	env->SetIntField(jrexCanvas , JRexCanvasFields::peerID,0);
	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    BoundsChangedPeer
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_SetBoundsPeer
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("SetBoundsPeer()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** SetBoundsPeer()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
    PRInt32 x		= env->GetIntField(jrexCanvas, JRexCanvasFields::xID);
    PRInt32 y		= env->GetIntField(jrexCanvas, JRexCanvasFields::yID);
    PRInt32 width	= env->GetIntField(jrexCanvas, JRexCanvasFields::widthID);
    PRInt32 height	= env->GetIntField(jrexCanvas, JRexCanvasFields::heightID);
  	nsresult rv=window->SetBounds(x,y,width,height);
	JREX_LOGLN("SetBoundsPeer()--> **** window->SetBounds called ****")

	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** SetBoundsPeer()-->  JRexWindow SetBounds Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    BoundsChangedPeer
 * Signature: ()V
 */
JNIEXPORT jobject JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_GetBoundsPeer
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return NULL;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("GetBoundsPeer()--> **** JRexWindow <"<<window<<"> ****")
	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** GetBoundsPeer()-->YOU DO NOT EXIST!!! ****",0);
		return NULL;
	}

    PRInt32 x;
    PRInt32 y;
    PRInt32 width;
    PRInt32 height;
    nsresult rv=window->GetBounds(&x,&y,&width,&height);
	if (NS_FAILED(rv)){
		ThrowJRexException(env, "**** GetBoundsPeer()-->  JRexWindow SetBounds Failed ****",rv);
		return NULL;
	}
	JREX_LOGLN("GetBoundsPeer()--> **** Got x<"<<x<<"> y<"<<y<<"> width<"<<width<<"> height<"<<height<<"> ****")

	//Rectangle(int x, int y, int width, int height)
 	if (env->EnsureLocalCapacity(1) < 0) {
		ThrowJRexException(env, "**** GetBoundsPeer()-->  EnsureLocalCapacity Failed ****",0);
		return NULL;
    }
    jclass cls = env->FindClass("java/awt/Rectangle");
    jmethodID cid=env->GetMethodID(cls,"<init>", "(IIII)V");
    jobject rectObj=env->NewObject(cls,cid,(jint)x,(jint)y,(jint)width,(jint)height);
	env->DeleteLocalRef(cls);
	return rectObj;
  	JREX_CATCH(env)
  	return NULL;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    SetVisiblePeer
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_SetVisiblePeer
  (JNIEnv *env, jobject jrexCanvas, jboolean visible){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("SetVisiblePeer()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** SetVisiblePeer()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv=window->SetVisible(visible==JNI_TRUE?PR_TRUE:PR_FALSE);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** SetVisiblePeer()-->  JRexWindow SetVisible Failed ****",rv);
  	JREX_CATCH(env)

}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    SetEnabledPeer
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_SetEnabledPeer
  (JNIEnv *env, jobject jrexCanvas, jboolean enabled){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("SetEnabledPeer()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** SetEnabledPeer()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}

	nsresult rv=window->SetEnabled(enabled==JNI_TRUE?PR_TRUE:PR_FALSE);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** SetEnabledPeer()-->  JRexWindow SetEnabled Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    IsVisiblePeer
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_IsVisiblePeer
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("IsVisiblePeer()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** IsVisiblePeer()-->YOU DO NOT EXIST!!! ****",0);
		return JNI_FALSE;
	}

	PRBool temp=PR_FALSE;
	nsresult rv=window->IsVisible(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** IsVisiblePeer()-->  JRexWindow IsVisible Failed ****",rv);

	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    IsEnabledPeer
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_IsEnabledPeer
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("IsEnabledPeer()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** IsEnabledPeer()-->YOU DO NOT EXIST!!! ****",0);
		return JNI_FALSE;
	}

	PRBool temp=PR_FALSE;
	nsresult rv=window->IsEnabled(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** IsEnabledPeer()-->  JRexWindow IsEnabled Failed ****",rv);

	return temp==PR_TRUE;
  	JREX_CATCH(env)
  	return JNI_FALSE;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    GetTitlePeer
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_GetTitlePeer
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return NULL;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("GetTitlePeer()--> **** JRexWindow <"<<window<<"> ****")
	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** GetTitlePeer()-->YOU DO NOT EXIST!!! ****",0);
		return NULL;
	}

	nsXPIDLString title;
	nsresult rv=window->GetTitle(getter_Copies(title));
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** GetTitlePeer()-->  JRexWindow GetBaseTitle Failed ****",rv);

	return env->NewStringUTF(ToNewUTF8String(title));
  	JREX_CATCH(env)
  	return NULL;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    SetTitlePeer
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_SetTitlePeer
  (JNIEnv *env, jobject jrexCanvas, jstring jtitle){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("SetTitlePeer()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** SetTitlePeer()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}

	jboolean copy=JNI_FALSE;
	const char *title=env->GetStringUTFChars(jtitle,&copy);
	nsEmbedCString myTitle(title);

	nsresult rv=window->SetBaseTitle((const PRUnichar *)myTitle.get());
	env->ReleaseStringUTFChars(jtitle,title);

	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** SetTitlePeer()-->  JRexWindow SetBaseTitle Failed ****",rv);
  	JREX_CATCH(env)
}


/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RepaintPeer
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_RepaintPeer
  (JNIEnv *env, jobject jrexCanvas, jboolean force){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("RepaintPeer()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** RepaintPeer()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->Repaint(force==JNI_TRUE?PR_TRUE:PR_FALSE);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** RepaintPeer()-->  JRexWindow Repaint Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    SetFocusPeer
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_SetFocusPeer
  (JNIEnv *env, jobject jrexCanvas, jboolean focusGained){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("SetFocusPeer()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** SetFocusPeer()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->ChangeFocus(focusGained?PR_TRUE:PR_FALSE);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** SetFocusPeer()-->  JRexWindow SetFocus Failed ****",rv);
  	JREX_CATCH(env)

}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Print
 * Signature: (ZZ)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_Print
  (JNIEnv *env, jobject jrexCanvas, jboolean prompt, jboolean showProgress){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("Print()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** Print()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->Print(prompt?PR_TRUE:PR_FALSE,showProgress?PR_TRUE:PR_FALSE);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** Print()-->  JRexWindow Print Failed ****",rv);
  	JREX_CATCH(env)
}


/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Print
 * Signature: (ZZ)V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CancelPrint
  (JNIEnv *env, jobject jrexCanvas, jboolean prompt, jboolean showProgress){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CancelPrint()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CancelPrint()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->CancelPrint();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CancelPrint()-->  JRexWindow Print Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexCanvas
 * Method:    IsPrinting
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_IsPrinting
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("IsPrinting()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** IsPrinting()-->YOU DO NOT EXIST!!! ****",0);
		return JNI_FALSE;
	}
	PRBool isPrinting=PR_FALSE;
	nsresult rv=window->IsPrinting(&isPrinting);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** IsPrinting()--> IsPrinting Failed ****",rv);
	return isPrinting==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    PrintPreview
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_PrintPreview
  (JNIEnv *env, jobject jrexCanvas, jboolean jshrinkToFit, jboolean jisLandScape){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("PrintPreview()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** PrintPreview()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->PrintPreview(jshrinkToFit==JNI_TRUE,jisLandScape==JNI_TRUE);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** PrintPreview()-->  JRexWindow PrintPreview Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexCanvas
 * Method:    GetPrintPreviewNumPages
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_GetPrintPreviewNumPages
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return 0;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("GetPrintPreviewNumPages()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** GetPrintPreviewNumPages()-->YOU DO NOT EXIST!!! ****",0);
		return 0;
	}
	PRInt32 numOfPage=0;
	nsresult rv=window->GetPrintPreviewNumPages(&numOfPage);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** GetPrintPreviewNumPages()-->  GetPrintPreviewNumPages Failed ****",rv);
	return (jint)numOfPage;
  	JREX_CATCH(env)
  	return 0;
}


/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CancelPrintPreview
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CancelPrintPreview
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CancelPrintPreview()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CancelPrintPreview()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->CancelPrintPreview();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CancelPrintPreview()-->  JRexWindow CancelPrintPreview Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexCanvas
 * Method:    IsPreviewing
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_IsPrintPreviewing
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("IsPrintPreviewing()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** IsPrintPreviewing()-->YOU DO NOT EXIST!!! ****",0);
		return JNI_FALSE;
	}
	PRBool isPreviewing=PR_FALSE;
	nsresult rv=window->IsPrintPreviewing(&isPreviewing);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** IsPrintPreviewing()--> IsPrintPreviewing Failed ****",rv);
	return isPreviewing==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    PrintPreviewNavigate
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_PrintPreviewNavigate
  (JNIEnv *env, jobject jrexCanvas, jint navType, jint pageNum){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("PrintPreviewNavigate()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** PrintPreviewNavigate()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->PrintPreviewNavigate(navType,pageNum);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** PrintPreviewNavigate()-->  JRexWindow PrintPreviewNavigate Failed ****",rv);
  	JREX_CATCH(env)
}


/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    PageSetup
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_PageSetup
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("PageSetup()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** PageSetup()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->PageSetup();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** PageSetup()-->  JRexWindow PageSetup Failed ****",rv);
  	JREX_CATCH(env)

}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanUndo
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanUndo
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanUndo()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanUndo()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanUndo(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanUndo()-->  JRexWindow CanUndo Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanRedo
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanRedo
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanRedo()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanRedo()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanRedo(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanRedo()-->  JRexWindow CanRedo Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;
}


/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanCut
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanCut
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanCut()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanCut()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanCut(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanCut()-->  JRexWindow CanCut Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanCopy
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanCopy
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanCopy()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanCopy()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanCopy(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanCopy()-->  JRexWindow CanCopy Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;

}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanCopyLinkLocation
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanCopyLinkLocation
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanCopyLinkLocation()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanCopyLinkLocation()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanCopyLinkLocation(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanCopyLinkLocation()-->  JRexWindow CanCopyLinkLocation Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;

}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanCopyImageLocation
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanCopyImageLocation
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanCopyImageLocation()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanCopyImageLocation()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanCopyImageLocation(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanCopyImageLocation()-->  JRexWindow CanCopyImageLocation Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;

}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanCopyImageContents
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanCopyImageContents
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanCopyImageContents()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanCopyImageContents()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanCopyImageContents(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanCopyImageContents()-->  JRexWindow CanCopyImageContents Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;

}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanPaste
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanPaste
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanPaste()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanPaste()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanPaste(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanPaste()-->  JRexWindow CanPaste Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;

}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CanDelete
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CanDelete
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return JNI_FALSE;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CanDelete()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CanDelete()-->YOU DO NOT EXIST!!! ****",0);
		return PR_FALSE;
	}
	PRBool temp=PR_FALSE;
	nsresult rv=window->CanDelete(&temp);
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CanDelete()-->  JRexWindow CanDelete Failed ****",rv);
	return temp==PR_TRUE?JNI_TRUE:JNI_FALSE;
  	JREX_CATCH(env)
  	return JNI_FALSE;
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Undo
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_Undo
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("Undo()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** Undo()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->Undo();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** Undo()-->  JRexWindow Undo Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Redo
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_Redo
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("Redo()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** Redo()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->Redo();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** Redo()-->  JRexWindow Cut Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Cut
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_Cut
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("Cut()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** Cut()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->Cut();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** Cut()-->  JRexWindow Cut Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Copy
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_Copy
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("Copy()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** Copy()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->Copy();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** Copy()-->  JRexWindow Copy Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CopyLinkLocation
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CopyLinkLocation
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CopyLinkLocation()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CopyLinkLocation()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->CopyLinkLocation();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CopyLinkLocation()-->  JRexWindow CopyLinkLocation Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CopyImageLocation
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CopyImageLocation
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CopyImageLocation()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CopyImageLocation()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->CopyImageLocation();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CopyImageLocation()-->  JRexWindow CopyImageLocation Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    CopyImageContents
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_CopyImageContents
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("CopyImageContents()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** CopyImageContents()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->CopyImageContents();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** CopyImageContents()-->  JRexWindow Cut Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Paste
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_Paste
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("Paste()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** Paste()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->Paste();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** Paste()-->  JRexWindow Cut Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    SelectAll
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_SelectAll
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("SelectAll()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** SelectAll()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->SelectAll();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** SelectAll()-->  JRexWindow SelectAll Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    SelectNone
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_SelectNone
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("SelectNone()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** SelectNone()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->SelectNone();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** SelectNone()-->  JRexWindow SelectNone Failed ****",rv);
  	JREX_CATCH(env)
}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Delete
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_Delete
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("Delete()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** Delete()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->Delete();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** Delete()-->  JRexWindow Delete Failed ****",rv);
  	JREX_CATCH(env)

}
/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    Find
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_Find
  (JNIEnv *env, jobject jrexCanvas){


}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    FindAgain
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_FindAgain
  (JNIEnv *env, jobject jrexCanvas){

}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    AddProgressListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_AddProgressListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("AddProgressListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** AddProgressListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->AddProgressListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** AddProgressListener()-->  JRexWindow AddProgressListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    AddContextMenuListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_AddContextMenuListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("AddContextMenuListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** AddContextMenuListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->AddContextMenuListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** AddContextMenuListener()-->  JRexWindow AddContextMenuListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    AddHistoryListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_AddHistoryListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("AddHistoryListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** AddHistoryListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->AddHistoryListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** AddHistoryListener()-->  JRexWindow AddHistoryListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    AddKeyListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_AddKeyListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("AddKeyListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** AddKeyListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->AddKeyListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** AddKeyListener()-->  JRexWindow AddKeyListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    AddMouseListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_AddMouseListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("AddMouseListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** AddMouseListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->AddMouseListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** AddMouseListener()-->  JRexWindow AddMouseListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    AddMouseMotionListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_AddMouseMotionListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("AddMouseMotionListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** AddMouseMotionListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->AddMouseMotionListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** AddMouseMotionListener()-->  JRexWindow AddMouseMotionListener Failed ****",rv);
  	JREX_CATCH(env)
}

JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_AddURIContentListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("AddURIContentListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** AddURIContentListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->AddURIContentListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** AddURIContentListener()-->  JRexWindow AddURIContentListener Failed ****",rv);
  	JREX_CATCH(env)
}


/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RemoveProgressListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_RemoveProgressListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("RemoveProgressListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** RemoveProgressListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->RemoveProgressListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** RemoveProgressListener()-->  JRexWindow RemoveProgressListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RemoveContextMenuListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_RemoveContextMenuListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("RemoveContextMenuListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** RemoveContextMenuListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->RemoveContextMenuListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** RemoveContextMenuListener()-->  JRexWindow RemoveContextMenuListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RemoveHistoryListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_RemoveHistoryListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("RemoveHistoryListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** RemoveHistoryListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->RemoveHistoryListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** RemoveHistoryListener()-->  JRexWindow RemoveHistoryListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RemoveKeyListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_RemoveKeyListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("RemoveKeyListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** RemoveKeyListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->RemoveKeyListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** RemoveKeyListener()-->  JRexWindow RemoveKeyListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RemoveMouseListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_RemoveMouseListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("RemoveMouseListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** RemoveMouseListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->RemoveMouseListener();
	if (NS_FAILED(rv))
		ThrowJRexException(env, "**** RemoveMouseListener()-->  JRexWindow RemoveMouseListener Failed ****",rv);
  	JREX_CATCH(env)
}

/*
 * Class:     org_mozilla_jrex_ui_JRexBrowser
 * Method:    RemoveMouseMotionListener
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_mozilla_jrex_ui_JRexCanvas_RemoveMouseMotionListener
  (JNIEnv *env, jobject jrexCanvas){
	if(!gXpcomRunning)return;
  	JREX_TRY
	JRexWindow *window=(JRexWindow *)env->GetIntField(jrexCanvas, JRexCanvasFields::peerID);
	JREX_LOGLN("RemoveMouseMotionListener()--> **** JRexWindow <"<<window<<"> ****")

	if(IS_NULL(window)
				|| JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** RemoveMouseMotionListener()-->YOU DO NOT EXIST!!! ****",0);
		return;
	}
	nsresult rv=window->RemoveMouseMotionListener();
	if (NS_FAILED(rv)){
		ThrowJRexException(env, "**** RemoveMouseMotionListener()-->  JRexWindow RemoveMouseMotionListener Failed ****",rv);
		return;
	}
  	JREX_CATCH(env)
}
