/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.liveconnect;

import java.awt.IllegalComponentStateException;
import netscape.javascript.JSObject;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.liveconnect.JRexJSObject;
import org.mozilla.jrex.liveconnect.JRexLiveConnectSession;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;

public final class JRexLiveConnectSessionImpl
implements JRexLiveConnectSession {
    private static final String className = JRexLiveConnectSessionImpl.class.getName();
    private int sessionID;
    private int jrexPeer;
    private JSObject jsObject = null;
    private static boolean inited = false;
    private boolean valid = false;
    private boolean liveConnectStarted = false;
    private static Object staticSync = new Object();

    public JRexLiveConnectSessionImpl() {
    }

    public JRexLiveConnectSessionImpl(JRexCanvas browser) throws JRexException {
        this.setBrowser(browser);
    }

    void checkValid() throws JRexException {
        if (!this.valid) {
            throw new JRexException("JRexLiveConnectSession has not been intialized. Call setBrowser first.");
        }
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public int getJRexPeerID() {
        return this.jrexPeer;
    }

    public boolean equals(Object obj) {
        if (JRexL.on) {
            JRexL.log(className, "**** equals obj<" + obj + "> ****");
        }
        if (!(obj instanceof JRexLiveConnectSessionImpl)) {
            return false;
        }
        return ((JRexLiveConnectSessionImpl)obj).sessionID == this.sessionID;
    }

    public int hashCode() {
        if (JRexL.on) {
            JRexL.log(className, "**** hashCode ****");
        }
        return this.sessionID;
    }

    protected void finalize() {
        if (JRexL.on) {
            JRexL.log(className, "**** finalize ****");
        }
        try {
            this.Finalize();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void setBrowser(JRexCanvas browser) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** setBrowser browser<" + browser.getJRexPeer() + "> ****");
        }
        if (!inited) {
            throw new IllegalComponentStateException("Invocation of initIDs Failed!!!");
        }
        this.jrexPeer = browser.getJRexPeer();
        this.sessionID = this.Init();
        this.valid = true;
    }

    public void grantBrowserAccessToJVM() throws JRexException {
        this.startupLiveConnect();
    }

    public String invokeStringMethod(String functionName, String arg) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** invokeStringMethod functionName<" + functionName + "> arg<" + arg + "> ****");
        }
        this.checkValid();
        return this.InvokeStringMethod(functionName, arg);
    }

    public String evalUntrusted(String script) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** evalUntrusted ****");
        }
        this.checkValid();
        return this.EvalUntrusted(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSObject getJSWindow() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** getJSWindow ****");
        }
        this.checkValid();
        if (!this.liveConnectStarted) {
            throw new SecurityException("Browser does not have access to the JVM. Please call grantBrowserAccessToJVM() first.");
        }
        Object object = staticSync;
        synchronized (object) {
            if (this.jsObject == null) {
                this.jsObject = JRexJSObject.getWindowForSession(this);
            }
            return this.jsObject;
        }
    }

    private void startupLiveConnect() throws JRexException {
        if (!this.liveConnectStarted) {
            this.StartupLiveConnect();
            this.liveConnectStarted = true;
        }
    }

    private static native void initIDs() throws JRexException;

    native int Init() throws JRexException;

    native void StartupLiveConnect() throws JRexException;

    native String InvokeStringMethod(String var1, String var2) throws JRexException;

    native String EvalUntrusted(String var1) throws JRexException;

    native void Finalize() throws JRexException;

    static {
        try {
            if (JRexL.on) {
                JRexL.log(className, "**** initIDs ****");
            }
            JRexLiveConnectSessionImpl.initIDs();
            inited = true;
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
    }
}

