/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

	#ifndef JRexIncludes_h_
	#define JRexIncludes_h_

		#include<iostream>
		// core Includes
		#include "nscore.h"
		#include "nsCRT.h"
		#include "nsCOMPtr.h"
                //TODO un comment this once String mod in 1.7b is stabilized
		//#include "nsEmbedString.h"
		#include "nsReadableUtils.h"
		#include "nsXPCOMGlue.h"

		//interfaces implementaion includes.
		#include "nsIBaseWindow.h"
		#include "nsIWebBrowser.h"
		#include "nsCWebBrowser.h"
		#include "nsIWebNavigation.h"
		#include "nsIWebBrowserPersist.h"
		#include "nsIWebBrowserFocus.h"
		#include "nsIWebBrowserSetup.h"
		#include "nsIWebBrowserFind.h"
		#include "nsISound.h"
		#include "nsIDocShellTreeItem.h"
		#include "nsIScrollable.h"
		#include "nsITextScroll.h"
		#include "nsIInterfaceRequestor.h"
		#include "nsIInterfaceRequestorUtils.h"

		#include "nsIWebBrowserChrome.h"
		#include "nsIWebBrowserChromeFocus.h"

		#include "nsIEmbeddingSiteWindow.h"
		#include "nsIEmbeddingSiteWindow2.h"
		#include "nsITooltipListener.h"
		#include "nsIContextMenuListener2.h"
		#include "nsWeakReference.h" //not nsIWeakReference for nsSupportsWeakReference


		#include "nsIWebProgressListener.h"
		#include "nsISHistoryListener.h"
		#include "nsIObserver.h"
		#include "nsIWindowCreator2.h"
		#include "nsIDirectoryService.h"
		#include "nsILocalFile.h"
		#include "nsDirectoryServiceDefs.h"
		#include "nsNativeCharsetUtils.h"


		#include "nsIXULWindow.h"
		#include "nsIAppShellService.h"
		#include "nsAppShellCIDs.h"
		#include "nsWidgetsCID.h"
		#include "nsIPref.h"
		#include "nsVoidArray.h"
		#include "nsIAppShell.h"
		#include "nsIGenericFactory.h"
		#include "nsIComponentRegistrar.h"
		#include "nsIProfile.h"
		#include "nsAppDirectoryServiceDefs.h"
		#include "nsIWindowWatcher.h"
		#include "nsEmbedAPI.h"
		#include "nsIWidget.h"
		#include "nsIJSContextStack.h"
		#include "nsIEventQueueService.h"
		#include "nsIEventQueue.h"
		#include "plevent.h"
		#include "nsIURI.h"
		#include "nsIDOMWindow.h"
		#include "nsIWebProgress.h"
		#include "nsIRequest.h"

		#include "nsIDOMEvent.h"
		#include "nsIDOMKeyEvent.h"
		#include "nsIDOMMouseEvent.h"
		#include "nsIDOMNode.h"
		#include "nsNetUtil.h"
		#include "nsIIOService.h"
		#include "nsNetCID.h"
		#include "nsIInputStream.h"
		#include "nsIDOMDocument.h"
		#include "nsISHistory.h"
		#include "nsIHistoryEntry.h"
		#include "nsISupportsArray.h"
		#include "nsIDOMWindowInternal.h"
		#include "nsIWebBrowserPrint.h"
		#include "nsIPrintSettings.h"
		#include "nsIPrintingPromptService.h"
		#include "nsIDOMKeyListener.h"
		#include "nsIDOMMouseListener.h"
		#include "nsIDOMMouseMotionListener.h"
		#include "nsIURIContentListener.h"
		#include "nsIDOMEventReceiver.h"
		#include "nsPIDOMWindow.h"
		#include "nsIChromeEventHandler.h"
		#include "nsISelection.h"
		//#include "prlock.h"
		//#include "prtime.h"
		#include "prmem.h"
		#include "nsIClipboardCommands.h"
		#include "nsICommandManager.h"
		#include "nsICommandParams.h"
		#include "nsIFocusController.h"
#define id Id
		#include "nsDataHashtable.h"
#undef id
		//#include "nsRect.h"
		#include "nsIScriptGlobalObject.h"
		#include "nsIDocShell.h"
		#include "nsIDocShellLoadInfo.h"
		//#include "nsIPresContext.h"
		#include "nsIDocShellTreeOwner.h"
		#include "nsIPresShell.h"
		//#include "nsHTMLReflowState.h"
		//DOM Stuff
		#include "nsIDOMNamedNodeMap.h"
		#include "nsIDOMNodeList.h"
		#include "nsIPrivateDOMImplementation.h"
		#include "nsIDOMDOMImplementation.h"
		#include "nsIDOMDocumentType.h"
		#include "nsIDOMDocument.h"
		#include "nsIDOMAttr.h"
		#include "nsIDOMElement.h"
		#include "nsIDOMCharacterData.h"
		#include "nsIDOMEntity.h"
		#include "nsIDOMEntityReference.h"
		#include "nsIDOMCDATASection.h"
		#include "nsIDOMComment.h"
		#include "nsIDOMDocumentFragment.h"
		#include "nsIDOMProcessingInstruction.h"
		#include "nsIDOMText.h"
		#include "nsIDOMNotation.h"
		#include "nsIDOMRange.h"
		#include "nsIDOMDocumentRange.h"
		#include "nsIDOMEventTarget.h"
		#include "nsIDOMDocumentEvent.h"
		#include "nsIDOMAbstractView.h"
		#include "nsIDOMDocumentView.h"
		#include "nsIDOMMutationEvent.h"
		#include "nsIDOMUIEvent.h"
		#include "nsIDOMNodeIterator.h"
		#include "nsIDOMNodeFilter.h"
		#include "nsIDOMDocumentTraversal.h"
		#include "nsIDOMTreeWalker.h"

		#include "nsIDOMHTMLInputElement.h"
		#include "nsIDOMHTMLButtonElement.h"
		#include "nsIDOMHTMLOptionElement.h"
		#include "nsIDOMHTMLParamElement.h"
		#include "nsIDOMHTMLSelectElement.h"
		#include "nsIDOMHTMLTextAreaElement.h"
		#include "nsIDOMHTMLLIElement.h"

		//TODO Remove this once String mod in 1.7b is stabilized
		typedef nsAutoString nsEmbedString;
		typedef nsCAutoString nsEmbedCString;


		#define IS_NULL(obj)				((obj) == NULL)
		#define NOT_NULL(obj)				((obj) != NULL)

		#define NS_EM_LITERAL_CSTRING(s)	nsEmbedCString(s, PRUint32(sizeof(s)-1))
		#define NS_EM_LITERAL_STRING(s)     nsEmbedString(s, PRUint32(sizeof(s)-1))

		#define JREX_LOGLN_ERR(s)			std::cout<<s<<std::endl;

		#ifdef JREX_DEBUG
			#define JREX_LOGL(s)			std::cout<<s;
		#else
			#define JREX_LOGL(s)
		#endif

		#ifdef JREX_DEBUG
			#define JREX_LOGLN(s)			std::cout<<s<<std::endl;
		#else
			#define JREX_LOGLN(s)
		#endif

		#define JREX_TRY					try{

		#define JREX_CATCH(env)				}catch(int i){ \
												JNIEnv *myenv=env; \
												if(IS_NULL(myenv)) \
													myenv=JRex_GetEnv(JAWT_VERSION_1_4); \
												if(NOT_NULL(myenv)) \
													ThrowJRexException(myenv, "UNHANDLED C++ EXCEPTION OCCURED!!!",i); \
												else {\
													JREX_LOGLN_ERR("***** UNHANDLED C++ EXCEPTION OCCURED!!! ******") \
												}\
											}catch(...){ \
												JNIEnv *myenv=env; \
												if(IS_NULL(myenv)) \
													myenv=JRex_GetEnv(JAWT_VERSION_1_4); \
												if(NOT_NULL(myenv)) \
													ThrowJRexException(myenv, "UNHANDLED C++ EXCEPTION OCCURED!!!",0); \
												else {\
													JREX_LOGLN_ERR("***** UNHANDLED C++ EXCEPTION OCCURED!!! ******") \
												}\
											}


		#define JREX_RETURN_IF_FAILED(rv,s)	if(NS_FAILED(rv)){ \
												JREX_LOGLN_ERR(#s" Failed!!! ****") \
												return rv; \
											}else{\
												JREX_LOGLN(#s" Done ****") \
											}

		#define JREX_EXP(rv,s)				if(NS_FAILED(rv)){ \
												JREX_LOGLN_ERR(s) \
												throw rv; \
											}


		#define JREX_FAILED_GOTO(rv,s,n)	if(NS_FAILED(rv)){ \
												JREX_LOGLN_ERR(s) \
												goto n; \
											}

		extern nsIEventQueue* 	gEventQ;
		extern nsIAppShell* 	gAppShell;
		extern PRThread* 		gThread;
		extern PRBool			gXpcomRunning;

		#define IS_EQT						(PR_GetCurrentThread()==gThread)
#endif//JRexIncludes_h_
