/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   Rich Giuli <richard.giuli@sri.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
#include "JRexLiveConnectSession.h"
#include "JRex_JNI_Util.h"
#include "netscape_javascript_JSObject.h"
#include "jsjava.h"
#include "jsprf.h"
#include "jsutil.h"
#include "jscntxt.h"
#include "prtypes.h"
#include "jsdbgapi.h"
#include "nsError.h"

#include "nsISecurityContext.h"
#include "nsIScriptContext.h"
#include "nsIScriptGlobalObject.h"
#include "nsIScriptObjectPrincipal.h"
#include "nsIServiceManager.h"
#include "nsIScriptSecurityManager.h"
#include "nsILiveconnect.h"
#include "nsIPresShell.h"

#include <string.h>
using namespace JREX_LIVECONNECT;
using namespace JREX_JNI_UTIL;

#define JSOBJ_GETWINDOW    JRexLiveConnectSession* session = (JRexLiveConnectSession *)NS_INT32_TO_PTR(env->GetIntField(jrex_jsobj, \
        env->GetFieldID(JRexLiveConnectFields::jrexjsobject_clazz, "jrexLCSession", "I"))); \
	if(IS_NULL(session)){ \
		ThrowJRexException(env, "**** JRexLiveConnectSession DOES NOT EXIST!!! ****",0); \
        return NS_ERROR_UNEXPECTED; \
	} \
	JRexWindow *window=(JRexWindow *)NS_INT32_TO_PTR(env->GetIntField(session->mLCSession, JRexLiveConnectFields::peerID)); \
	if(IS_NULL(window) || JRexWindow::IsWindowAvailable(window)==PR_FALSE){ \
		ThrowJRexException(env, "**** YOU DO NOT EXIST!!! ****",0); \
        return NS_ERROR_UNEXPECTED; \
	}

nsresult JRexLiveConnectSession::GetWindowForSession(jclass clazz, jobject lcSession, jobject *retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("GetWindowForSession()--> **** lcSession<"<<lcSession<<"> env<"<<env<<"> ****")
	*retObj = NULL;
    if(IS_EQT) {
        jobject ret = NULL;
        nsresult rv = GetWindowForSessionInternal(clazz, lcSession, &ret);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** GetWindowForSession()-->  Failed to create JSObject ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            *retObj = ret;
            return NS_OK;
        }
    }
	JRexWindow *window=(JRexWindow *)NS_INT32_TO_PTR(env->GetIntField(lcSession, JRexLiveConnectFields::peerID));
	if(IS_NULL(window) || JRexWindow::IsWindowAvailable(window)==PR_FALSE){
		ThrowJRexException(env, "**** GetWindowForSession()-->YOU DO NOT EXIST!!! ****",0);
        return NS_ERROR_UNEXPECTED;
	}
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    GetWindowEventData *lcEventData = new GetWindowEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("GetWindowForSession()--> **** eventData Created ****")
        eventData->session = (JRexLiveConnectSession *)NS_INT32_TO_PTR(env->GetIntField(lcSession, JRexLiveConnectFields::sessionID));
        lcEventData->lcSession = lcSession;
        lcEventData->clazz = clazz;
        eventData->lcEventData = lcEventData;
        *retObj = NULL;
        rv=JRexWindow::ExecInEventQ(window,GET_WINDOW,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)retObj);
        JREX_LOGLN("GetWindowForSession()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("GetWindowForSession()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::GetWindowForSessionInternal(jclass clazz, jobject lcSession, jobject *retWin) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("GetWindowForSessionInternal()--> **** env<"<<env<<"> ****");
    // Invoke the native getWindow method for the lcSession. This method is necessary
    // because sun's plugin implementation overides JSObject.getWindow and a native
    // call is not made. Here, this native call delegates to the standard getWindow
    // native method.
    *retWin = Java_netscape_javascript_JSObject_getWindow(env, clazz, lcSession);
    if (NOT_NULL(*retWin)) {
        return NS_OK;
    } else {
        return NS_ERROR_UNEXPECTED;
    }
}

nsresult JRexLiveConnectSession::GetMember(jobject jrex_jsobj, jstring name, jobject *retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("GetMember()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> ****")
	*retObj = NULL;
    if(IS_EQT) {
        jobject ret = NULL;
        nsresult rv = GetMemberInternal(jrex_jsobj, name, &ret);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** GetMember()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            *retObj = ret;
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    GetMemberEventData *lcEventData = new GetMemberEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("GetMember()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        lcEventData->name = name;
        eventData->lcEventData = lcEventData;
        *retObj = NULL;
        rv=JRexWindow::ExecInEventQ(window,GET_MEMBER,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)retObj);
        JREX_LOGLN("GetMember()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("GetMember()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::GetMemberInternal(jobject jrex_jsobj, jstring name, jobject *retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("GetMemberInternal()--> **** env<"<<env<<"> ****");
    *retObj = Java_netscape_javascript_JSObject_getMember(env, jrex_jsobj, name);
    if (NOT_NULL(*retObj)) {
        return NS_OK;
    } else {
        return NS_ERROR_UNEXPECTED;
    }
}

nsresult JRexLiveConnectSession::GetSlot(jobject jrex_jsobj, jint indx, jobject *retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("GetSlot()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> ****")
	*retObj = NULL;
    if(IS_EQT) {
        jobject ret = NULL;
        nsresult rv = GetSlotInternal(jrex_jsobj, indx, &ret);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** GetSlot()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            *retObj = ret;
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    GetSlotEventData *lcEventData = new GetSlotEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("GetSlot()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        lcEventData->indx = indx;
        eventData->lcEventData = lcEventData;
        *retObj = NULL;
        rv=JRexWindow::ExecInEventQ(window,GET_MEMBER,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)retObj);
        JREX_LOGLN("GetSlot()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("GetSlot()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::GetSlotInternal(jobject jrex_jsobj, jint indx, jobject *retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("GetSlotInternal()--> **** env<"<<env<<"> ****");
    *retObj = Java_netscape_javascript_JSObject_getSlot(env, jrex_jsobj, indx);
    if (NOT_NULL(*retObj)) {
        return NS_OK;
    } else {
        return NS_ERROR_UNEXPECTED;
    }
}

nsresult JRexLiveConnectSession::Eval(jobject jrex_jsobj, jstring evalstr, jobject *retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("Eval()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> ****")
	*retObj = NULL;
    if(IS_EQT) {
        jobject ret = NULL;
        nsresult rv = EvalInternal(jrex_jsobj, evalstr, &ret);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** Eval()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            *retObj = ret;
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    EvalEventData *lcEventData = new EvalEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("Eval()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        lcEventData->evalstr = evalstr;
        eventData->lcEventData = lcEventData;
        *retObj = NULL;
        rv=JRexWindow::ExecInEventQ(window,EVAL,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)retObj);
        JREX_LOGLN("Eval()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("Eval()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::EvalInternal(jobject jrex_jsobj, jstring evalstr, jobject *retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("EvalInternal()--> **** env<"<<env<<"> ****");
    *retObj = Java_netscape_javascript_JSObject_eval(env, jrex_jsobj, evalstr);
    if (NOT_NULL(*retObj)) {
        return NS_OK;
    } else {
        return NS_ERROR_UNEXPECTED;
    }
}

nsresult JRexLiveConnectSession::SetMember(jobject jrex_jsobj, jstring name, jobject value) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("GetSlot()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> ****")
    if(IS_EQT) {
        nsresult rv = SetMemberInternal(jrex_jsobj, name, value);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** SetMember()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    SetMemberEventData *lcEventData = new SetMemberEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("SetMember()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        lcEventData->name = name;
        lcEventData->value = value;
        eventData->lcEventData = lcEventData;
        nsresult ns_ret;
        rv=JRexWindow::ExecInEventQ(window,SET_MEMBER,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)&ns_ret);
        JREX_LOGLN("SetMember()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("SetMember()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::SetMemberInternal(jobject jrex_jsobj, jstring name, jobject value) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("SetMemberInternal()--> **** env<"<<env<<"> ****");
    Java_netscape_javascript_JSObject_setMember(env, jrex_jsobj, name, value);
    return NS_OK;
}

nsresult JRexLiveConnectSession::SetSlot(jobject jrex_jsobj, jint indx, jobject value) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("SetSlot()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> indx<"<<indx<<"> ****")
    if(IS_EQT) {
        nsresult rv = SetSlotInternal(jrex_jsobj, indx, value);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** SetSlot()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    SetSlotEventData *lcEventData = new SetSlotEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("SetSlot()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        lcEventData->indx = indx;
        lcEventData->value = value;
        eventData->lcEventData = lcEventData;
        nsresult ns_ret;
        rv=JRexWindow::ExecInEventQ(window,SET_SLOT,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)&ns_ret);
        JREX_LOGLN("SetSlot()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("SetSlot()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::SetSlotInternal(jobject jrex_jsobj, jint indx, jobject value) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("SetSlotInternal()--> **** env<"<<env<<"> ****");
    Java_netscape_javascript_JSObject_setSlot(env, jrex_jsobj, indx, value);
    return NS_OK;
}

nsresult JRexLiveConnectSession::RemoveMember(jobject jrex_jsobj, jstring name) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("SetSlot()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> ****")
    if(IS_EQT) {
        nsresult rv = RemoveMemberInternal(jrex_jsobj, name);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** RemoveMember()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    RemoveMemberEventData *lcEventData = new RemoveMemberEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("RemoveMember()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        lcEventData->name = name;
        eventData->lcEventData = lcEventData;
        nsresult ns_ret;
        rv=JRexWindow::ExecInEventQ(window,REMOVE_MEMBER,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)&ns_ret);
        JREX_LOGLN("RemoveMember()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("RemoveMember()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::RemoveMemberInternal(jobject jrex_jsobj, jstring name) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("RemoveMemberInternal()--> **** env<"<<env<<"> ****");
    Java_netscape_javascript_JSObject_removeMember(env, jrex_jsobj, name);
    return NS_OK;
}

nsresult JRexLiveConnectSession::Call(jobject jrex_jsobj, jstring func, jobjectArray args, jobject* retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("Call()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> ****")
	*retObj = NULL;
    if(IS_EQT) {
        jobject ret = NULL;
        nsresult rv = CallInternal(jrex_jsobj, func, args, &ret);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** Call()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            *retObj = ret;
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    CallEventData *lcEventData = new CallEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("Call()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        lcEventData->func = func;
        lcEventData->args = args;
        eventData->lcEventData = lcEventData;
        *retObj = NULL;
        rv=JRexWindow::ExecInEventQ(window,CALL,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)retObj);
        JREX_LOGLN("Call()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("Call()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::CallInternal(jobject jrex_jsobj, jstring func, jobjectArray args, jobject* retObj) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("CallInternal()--> **** env<"<<env<<"> ****");
    *retObj = Java_netscape_javascript_JSObject_call(env, jrex_jsobj, func, args);
    if (NOT_NULL(*retObj)) {
        return NS_OK;
    } else {
        return NS_ERROR_UNEXPECTED;
    }
}

nsresult JRexLiveConnectSession::ToString(jobject jrex_jsobj, jstring* retStr) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("ToString()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> ****")
	*retStr = NULL;
    if(IS_EQT) {
        jstring ret = NULL;
        nsresult rv = ToStringInternal(jrex_jsobj, &ret);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** ToString()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            *retStr = ret;
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    ToStringEventData *lcEventData = new ToStringEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("ToString()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        eventData->lcEventData = lcEventData;
        *retStr = NULL;
        rv=JRexWindow::ExecInEventQ(window,TO_STRING,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)retStr);
        JREX_LOGLN("ToString()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("ToString()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::ToStringInternal(jobject jrex_jsobj, jstring* retStr) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("ToStringInternal()--> **** env<"<<env<<"> ****");
    *retStr = Java_netscape_javascript_JSObject_toString(env, jrex_jsobj);
    if (NOT_NULL(*retStr)) {
        return NS_OK;
    } else {
        return NS_ERROR_UNEXPECTED;
    }
}

nsresult JRexLiveConnectSession::Equals(jobject jrex_jsobj, jobject cmp_obj, jboolean* retIsEq) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
	JREX_LOGLN("Equals()--> **** jrex_jsobj<"<<jrex_jsobj<<"> env<"<<env<<"> ****")
    if(IS_EQT) {
        jboolean ret = JNI_FALSE;
        nsresult rv = EqualsInternal(jrex_jsobj, cmp_obj, &ret);
        if (NS_FAILED(rv)) {
            ThrowJRexException(env, "**** Equals()-->  Failed ****",rv);
            return NS_ERROR_UNEXPECTED;
        } else {
            *retIsEq = ret;
            return NS_OK;
        }
    }
	JSOBJ_GETWINDOW
    nsresult rv=NS_OK;
    JRexLiveConnectEvent *eventData = new JRexLiveConnectEvent;
    EqualsEventData *lcEventData = new EqualsEventData;
    if (eventData && lcEventData) {
        JREX_LOGLN("Equals()--> **** eventData Created ****")
        eventData->session = session;
        lcEventData->jrex_jsobj = jrex_jsobj;
        lcEventData->cmp_obj = cmp_obj;
        eventData->lcEventData = lcEventData;
        rv=JRexWindow::ExecInEventQ(window,EQUALS,eventData,PR_TRUE,HandleLiveConnectEvent,DestroyLiveConnectEvent,(void**)retIsEq);
        JREX_LOGLN("Equals()--> **** ExecInEventQ rv<"<<rv<<"> Created ****")
        if (NS_FAILED(rv)){
            delete eventData;
            delete lcEventData;
        }
    }else
        rv=NS_ERROR_OUT_OF_MEMORY;
    JREX_LOGLN("Equals()--> **** rv<"<<rv<<"> ****")
    return rv;
}

nsresult JRexLiveConnectSession::EqualsInternal(jobject jrex_jsobj, jobject cmp_obj, jboolean* retIsEq) {
    JNIEnv *env=JREX_JNI_UTIL::JRex_GetEnv(0);
    JREX_LOGLN("EqualsInternal()--> **** env<"<<env<<"> ****");
    *retIsEq = Java_netscape_javascript_JSObject_equals(env, jrex_jsobj, cmp_obj);
    return NS_OK;
}