/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#if defined(JREX_DOM)

	#ifndef JRexSelection_h_
	#define JRexSelection_h_

	#include "JRexWindow.h"
	#include "JRexDOMGlobals.h"

	namespace JRexSelection{
		nsresult GetAnchorNode(JRexWindow *window, nsIDOMNode * *aAnchorNode);
		nsresult GetAnchorOffset(JRexWindow *window, PRInt32 *aAnchorOffset);
		nsresult GetFocusNode(JRexWindow *window, nsIDOMNode * *aFocusNode);
		nsresult GetFocusOffset(JRexWindow *window, PRInt32 *aFocusOffset);
		nsresult GetIsCollapsed(JRexWindow *window, PRBool *aIsCollapsed);
		nsresult GetRangeCount(JRexWindow *window, PRInt32 *aRangeCount);
		nsresult GetRangeAt(JRexWindow *window, PRInt32 index, nsIDOMRange **_retval);
		nsresult Collapse(JRexWindow *window, nsIDOMNode *parentNode, PRInt32 offset);
		nsresult Extend(JRexWindow *window, nsIDOMNode *parentNode, PRInt32 offset);
		nsresult CollapseToStart(JRexWindow *window);
		nsresult CollapseToEnd(JRexWindow *window);
		nsresult ContainsNode(JRexWindow *window, nsIDOMNode *node, PRBool entirelyContained, PRBool *_retval);
		nsresult SelectAllChildren(JRexWindow *window, nsIDOMNode *parentNode);
		nsresult AddRange(JRexWindow *window, nsIDOMRange *range);
		nsresult RemoveRange(JRexWindow *window, nsIDOMRange *range);
		nsresult RemoveAllRanges(JRexWindow *window);
		nsresult DeleteFromDocument(JRexWindow *window);
		nsresult SelectionLanguageChange(JRexWindow *window, PRBool langRTL);
		nsresult ToString(JRexWindow *window, PRUnichar **_retval);
		//Selection event types
		enum SelectionEventTypes{JREX_SEL_GET_ANCHR_NODE=0U,
								JREX_SEL_GET_ANCHR_OFFSET,
								JREX_SEL_GET_FOCUS_NODE,
								JREX_SEL_GET_FOCUS_OFFSET,
								JREX_SEL_IS_COLLAPSED,
								JREX_SEL_GET_RANGE_COUNT,
								JREX_SEL_GET_RANGE_AT,
								JREX_SEL_COLLAPSE,
								JREX_SEL_EXTEND,
								JREX_SEL_COLLAPSE_TO_START,
								JREX_SEL_COLLAPSE_TO_END,
								JREX_SEL_CONTAINS_NODE,
								JREX_SEL_ALL_CHILD,
								JREX_SEL_ADD_RANGE,
								JREX_SEL_REMOVE_RANGE,
								JREX_SEL_REMOVEALL_RANGES,
								JREX_SEL_DELECT_FROM_DOC,
								JREX_SEL_LANG_CHANGE,
								JREX_SEL_TO_STRING};
		struct NodeEventData{
			nsIDOMNode *node;
			PRInt32 intVal;//will used for bool value to
		};
	}

	#endif//#define JRexSelection_h_

#endif //JREX_DOM
