/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.io;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;

public class JRexInputStream
extends InputStream {
    private static final String className = JRexInputStream.class.getName();
    private int streamPeer = 0;

    public JRexInputStream(int streamPeer) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** JRexInputStream() -->streamPeer<" + streamPeer + ">****");
        }
        if (streamPeer < 1) {
            throw new JRexException("Invalid native stream handle.");
        }
        this.streamPeer = streamPeer;
    }

    public int available() throws IOException {
        if (JRexL.on) {
            JRexL.log(className, "**** available() -->I AM HERE****");
        }
        try {
            return this.Available();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new IOException("JRexException <" + ex.getMessage() + "> Occured");
        }
    }

    public int read() throws IOException {
        if (JRexL.on) {
            JRexL.log(className, "**** read() -->I AM HERE****");
        }
        try {
            return this.Read();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new IOException("JRexException <" + ex.getMessage() + "> Occured");
        }
    }

    public int read(byte[] buff, int off, int len) throws IOException {
        if (JRexL.on) {
            JRexL.log(className, "**** read() --> buff<" + buff + "> off<" + off + "> len<" + len + "> ****");
        }
        if (buff == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > buff.length || off + len > buff.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            return this.Read(buff, off, len);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new IOException("JRexException <" + ex.getMessage() + "> Occured");
        }
    }

    public int read(byte[] buff) throws IOException {
        if (buff == null) {
            throw new NullPointerException();
        }
        return this.read(buff, 0, buff.length);
    }

    public synchronized void mark(int readlimit) {
        if (JRexL.on) {
            JRexL.log(className, "**** mark() --> readlimit<" + readlimit + "> Mark Not Supported!!! ****");
        }
    }

    public synchronized void reset() throws IOException {
        throw new IOException("Mark Not Supported!!!");
    }

    public long skip(long n) throws IOException {
        if (JRexL.on) {
            JRexL.log(className, "**** skip() --> n<" + n + "> skip Not Supported!!! ****");
        }
        return -1L;
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        if (JRexL.on) {
            JRexL.log(className, "**** close() --> streamPeer<" + this.streamPeer + ">****");
        }
        if (this.streamPeer > 0) {
            try {
                this.Close();
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
                throw new IOException("JRexException <" + ex.getMessage() + "> Occured");
            }
            finally {
                this.streamPeer = 0;
            }
        }
    }

    protected void finalize() throws IOException {
        if (JRexL.on) {
            JRexL.log(className, "**** finalize() --> streamPeer<" + this.streamPeer + ">****");
        }
        if (this.streamPeer > 0) {
            try {
                this.close();
            }
            catch (IOException ioex) {
                JRexL.printStackTrace(ioex);
            }
        }
    }

    private static native void initIDs() throws JRexException;

    private native int Available() throws JRexException;

    private native int Read() throws JRexException;

    private native int Read(byte[] var1, int var2, int var3) throws JRexException;

    private native void Close() throws JRexException;

    static {
        try {
            JRexInputStream.initIDs();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
    }
}

