#!/usr/bin/python2.2
# 
# Copyright 2002, 2003 Zuza Software Foundation
# 
# This file is part of mozpotools.
#
# mozpotools is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# mozpotools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mozpotools; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""simple script to convert a gettext .po localization file to a
mozilla .dtd localization format. This uses the po and dtd modules, and the
po2dtd class which is in this module
Note that to translate back a .po originally generated from a .dtd, rather use
redtd.py which does that. This version will lose unexpected stuff and formatting
from the original .dtd. It may be useful if you only have the .po
reads from stdin, writes to stdout"""

from __future__ import generators
import sys
import extract
import po
import dtd

class po2dtd:
  def convertcomments(self,thepo,thedtd):
    # get the entity from sourcecomments
    entitiesstr = ""
    for sourcecomment in thepo.sourcecomments:
      # entitystr, instring = extract.extract(sourcecomment, "#:","\n",None)
      entitiesstr += sourcecomment[2:].strip()
    entities = entitiesstr.split()
    if len(entities) > 1:
      # don't yet handle multiple entities
      thedtd.comments.append(("conversionnote",'<!-- CONVERSION NOTE - multiple entities -->\n'))
      thedtd.entity = entities[0]
    elif len(entities) == 1:
      thedtd.entity = entities[0]
    else:
      # this produces a blank entity, which doesn't write anything out
      thedtd.entity = ""

     # typecomments are for example #, fuzzy
    types = []
    for typecomment in thepo.typecomments:
      # typestr, instring = extract.extract(typecomment, "#,","\n",None)
      types.append(extract.unstripcomment(typecomment[2:]))
    for typedescr in types:
      thedtd.comments.append(("potype",typedescr+'\n'))
    # visiblecomments are for example #_ note to translator
    visibles = []
    for visiblecomment in thepo.visiblecomments:
      # visiblestr, instring = extract.extract(visiblecomment,"#_","\n",None)
      visibles.append(extract.unstripcomment(visiblecomment[2:]))
    for visible in visibles:
      thedtd.comments.append(("visible",visible+'\n'))
    # othercomments are normal e.g. # another comment
    others = []
    for othercomment in thepo.othercomments:
      # otherstr, instring = extract.extract(othercomment,"#","\n",None)
      others.append(extract.unstripcomment(othercomment[2:]))
    for other in others:
      # don't put in localization note group comments as they are artificially added
      if (other.find('LOCALIZATION NOTE') == -1) or (other.find('GROUP') == -1):
        thedtd.comments.append(("comment",other))
    # msgidcomments are special - they're actually localization notes
    for msgidcomment in thepo.msgidcomments:
      unquotedmsgidcomment = extract.extractwithoutquotes(msgidcomment,'"','"','\\',includeescapes=0)[0]
      actualnote = unquotedmsgidcomment.replace("_:","",1)
      if actualnote[-2:] == '\\n':
        actualnote = actualnote[:-2]
      locnote = extract.unstripcomment("LOCALIZATION NOTE ("+thedtd.entity+"): "+actualnote)
      thedtd.comments.append(("locnote",locnote))

  def convertstrings(self,thepo,thedtd):
    # currently let's just get the msgid back
    backslash = '\\'
    unquotedid = "\n".join([extract.extractwithoutquotes(line,'"','"',backslash,includeescapes=0)[0] for line in thepo.msgid])
    if unquotedid[:1] == "\n": unquotedid = unquotedid[1:]
    unquotedstr = "\n".join([extract.extractwithoutquotes(line,'"','"',backslash,includeescapes=0)[0] for line in thepo.msgstr])
    if unquotedstr[:1] == "\n": unquotedstr = unquotedstr[1:]
    # choose the msgstr unless it's empty, in which case choose the msgid
    if len(unquotedstr) == 0:
      unquoted = unquotedid
    else:
      unquoted = unquotedstr
    thedtd.definition = extract.eitherquotestr(unquoted) 

  def convertelement(self,thepo):
     thedtd = dtd.dtdelement()
     self.convertcomments(thepo,thedtd)
     self.convertstrings(thepo,thedtd)
     return thedtd

  def convertfile(self,thepofile):
    thedtdfile = dtd.dtdfile()
    self.currentgroups = []
    for thepo in thepofile.poelements:
      thedtd = self.convertelement(thepo)
      if thedtd is not None:
        thedtdfile.dtdelements.append(thedtd)
    return thedtdfile

def convert(fromfileclass,convertorclass):
  """reads in stdin using fromfileclass, converts using convertorclass, writes to stdout"""
  filelines = sys.stdin.readlines()
  fromfile = fromfileclass()
  fromfile.fromlines(filelines)
  convertor = convertorclass()
  tofile = convertor.convertfile(fromfile)
  tolines = tofile.tolines()
  sys.stdout.writelines(tolines)

if __name__ == '__main__':
  convert(po.pofile,po2dtd)


