#!/usr/bin/python2.2
# 
# Copyright 2002, 2003 Zuza Software Foundation
# 
# This file is part of mozpotools.
#
# mozpotools is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# mozpotools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mozpotools; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""script that converts a .po file with translations based on a .pot file
generated from a Mozilla localization .properties back to the .properties (but translated)
Uses the original .properties to do the conversion as this makes sure we don't
leave out any unexpected stuff...
reads .properties from stdin, .po from first command-line argument, writes .properties to stdout"""

import sys
import extract
import po

# read in the po (aux file)
pf = open(sys.argv[-1],'r')
potlines = [extract.unescapeunicode(line) for line in pf.readlines()]
pf.close()
p = po.pofile()
p.fromlines(potlines)

# make a dictionary of the translations
dict = {}
for thepo in p.poelements:
  # there may be more than one entity due to msguniq merge
  entities = []
  for sourcecomment in thepo.sourcecomments:
    entities += extract.rstripeol(sourcecomment)[3:].split()
  for entity in entities:
    # currently let's just get the msgstr back
    # this converts the po-style string to a prop-style string
    # i.e. no quotes but backslash at the end of the line continues to the next
    backslash = '\\'
    unquotedstr = "\\\n".join([extract.extractwithoutquotes(line,'"','"',backslash,includeescapes=0)[0] for line in thepo.msgstr])
    if unquotedstr[:2] == "\\\n": unquotedstr = unquotedstr[2:]
    dict[entity] = unquotedstr
    
# do the translation as we read in the properties source file
inmultilinemsgid = 0
inecho = 0

for line in sys.stdin.xreadlines():
  # handle multiline msgid if we're in one
  if inmultilinemsgid:
    msgid = extract.rstripeol(line).strip()
    # see if there's more
    inmultilinemsgid = (msgid[-1:] == '\\')
    # if we're echoing...
    if inecho:
      print line
  # otherwise, this could be a comment
  elif line.strip()[:1] == '#':
    print extract.rstripeol(line)
  else:
    equalspos = line.find('=')
    # if no equals, just repeat it
    if equalspos == -1:
      print extract.rstripeol(line)
    # otherwise, this is a definition
    else:
      name = line[:equalspos].strip()
      if dict.has_key(name):
        inecho = 0
        print name+"="+dict[name]
      else:
        inecho = 1
        print line
      # backslash at end means carry string on to next line
      if line[-1:] == '\\':
        inmultilinemsgid = 1

# done

