/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozCC
 *
 * The Initial Developer of the Original Code is
 * Nathan R. Yergler.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Nathan R. Yergler <nathan@yergler.net>
 *
 * ***** END LICENSE BLOCK ***** 
 *
 * $Id: license.js,v 1.4 2004/06/30 21:51:51 nathan Exp $
 *
 */

var g_attrsSeen = new Array();
var iSourceCnt = 0;

    function toggleVis(objectName) {
       
       if (document.getElementById(objectName).style.display == "block"){
          document.getElementById(objectName).style.display = "none";
       } else {
          document.getElementById(objectName).style.display = "block";
       }

    }

// parent and child are both treeitems
function appendChild(parent, child) {

   var treechildren = parent.getElementsByTagName('treechildren');

   if (treechildren.length == 0) {
      // add the treechildren element
      children = document.createElement("treechildren");
      parent.appendChild(children);
   } else {
     children = treechildren[0];
   }

   children.appendChild(child);
}

function createChild(contents, container) {

   var child = document.createElement("treeitem");
   child.setAttribute("container", container);
   child.setAttribute("open", true);


   var row = document.createElement("treerow");
   
   for (i=0; i < contents.length; i++) {
      var cell = document.createElement("treecell");
      cell.setAttribute("label", contents[i]);

      // check if this cell is a link
      if ((/http:/gi).test(contents[i])) {
         cell.setAttribute("properties", "isLink");
         cell.setAttribute("tooltiptext", "double click to open URI");
      }

      row.appendChild(cell);
   }

   child.appendChild(row);

   return child;
}

function rpart(instr) {
   rval = instr.split('/').reverse()[0]
   if (rval.indexOf("#") > -1) {
     rval = rval.split('#').reverse()[0];
   } 
     
   return rval;
}

function isSubObject(object) {
 return false;
  return (object.indexOf('genid:') > -1);
}

function isType(predicate) {
  return (predicate.indexOf('#') > -1);
}

function beenSeen(item) {
   // checks for membership in g_attrsSeen

   for (i=0; i < g_attrsSeen.length; i++) {
      if (g_attrsSeen[i] == item) return true;
   }

   return false;

}

function setSeen(item) {
   // mark an attr as seen
   g_attrsSeen.push(item);
}

/* 
function showAttrs(rdfDict, parent) {

   arcs = rdfDict.keys();

   for (a = 0; a < arcs.length; a++) {

      // get each target value for this arc label
      targets = rdfDict.getAll(arcs[a].Value);

      for (t = 0; t < targets.length; t++) {

        // check if this is a type declaration
        if (isType(arcs[a].Value)) continue;

        // check if this is a subobject
        if (isSubObject(arcs[a].Value)) {
         if (!(beenSeen(arcs[a].Value))) {
           setSeen(arcs[a].Value);

           attr = createChild([rpart(arcs[a].Value)], true);
           appendChild(parent, attr);
  
           // showAttrs(rdfDict.subObject(arcs[a]), attr);
         }
        } else {
           attr = createChild([rpart(arcs[a].Value), 
                               targets[t].Value], false);
           appendChild(parent, attr);
        }

      } // for each target

   } // for each attribute

}

*/ 

function addAttrGrid(rdfobj, parent) {

  // create the grid framework
  var grid = document.createElement("grid");

  var cc = document.createElement("columns");
  var col = document.createElement("column");
  col.setAttribute("flex", "1");
  cc.appendChild(col);
  col.setAttribute("flex", "3");
  cc.appendChild(col);

  grid.appendChild(cc);  

  var rows = document.createElement("rows");

  // get a list of keys to iterate through
  var arcs = rdfobj.keys();
  for (a=0; a < arcs.length; a++) {
    var targets = rdfobj.getAll(arcs[a].Value);
    for (t=0; t < targets.length; t++) {

      // create the row container
      var row = document.createElement("row");
  
      // create the cells
      var cell1 = document.createElement("description");
      cell1.setAttribute("value", rpart(arcs[a].Value));
      cell1.setAttribute("class", "item_title");

      // check for sub-objects
      if (targets[t].Value.indexOf("rdf:#") == 0) {
         // this is a sub-object
         if (!(beenSeen(targets[t].Value))) {
           setSeen(targets[t].Value);
  	   var cell2 = document.createElement("vbox");
           addAttrGrid(new rdfDict(targets[t], rdfobj.store), cell2);
         } else {
           continue;
         }
      } else {
         var cell2 = document.createElement("description");
         cell2.setAttribute("value", targets[t].Value);
      }

      // assemble the row
      row.appendChild(cell1);
      row.appendChild(cell2);

      // attach the row
      rows.appendChild(row);

    } // for each target
  } // for each arc

  // attach the rows
  grid.appendChild(rows);

  // attach the grid
  parent.appendChild(grid);

} // addAttrGrid

function addWork(work, works_cont) {
   var locale = document.getElementById("mozcc-string-bundle")

   if (works_cont == null) {
      works_cont = window.document.getElementById("works_container");
   }

   // create the work container
   wrk = document.createElement("vbox");
   wrk.setAttribute("class", "work");
   wrk.setAttribute("align", "stretch");

   wrk_text = document.createElement("hbox");

   // create the left column
   left = document.createElement("vbox");
   left.setAttribute("flex", "1");
   work_title = document.createElement("description");
   work_title.setAttribute("value", work.about());
   left.appendChild(work_title);

   // add the work attributes (DC, etc)
   attr_box = document.createElement("vbox");
   attr_box.setAttribute("id", "details_" + iSourceCnt );
   attr_box.setAttribute("class", "work_details");

   addAttrGrid(work, attr_box);
   left.appendChild(attr_box);

   // set up "licenses"
   licenses = document.createElement("vbox");

   lic_text = document.createElement("description");
   lic_text.setAttribute("value", locale.getString("mozcc.details.lu"));
   licenses.appendChild(lic_text);

   wrk_lics = work.licenses();

   for (l = 0; l < wrk_lics.length; l++) {
      wlic_text = document.createElement("description");
      wlic_text.setAttribute("class", "detail_block");
      wlic_text.setAttribute("value", wrk_lics[l].about());
      
      licenses.appendChild(wlic_text);
   } // for each work...

   if (wrk_lics.length > 0) left.appendChild(licenses);

   // create the right column
   right = document.createElement("vbox");

   go = document.createElement("description");
   go.setAttribute("value", locale.getString("mozcc.details.go"));
   go.setAttribute("class", "link");
   go.setAttribute("onclick", "openUrl('" + work.about() + "')");
   right.appendChild(go);

   details = document.createElement("description");
   details.setAttribute("value", locale.getString("mozcc.details.details")); 
   details.setAttribute("class", "link");
   details.setAttribute("onclick", "toggleVis('details_" + iSourceCnt + "');");
   right.appendChild(details);

   source = document.createElement("description");
   source.setAttribute("value", locale.getString("mozcc.details.source")); 
   source.setAttribute("class", "link");
   source.setAttribute("onclick", "toggleVis('src_wrk_" + iSourceCnt + "');");
   right.appendChild(source);

   // create the source container
   wrk_source = document.createElement("vbox");
   wrk_source.setAttribute("id", "src_wrk_" + iSourceCnt);
   iSourceCnt++;
   wrk_source.setAttribute("class", "license_source");
   
   rdf_txt_lines = work.asString().split('\n');
   for (r=0; r < rdf_txt_lines.length; r++) {
     source_text = document.createElement("description");
     source_text.setAttribute("class", "monospace");
     source_text.setAttribute("value", rdf_txt_lines[r]);
     wrk_source.appendChild(source_text);

   } // for each line...

   // assemble the work
   wrk_text.appendChild(left);
   wrk_text.appendChild(right);
   wrk.appendChild(wrk_text);
   wrk.appendChild(wrk_source);

   works_cont.appendChild(wrk);

} // addWork

function addLicense(license, license_cont) {

   var locale = document.getElementById("mozcc-string-bundle")
   if (license_cont == null) {
      license_cont = window.document.getElementById("licenses_container");
   } 

   // create the license container
   lic = document.createElement("vbox");
   lic.setAttribute("class", "license");
   lic.setAttribute("align", "stretch");

   lic_text = document.createElement("hbox");

   // create the left column
   left = document.createElement("vbox");
   left.setAttribute("flex", "1");
   lic_title = document.createElement("description");
   lic_title.setAttribute("value", license.about());
   lic_title.setAttribute("class", "item_title");
   left.appendChild(lic_title);

   // add the license images
   images = document.createElement("vbox");
   images.setAttribute("class", "detail_block");
   makeLicenseImages(license, images, true);
   left.appendChild(images);

   // set up "applies to"
   appliesto = document.createElement("vbox");

   at_text = document.createElement("description");
   at_text.setAttribute("value", locale.getString("mozcc.details.appliesto"));
   appliesto.appendChild(at_text);

   at_works = license.appliesTo();
   for (w = 0; w < at_works.length; w++) {
      wrk_text = document.createElement("description");
      wrk_text.setAttribute("class", "detail_block");
      wrk_text.setAttribute("value", at_works[w].about());
      
      appliesto.appendChild(wrk_text);
   } // for each work...

   if (at_works.length > 0) left.appendChild(appliesto);

   // create the right column
   right = document.createElement("vbox");
   details = document.createElement("description");
   details.setAttribute("value", locale.getString("mozcc.details.go")); 
   details.setAttribute("class", "link");
   details.setAttribute("onclick", "openUrl('" + license.about() + "')");
   right.appendChild(details);

   source = document.createElement("description");
   source.setAttribute("value", locale.getString("mozcc.details.source")); 
   source.setAttribute("class", "link");
   source.setAttribute("onclick", "toggleVis('source_" + iSourceCnt + "');");
   right.appendChild(source);

   // create the source container
   lic_source = document.createElement("vbox");
   lic_source.setAttribute("id", "source_" + iSourceCnt);
   iSourceCnt++;
   lic_source.setAttribute("class", "license_source");
   
   rdf_txt_lines = license.asString().split('\n');
   for (r=0; r < rdf_txt_lines.length; r++) {
     source_text = document.createElement("description");
     // source_text.setAttribute("class", "monospace");
     source_text.setAttribute("value", rdf_txt_lines[r]);
     lic_source.appendChild(source_text);

   } // for each line...

   // assemble the license
   lic_text.appendChild(left);
   lic_text.appendChild(right);
   lic.appendChild(lic_text);
   lic.appendChild(lic_source);

   license_cont.appendChild(lic);

   // add the license properties 
   // addAttrGrid(license, license_cont);

} // addLicense

function onLoadLicense(event) {

   status_msg = window.document.getElementById("rdf_status");
   rdf_url    = window.document.getElementById("rdf_url");

   rdfStrings = window.arguments[1]; // extractRdf(window.arguments[0]); 

   var locale = document.getElementById("mozcc-string-bundle")

   // update the status message
   status_msg.value = locale.getString('mozcc.details.parsed') + " " + 
                      rdfStrings.length + " " + 
                      locale.getString('mozcc.details.rdf_segments');
   rdf_url.value = window.arguments[0].URL;

   // make the "this page" tab the default
   window.document.getElementById("parsed_info").selectedIndex = 0;
   iSourceCnt = 0;

   // for each segment, add a node
   for (s = 0; s < rdfStrings.length; s++) {

      var cc = rdfStrings[s]; // new ccRdf();
      // cc.parse(rdfStrings[s], rdf_url.value);

      // for work information, add a node
      works = cc.works();
      for (w = 0; w < works.length; w++) {
         // update the works tab
         addWork(works[w]);

         // check if it's "this page"
         if ((works[w].about() == window.arguments[0].URL) ||
             (works[w].about() == '')) {
            addWork(works[w], document.getElementById("thispage_container"));

            // add the licenses for this work
            work_licenses = works[w].licenses();
            for (l = 0; l < work_licenses.length; l++) {
               addLicense(work_licenses[l], 
                          document.getElementById("thispage_container"));
            } // for each work license
         } // if this work refers to this page

      }  // for each work

      // for each license add a node
      licenses = cc.licenses();
      for (l=0; l < licenses.length; l++) {
         // update the licenses tab
         addLicense(licenses[l]);
      } // for each license

   } // for each segment

  return true;
}

/* dblClickRow
 *   Fired when user double-clicks a row in the tree.  Determines
 *   which column was clicked, checks if the cell is a link and if
 *   so opens the URI in a new window.
 */
function dblClickRow(event) {

   rdf_tree     = window.document.getElementById("rdf_info");
   rdf_children = window.document.getElementById("rdf_children");

   pred_col = window.document.getElementById("predicate");

   // determine which column was clicked
   if (event.pageX <= pred_col.boxObject.width) {
      celltext = rdf_tree.view.getCellText(rdf_tree.currentIndex, "predicate");
   } else {
      celltext = rdf_tree.view.getCellText(rdf_tree.currentIndex, "object");
   }

   // check if the clicked area is a link
   if ((/http:/gi).test(celltext)) {
      openUrl(celltext);
   }
   
}


function noop(args) {
   return true;
}

/* openUrl(startpage)
 *   Opens the given url (startpage) in a new browser window.
 *   Adapted from browser.js; copyright, license and source at
 *  http://lxr.mozilla.org/mozilla/source/browser/base/content/browser.js
 */
function openUrl(startpage) {

   var charsetArg = new String();
   var handler = Components.classes['@mozilla.org/commandlinehandler/general-startup;1?type=browser'];
   handler = handler.getService();
   handler = handler.QueryInterface(Components.interfaces.nsICmdLineHandler);

   var url = handler.chromeUrlForTask;
   var wintype = document.firstChild.getAttribute('windowtype');
 
   // if and only if the current window is a browser window and 
   // it has a document with a character
   // set, then extract the current charset menu setting from 
   // the current document and use it to
   // initialize the new browser window...
   if (window && (wintype == "navigator:browser") && 
       window._content && window._content.document)
   {
     var DocCharset = window._content.document.characterSet;
     charsetArg = "charset="+DocCharset;
 
     //we should "inherit" the charset menu setting in a new window
     window.openDialog(url, "_blank", "chrome,all,dialog=no", 
                       startpage, charsetArg);
   }
   else // forget about the charset information.
   {
     window.openDialog(url, "_blank", "chrome,all,dialog=no", startpage);
   }

}

