/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozCC
 *
 * The Initial Developer of the Original Code is
 * Nathan R. Yergler.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Nathan R. Yergler <nathan@yergler.net>
 *
 * ***** END LICENSE BLOCK ***** */

/* smprefs.js
 * $Id: smprefs.js,v 1.2 2004/06/25 15:12:35 nathan Exp $
 */

function mozccUninstall() {

   // close the prefs window
   window.close();

   // call the jsLib uninstall function
   jslibUninstall('mozcc');

   window.close();

   return true;

} // mozccUninstall

function mozccUpgrade() {

   // check for an upgrade and install it if available
   updater = new nsExtensionUpdater("http://mozcc.mozdev.org/smversion.xml", 
                                    "0.8.0",
                                    "mozcc.jar");
   updater.getUpdate(progressFunc); 

   return true;

} // mozccUpgrade

/*
aProgressNum
  -1      An error has occured
   0      No new update available
   1      New update available.  If we are to proceed and install
           the update, return true, else return false.
   2      New update installed
*/

function progressFunc(aProgressNum){

 var rv = true;

 switch (aProgressNum){

   case -1 :
     alert("An Error Has Occured")
     break;

   case 1 :
     // here is where you should ask if the user really wants to install the update
     // return true to do the update, false to not.
     rv = confirm("An update is available.  Do you want to install it?");
     break;

   case 2 :
     alert("Install Successfull")
     break;  }

 return rv;
} 
