/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/license.html
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Playsophy code (www.playsophy.com).
 *
 * The Initial Developer of the Original Code is Playsophy
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 

/** Undo Redo Module
 * @fileoverview Allows Mozile to store a stack of past document states, and restore them on command.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */




/** Mozile - Undo Stack -
 * An array which contains stored states for the document.
 */
Mozile.prototype.undoStack = new Array();

/** Mozile - Undo Counter -
 * An integer which tracks the current position in the undoStack.
 */
Mozile.prototype.undoCounter = 0;



/** Mozile - Store State -
 * Records the state of the document and adds it to the undoStack.
 * 
 * @return True if successful.
 */
Mozile.prototype.storeState = function(command) {
	var f = new Array("UndoRedo/UndoRedo.js","Mozile.storeState()");
	this.debug(f,3,"Storing document");

	this.changesSaved = false;

	// Reset the key counter
	this.keyCounter = 0;

	var selection = window.getSelection();
	
	// For each editor in the document, add it and a clone of its contents to the states array.
	var states = new Array();
	var editorArray;
	for(var i=0; i<this.editorList.length; i++) {
		editorArray = new Array(this.editorList[i], this.editorList[i].cloneNode(true) );
		states.push(editorArray);
	}
	
	// Store the data on the selection.
	var selectionArray = this.storeSelection();


	// If the undoCounter is less than the length of the undoStack-1, throw out all the entries above the undoCounter entry.
	if(this.undoCounter < this.undoStack.length - 1) {
		this.undoStack = this.undoStack.slice(0,this.undoCounter+1);
	}
	
	// Add the current state to the undoStack
	var stateArray = new Array(command, states, selectionArray)
	this.undoStack.push(stateArray);
	this.undoCounter = this.undoStack.length - 1;
	
	return true;
}



/** Mozile - Restore State -
 * Replaces the contents of all editors in the document with their states as recoreded at a given index of the undoStack.
 * 
 * @param index. The index from the undoStack to be restored.
 * @return True if successful.
 */
Mozile.prototype.restoreState = function(index) {
	var f = new Array("UndoRedo/UndoRedo.js","Mozile.restoreState()");
	this.debug(f,3,"Restoring state "+ index);
	
	var command         = this.undoStack[index][0];
	var states          = this.undoStack[index][1];
	var selectionArray  = this.undoStack[index][2];
	
	//dumpArray(states);
	
	var i,j=0;
	var editor, editorCopy;
	for(j=0; j<states.length; j++) {
		editor = states[j][0];
		editorCopy = states[j][1];
		
		// Remove all children of the editor element.
		while(editor.childNodes.length) {
			editor.removeChild(editor.firstChild);
		}
		
		// Append a clone of each child of the editorCopy.
		var children = editorCopy.childNodes;
		for(i=0; i<children.length; i++) {
			editor.appendChild(children[i].cloneNode(true));
		}
	}
	
	// Restore the selection.
	this.restoreSelection(selectionArray);
	window.getSelection().collapseToEnd();
	
	return true;
}



// Set up buttons

var mozileUndo = mozile.rootCommandList.createCommand("MozileCommand: id=Mozile-Undo, label=Undo, tooltip='Undo the previous action', accelerator='Command-Z', image='"+mozile.root+"images/undo.png'");
mozileUndo.command = function() {
	if(mozile.undoCounter <= 0) {
		//alert("Nothing to Undo!");
		return false;
	}
	else {
		mozile.undoCounter--;
		mozile.restoreState(mozile.undoCounter);
		return true;
	}
}
var mozileRedo = mozile.rootCommandList.createCommand("MozileCommand: id=Mozile-Redo, label=Redo, tooltip='Redo the next action', accelerator='Command-Shift-Z', image='"+mozile.root+"images/redo.png'");
mozileRedo.command = function() {
	if(mozile.undoCounter >= mozile.undoStack.length - 1) {
		//alert("Nothing to Redo!");
		return false;
	}
	else {
		mozile.undoCounter++;
		mozile.restoreState(mozile.undoCounter);
		return true;
	}
}


mozile.registerModule("UndoRedo","1.0.0");