

/** Check Command Options
 * Checks the options which are critical for commands.
 */
function checkCommandOptions(component) {
 	assertNotUndefined("The component should be defined.", component);
	assertEquals("getId() should return the name", id, component.getId());
 	
 	var pairs = new Array();
 	pairs['id'] = id;
 	pairs['label'] = label;
 	pairs['tooltip'] = tooltip;
 	pairs['accesskey'] = accesskey;
 	pairs['accelerator'] = accelerator;
 	pairs['image'] = image;

	// Loop over the array, checking each of the values	
	for(key in pairs) {
		assertNotNull("The "+key+" should exist", component.getOption(key));
		assertNotUndefined("The "+key+" should be defined", component.getOption(key));
		assertEquals("The "+key+" should be "+pairs[key], pairs[key], component.getOption(key));
	}
}




/** Check Button
 * Makes sure the button element attributes are properly set.
 */
function checkButton(element) {
	assertEquals("The localName of element should be 'toolbarbutton'", "toolbarbutton", element.localName);
	assertEquals("The id of element should equal id-Button", id+"-Button", element.getAttribute("id"));
	assertEquals("The class of element should equal 'mozileButton'", "mozileButton", element.getAttribute("class"));
	assertEquals("The image of element should equal "+image, image, element.getAttribute("image"));
	assertEquals("The label of element should equal "+label, label, element.getAttribute("label"));
	assertEquals("The tooltiptext of element should equal "+tooltip, tooltip, element.getAttribute("tooltiptext"));
}


/** Check Menuitem
 * Makes sure the menuitem element attributes are properly set.
 */
function checkMenuitem(element) {
	assertEquals("The localName of element should be 'menuitem'", "menuitem", element.localName);
	assertEquals("The id of element should equal id-Menuitem", id+"-Menuitem", element.getAttribute("id"));
	assertEquals("The class of element should equal 'mozileMenuitem'", "mozileMenuitem", element.getAttribute("class"));
	assertEquals("The label of element should equal "+label, label, element.getAttribute("label"));
	assertEquals("The tooltiptext of element should equal "+tooltip, tooltip, element.getAttribute("tooltiptext"));
	assertEquals("The accesskey of element should equal "+accesskey, accesskey, element.getAttribute("accesskey"));
}
