
/** Test - Check Component Basics
 * Basic tests to ensure that the component exists and simple methods are working.
 */
function checkComponentBasics(component) {
	assertNotNull("component should not be null", component);
	assertNotUndefined("component should not be undefined", component);
	assertEquals("component should be an object", typeof(new Object()), typeof(component));
	
	assertEquals("getName() should return the name", name, component.getName());
	assertNotNull("The configString key should exist", component.getConfigString());
	assertNotUndefined("The configString key should be defined", component.getConfigString());

	assertNotNull("getOptions() should not be null", component.getOptions());
	assertNotUndefined("getOptions() should be defined.", component.getOptions());
	assertEquals("getOptions() should return an object.", "object", typeof(component.getOptions()));
}


function checkOptions(component) {
	var key = "test";
	var value = "Value";
	
	assertNotNull("The "+key+" option should be not be null", component.getOption(key));
	assertUndefined("The "+key+" option should be undefined", component.getOption(key));
	
	component.setOption(key, value);
	
	assertNotNull("The "+key+" option should be not be null", component.getOption(key));
	assertNotUndefined("The "+key+" option should not be undefined", component.getOption(key));
	assertEquals("The "+key+" options should equal "+value, value, component.getOption(key));

}