/** Mozile Component Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileModule object.
 * Requires MozileComponentUtils.js,MozileResourceUtils.js
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


var name = "DummyModule";
var category = "script";
var id = "Mozile-"+name+"-"+name+".js";

/** Test - Constructor
 * Test the constructor and basic methods.
 */
function testConstructor() {
	var component = new MozileModule(name);
	checkComponentBasics(component);
	checkModuleBasics(component);
}




/** Test - Options
 * Test getting and setting options.
 */
function testOptions() {
	var configString = "DummyModule garbage text";
	var component = new MozileModule(configString);
	checkOptions(component);
}



/** Test - Load
 * Test the loading of the module.
 */
function testLoad() {
	var configString = "DummyModule garbage text";
	var component = new MozileModule(configString);

	var count1 = document.getElementsByTagName(category).length;
	assertEquals("There should be no elements with the matching id", 0, countElements(category, id));
	
	component.load();
	var count2 = document.getElementsByTagName(category).length;
	assertEquals("There should be one more element now.", count2, count1+1);
	assertEquals("There should be exactly one element with the matching id", 1, countElements(category, id));
	
	assertNotNull("There should be a moduleList entry for this module", mozile.getModule(name));
	assertNotUndefined("The moduleList entry should be defined", mozile.getModule(name));
	assertTrue("The moduleList entry should be identical to the component", component === mozile.getModule(name));
	
	var configString2 = "DummyModule2 garbage text";
	var component2 = new MozileModule(configString2);
	component2.load();
	assertEquals("There should still be exactly one element with the matching id", 1, countElements(category, id));
	assertEquals("There should be exactly one element with the matching id", 1, countElements(category, "Mozile-DummyModule2-DummyModule2.js"));

}


/** Test - Check Module Basics
 * Basic tests for module getters: id, source, etc.
 */
function checkModuleBasics(component) {
	var source = mozile.getRoot() +"modules/"+ component.getName() +"/"+ component.getName() +".js";
	assertEquals("getId() should return the id", id, component.getId());
	assertEquals("getSource() should return the source", source, component.getSource());

}
