/** Check Resource Basic
 * Basic tests to make sure that the resource exists, is of the right type, and its methods work properly.
 */
function checkResourceBasic(resource) {	
	assertNotNull("resource should not be null", resource);
	assertNotUndefined("resource should not be undefined", resource);
	assertEquals("resource should be an object", typeof(new Object()), typeof(resource));

	assertEquals("getCategory() should return the category", category, resource.getCategory());
	assertEquals("getId() should return the id", id, resource.getId());
}


/** Check Resource
 * Additional tests for default type and namespace.
 */
function checkResource(resource) {	
	checkResourceBasic(resource);
	assertEquals("getType() should return the defaultType", defaultType, resource.getType());
	assertEquals("getNamespace() should return the defaultNamespace", defaultNamespace, resource.getNamespace());
}


/** Check Resource NS
 * Additional tests for specified type and namespace.
 */
function checkResourceNS(resource) {
	checkResourceBasic(resource);
	assertEquals("getType() should return the type", type, resource.getType());
	assertEquals("getNamespace() should return the namespace", namespace, resource.getNamespace());
}


/** Check Element Basic
 * Basic tests to make sure that the resource's element is of the right kind and has the right attributes.
 */
function checkElementBasic(element) {
	assertEquals("The localName of element should equal category", category, element.localName);
	assertEquals("The id of element should equal id", id, element.getAttribute("id"));
}


/** Check Element
 * Additional tests for default type and namespace.
 */
function checkElement(element) {
	checkElementBasic(element);
	assertEquals("The type of element should equal defaultType", defaultType, element.getAttribute("type"));
	assertEquals("The namespaceURI of element should equal defaultNamespace", defaultNamespace, element.namespaceURI);
}


/** Check Element NS
 * Additional tests for specified type and namespace.
 */
function checkElementNS(element) {
	checkElementBasic(element);
	assertEquals("The type of element should equal type", type, element.getAttribute("type"));
	assertEquals("The namespaceURI of element should equal namespace", namespace, element.namespaceURI);
}


/** Compare Elements
 * Compare three elements, checking that 1 != 2 == 3.
 */
function compareElements(element1, element2, element3) {
	assertFalse("element1 and element2 should not be identical", element1 === element2);
	assertEquals("element2 and element3 should be equal", element2, element3);
	assertTrue("element2 and element3 should be identical", element2 === element3);
}


/** Count Elements
 * Find elements with a matching id, and return the number of them.
 */
function countElements(elementName, id) {
	var elements = document.getElementsByTagName(elementName);
	var count = 0;	
	for(i=0;i<elements.length;i++) {
		if(elements[i].getAttribute("id") == id) {
			count++;
		}
	}
	return count;
}
