<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--
Mozile Documentation XSL: XML to XHTML

Revised: 2005-08-30
-->
	<xsl:output method="html" indent="yes"/>
	
	<xsl:template match="/">
<html>

	<head>

		<title>Mozile Tests: mozile.js</title>
		<script type="application/x-javascript" src="index.js"/>
		<style type="text/css">
		
body {
	font-family: Arial, Helvitica, sans-serif;	
}

table {
	width: 100%;
}

.table {
	font-size: larger;
	font-weight: bold;
	background-color: lightblue;
}

.component {
	font-size: larger;
	font-weight: bold;
	background-color: #EEEEEE;
}

.name {
	background-color: lightgray;
	padding: 5px;
}

.description {
	font-style: italic;
	padding: 10px 5px 10px 5px;
}

.test1 {
}

.test2 {
	font-size: small;
	color: #888888;
	background-color: #EFEFEF;
}

.depth0 .name { 
	border-right: solid white 20px;
}
.depth1 .name {
	border-left: solid white 10px;
	border-right: solid white 10px;
}
.depth2 .name {
	border-left: solid white 20px;
}

.button {
	text-align: center;
	background-color: #CCCCCC;
	color: white;
	-moz-border-radius: 4px;
	padding: 2px 5px 2px 5px;
}
.button:hover {
	background-color: gray;
	cursor: pointer;
}

#mainButton {
	font-size: larger;
	font-weight: bold;
}


		</style>

	</head>

	<body>

		<h2>Mozile Test Suite</h2>
		<!--<p class="button" onclick="javascript:openUnitTestPage('fullSuite.html')">Mozile Full Test Suite</p>-->
		<p>
			<span id="mainButton" class="button">
				<xsl:attribute name="onclick">
					<xsl:text>javascript:openUnitTestPage('core/testsuite.html?</xsl:text>
					<xsl:variable name="count" select="count(//test)"/>
					<xsl:for-each select="//test">
						<xsl:value-of select="@testpage"/>
						<xsl:if test="position() != $count">
							<xsl:text>;</xsl:text>
						</xsl:if>
					</xsl:for-each>
					<xsl:text>')</xsl:text>
				</xsl:attribute>
				<xsl:text>Run Full Test Suite</xsl:text>
			</span>
		</p>
		
		<table>
			<tr class="table">
				<th>Test</th>
				<th></th>
				<th>ALL</th>
				<th>HTML</th>
				<th>XHTML</th>
				<th>XML</th>
				<!--<th>XUL</th>-->
			</tr>
			
			<xsl:apply-templates/>
		
		</table>
	</body>
</html>
	</xsl:template>
	
	<xsl:template match="component">
		<tr class="component">
			<td colspan="2">
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="@path"/>
					</xsl:attribute>
					<xsl:value-of select="@name"/>
				</a>
			</td>
			<td class="button" colspan="5">
				<xsl:attribute name="onclick">
					<xsl:text>javascript:openUnitTestPage('core/testsuite.html?</xsl:text>
					<xsl:variable name="count" select="count(.//test)"/>
					<xsl:for-each select=".//test">
						<xsl:value-of select="@testpage"/>
						<xsl:if test="position() != $count">
							<xsl:text>;</xsl:text>
						</xsl:if>
					</xsl:for-each>
					<xsl:text>')</xsl:text>
				</xsl:attribute>
				<xsl:text>Test Suite</xsl:text>
					<!--<xsl:value-of select="@name"/>-->
			</td>
		</tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="test">
		<tr>
			<xsl:attribute name="class">
				<xsl:text>depth</xsl:text>
				<xsl:value-of select="count(ancestor::test)"/>
			</xsl:attribute>
			<th class="name" rowspan="2">
				<xsl:value-of select="@name"/>
			</th>
			<td class="description" colspan="6">
				<xsl:value-of select="@description"/>
			</td>
		</tr>
		<tr>
			<xsl:attribute name="class">
				<xsl:text>test2</xsl:text>
			</xsl:attribute>
			<td>
				<xsl:value-of select="@targets"/>
			</td>
			<td class="button">
				<xsl:attribute name="onclick">
					<xsl:choose>
						<xsl:when test="@type='unit'">
							<xsl:text>javascript:openUnitTestPage('core/testsuite.html?</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>javascript:openPerformanceTestPage('core/testsequence.html?</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="@testpage"/>
					<xsl:text>')</xsl:text>
				</xsl:attribute>
				<xsl:text>ALL</xsl:text>
			</td>
			<td class="button">
				<xsl:attribute name="onclick">
					<xsl:choose>
						<xsl:when test="@type='unit'">
							<xsl:text>javascript:openUnitTestPage('core/testpage.htm?</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>javascript:openPerformanceTestPage('core/testpage.htm?</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="@testpage"/>
					<xsl:text>')</xsl:text>
				</xsl:attribute>
				<xsl:text>HTML</xsl:text>
			</td>
			<td class="button">
				<xsl:attribute name="onclick">
					<xsl:choose>
						<xsl:when test="@type='unit'">
							<xsl:text>javascript:openUnitTestPage('core/testpage.html?</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>javascript:openPerformanceTestPage('core/testpage.html?</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="@testpage"/>
					<xsl:text>')</xsl:text>
				</xsl:attribute>
				<xsl:text>XHTML</xsl:text>
			</td>
			<td class="button">
				<xsl:attribute name="onclick">
					<xsl:choose>
						<xsl:when test="@type='unit'">
							<xsl:text>javascript:openUnitTestPage('core/testpage.xml?</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>javascript:openPerformanceTestPage('core/testpage.xml?</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="@testpage"/>
					<xsl:text>')</xsl:text>
				</xsl:attribute>
				<xsl:text>XML</xsl:text>
			</td>
			<!--
			<td class="button">
				<xsl:attribute name="onclick">
					<xsl:choose>
						<xsl:when test="@type='unit'">
							<xsl:text>javascript:openUnitTestPage('core/testpage.xul?</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>javascript:openPerformanceTestPage('core/testpage.xul?</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="@testpage"/>
					<xsl:text>')</xsl:text>
				</xsl:attribute>
				<xsl:text>XUL</xsl:text>
			</td>
			-->
		</tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	
	
</xsl:stylesheet>