/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's common utility functions.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: util.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */

mozile.loadModule("mozile.util");
var name = "mozile.util.*";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testDump", "testCapitalize", "testPad", "testDebug" ];
}

/**
 * 
 */
function testDump() {
	var obj = {
		key1: "val1",
		key2: "val2"
	}

	var dumpKeys = "key1, key2";
	assertEquals("Dump the object's keys", dumpKeys, mozile.util.dumpKeys(obj) );

	var dumpValues = "key1 = val1\nkey2 = val2";
	assertEquals("Dump the object's keys and values", dumpValues, mozile.util.dumpValues(obj) )
}

/**
 * 
 */
function testCapitalize() {
	var before = "this is lower case";
	var after = "This Is Lower Case";

	assertEquals("Capitalize the string", after, mozile.util.capitalize(before) );
}

/**
 * 
 */
function testPad() {
	var before = "two words";
	var after1 = "two words     ";
	var after2 = "     two words";

	assertEquals("Pad the string on the right", after1, mozile.util.pad(before, 14) );
	assertEquals("Pad the string on the left", after2, mozile.util.pad(before, 14, true) );
}

/**
 * 
 */
function testDebug() {
	// Omitted for now.
}