/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's navigateLeftRight command.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: navigateLeftRight.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.navigateLeftRight";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testCommand"];
}

/**
 * 
 */
function testCommand() {
	var command = mozile.edit.navigateLeftRight;
	assertEquals("Name should be 'NavigateLeftRight'", "NavigateLeftRight", command.name);
	
	var event = {
		type: "keypress", 
		keyCode: 39, // Right
		ctrlKey: false, 
		metaKey: false
	}
	if(mozile.browser.isIE) event.type = "keydown";
	var iterations = 250;
	
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	selection.collapse(document.getElementById("target").firstChild, 5);
	var startNode = selection.focusNode;
	var startOffset = selection.focusOffset;
	
	// Right
	var state;
	for(var i=0; i < iterations; i++) {
		state = command.trigger(event);
		assertTrue("Command "+ i +" should have been executed.", state.executed);
	}
	
	//alert(mozile.util.dumpValues(selection.store()));
	
	// Left
	event.keyCode = 37;
	for(var i=0; i < iterations; i++) {
		state = command.trigger(event);
		assertTrue("Command "+ i +" should have been executed.", state.executed);
	}
	
	// Make sure we're where we started.
	assertEquals("focusNode should match startNode", startNode, selection.focusNode);
	assertEquals("focusOffet should match startOffset", startOffset, selection.focusOffset);
	
}

