/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Include object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Include.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");
mozile.require("mozile.xml");
mozile.require("mozile.test.rng.util");

var name = "mozile.rng.Include";
var includeRoot = "../rng/";
var includePath = includeRoot +"include.rng";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testRNGNode", "testInclude", "testValidate"];
}

/**
 * Create a sample node.
 */
function getNode() {
	return new mozile.rng.Include(mozile.xml.parseElement('<include href="'+ includePath +'"/>'), mozile.test.rng.schema);
}
	
/**
 * 
 */
function testRNGNode() {
	var RNGNode = getNode();
	mozile.test.rng.checkRNGNode(RNGNode);
}

/**
 * 
 */
function testInclude() {
	// Test simple include.
	var RNGNode = getNode();
	var schema = new mozile.rng.Schema('<grammar xmlns="http://relaxng.org/ns/structure/1.0"> <start> <ref name="D"/> </start> </grammar>');
	var grammar = schema._root;
	RNGNode._parentNode = grammar;
	
	var validation = new mozile.rng.Validation();
	validation = RNGNode.include(validation);
	assertTrue("Include operation should succeed", validation.isValid);

	// Test nested include and definition override.
	var schema = new mozile.rng.Schema();
	validation = schema.parse('<grammar xmlns="http://relaxng.org/ns/structure/1.0"> <start> <ref name="D"/> </start> <include href="'+ includeRoot + 'include2.rng"/> </grammar>');
	assertTrue("The validation should succeed", validation.isValid);
	var element = schema._root.getDefinition("D").getChildNode(0);
	assertEquals("The definition of 'D' in include2.rng should override include3.rng", "a", element.getName());

}

/**
 * Test validation.
 */
function testValidate() {
	//mozile.test.rng.checkCases(name);
}


