/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview Provides support for testing Mozile's RNG system.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: util.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.dom");
mozile.require("mozile.rng");
mozile.require("mozile.xml");

mozile.test.rng = {};
mozile.test.rng.schema = new mozile.rng.Schema();
mozile.test.rng.library = null;

/**
 * 
 */
mozile.test.rng.checkRNGNode = function(RNGNode, fakeName) {
	assertEquals("The type should match the element", mozile.dom.getLocalName(RNGNode._element), RNGNode.getType());
	if(!fakeName) fakeName = name;
	//assertEquals("The toString result should match the name", "[object "+fakeName+"]", RNGNode.toString());
	assertEquals("The schema should be mozile.test.rng.schema", mozile.test.rng.schema, RNGNode.getSchema());
	assertTrue("The RNGNode should have a child array", RNGNode.getChildNodes().length >= 0);
}

/**
 * Checks an RNG schema against an series of XML fragments from the RNGLibrary.
 * @param {String} name The name (id) of the test suite to check.
 * @param {Array} exceptions An array of integers denoting test cases to skip.
 */
mozile.test.rng.checkCases = function(name, exceptions) {
	if(!mozile.test.rng.library)
		mozile.test.rng.library = mozile.xml.load("../../demos/RNGLibrary.xml");

	var testCases = new Array();
	var testSuites = mozile.test.rng.library.getElementsByTagName("testSuite");
	var testSuite;
	var i=0;
	for(i=0; i < testSuites.length; i++) {
		if(testSuites[i].getAttribute("id") == name) {
			testSuite = testSuites[i];
			break;
		}
	}

	var i=0;
	for(i=0; i < testSuite.childNodes.length; i++) {
		if(testSuite.childNodes[i].nodeName == "testCase") 
			testCases.push(testSuite.childNodes[i]);
	}
	
	// Check each test case.
	var schema, element, validation;
	for(i=0; i < testCases.length; i++) {
		// If there are exceptions, skip those test cases
		if(exceptions) {
			var skip = false;
			for(var e=0; e < exceptions.length; e++) {
				if(i == exceptions[e]) {
					skip = true;
					break;
				}
			}
			if(skip) continue;
		}
	
		// Get the RNG fragment
		var child = testCases[i].firstChild;
		while(child) {
			if(child.nodeName == "correct" || child.nodeName == "incorrect") break;
			child = child.nextSibling;
		}

		// Check an incorrent RNG fragment.
		if(child.nodeName == "incorrect") {
			schema = new mozile.rng.Schema();
			element = mozile.dom.getFirstChildElement(child);
			validation = schema.parse(element);
			assertFalse("TestCase "+ i +": An incorrect schema should not be valid", validation.isValid);
		}

		// Check a correct RNG fragment.
		else if(child.nodeName == "correct") {
			schema = new mozile.rng.Schema()
			element = mozile.dom.getFirstChildElement(child);
			validation = schema.parse(element);
			assertTrue("TestCase "+ i +": A correct schema should be valid", validation.isValid);

			// Validate all XML fragments.
			while(child) {
				var j = 0;
				// Validate a valid XML fragment.
				if(child.nodeName == "valid") {
					element = mozile.dom.getFirstChildElement(child);
					validation = schema.validate(element);
					assertTrue("TestCase "+ i +","+ j +": A valid document should be valid", validation.isValid);
				}

				// Validate an invalid XML fragment.
				else if(child.nodeName == "invalid") {
					element = mozile.dom.getFirstChildElement(child);
					validation = schema.validate(element);
					assertFalse("TestCase "+ i +","+ j +": An invalid document should not be valid", validation.isValid);
				}

				child = child.nextSibling;
				j++;
			}
		}
	}
}


/*
mozile.test.rng.checkCases = function(cases, name, result) {
	var xmlDoc, rngDoc, schema, RNGNode, validation;
	for(var i=0; i < cases.length; i++) {
		rngDoc = mozile.xml.parseElement(cases[i]["rng"]);
		var schema = new mozile.rng.Schema(rngDoc);
		for(var j=0; j < cases[i][name].length; j++) {
			xmlDoc = mozile.xml.parseElement(cases[i][name][j]);
			validation = schema.validate(xmlDoc);
			//alert("("+ i +","+ j +")\n"+ cases[i]["rng"] +"\n"+ cases[i][name][j] +"\n"+ validation.report());
			assertEquals("Validation of "+ name +"["+ i +","+ j +"] should be "+ result, result, validation.isValid);
		}
	}
}
*/

