/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's saving functionality.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: save.js,v 1.2 2006/08/23 16:55:33 jameso Exp $
 */

mozile.require("mozile.save");
mozile.require("mozile.test.shared.util");
var name = "mozile.save";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testGetContentElement"];
	return ["testIsSaved", "testSave", "testSaveAs", "testGetContentDocument", "testGetContentElement", "testGetXMLDeclaration", "testGetDoctypeDeclaration", "testGetProcessingInstructions", "testCleanDOM", "testCleanContent", "testCleanMarkup", "testToUpperCase", "testToLowerCase"];
}

/**
 * 
 */
function testIsSaved() {
	// Currently trivial.
}

/**
 * 
 */
function testSave() {
	// Currently trivial.
}

/**
 * 
 */
function testSaveAs() {
	// Currently trivial.
}

/**
 * 
 */
function testGetContentDocument() {
	var content = mozile.save.getContent(document);
	var compare;
	if(mozile.browser.isIE) {
		if(mozile.test.isHTML) {
			compare = '<HTML>';
		}
		if(mozile.test.isXHTML) {
			// TODO: should be lower case
			compare = '<HTML>'; 
		}
		if(mozile.test.isXML) {
			compare = '<document xmlns="http://mozile.mozdev.org/" xmlns:html="http://www.w3.org/1999/xhtml">';
		}
	}
	else {
		if(mozile.test.isHTML) {
			compare = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">\n<HTML>';
		}
		if(mozile.test.isXHTML) {
			// TODO: should be lower case
			compare = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\n<HTML>'; 
		}
		if(mozile.test.isXML) {
			compare = '<?xml version="1.0" encoding="UTF-8"?>\n<?xml-stylesheet href="testpage.css" type="text/css"?>\n<document xmlns="http://mozile.mozdev.org/" xmlns:html="http://www.w3.org/1999/xhtml">';
		}
	}
	
	assertEquals("The content should match the compare string", compare, content.substring(0, compare.length));
}

/**
 * 
 */
function testGetContentElement() {
	var target2 = document.getElementById("target2");
	
	// Standard case
	var content = mozile.save.getContent(target2);
	var compare;
	if(mozile.browser.isIE) compare = '<SPAN id=target2>JavaScript</SPAN>';
	else {
		if(mozile.test.isHTML) compare = '<SPAN id="target2">JavaScript</SPAN>';
		// TODO: Should be lowercase.
		if(mozile.test.isXHTML) compare = '<SPAN id="target2">JavaScript</SPAN>';
		if(mozile.test.isXML) compare = '<html:span xmlns:html="http://www.w3.org/1999/xhtml" id="target2">JavaScript</html:span>';
	}
	assertEquals("The content should match the compare string", compare, content);
	
	// Lowercase
	content = mozile.save.getContent(target2, "lowercase");
	if(mozile.browser.isIE) compare = '<span id=target2>JavaScript</span>';
	else {
		if(mozile.test.isHTML) compare = '<span id="target2">JavaScript</span>';
		// TODO: Should be lowercase.
		if(mozile.test.isXHTML) compare = '<span id="target2">JavaScript</span>';
		if(mozile.test.isXML) compare = '<html:span xmlns:html="http://www.w3.org/1999/xhtml" id="target2">JavaScript</html:span>';
	}
	assertEquals("The content should match the compare string", compare, content);
	
}


/**
 * 
 */
function testGetXMLDeclaration() {
	if(mozile.browser.isIE) return;
	if(mozile.test.isHTML) return;
	if(mozile.test.isXHTML) return;

	var xmlDec = '<?xml version="1.0" encoding="UTF-8"?>\n';
	assertEquals("The XML Declarations should match", xmlDec, mozile.save.getXMLDeclaration());
}

/**
 * 
 */
function testGetDoctypeDeclaration() {
	if(mozile.browser.isIE) return;
	if(mozile.test.isXML) return;
	
	var doctype;
	if(mozile.test.isHTML) {
		doctype = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">\n';
	}
	if(mozile.test.isXHTML) {
		doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\n';
	}
	
	if(doctype) {
		assertEquals("The DocType Declarations should match", doctype, mozile.save.getDoctypeDeclaration());
	}
}

/**
 * 
 */
function testGetProcessingInstructions() {
	if(mozile.browser.isIE) return;
	if(mozile.test.isHTML) return;
	if(mozile.test.isXHTML) return;

	var PI = '<?xml-stylesheet href="testpage.css" type="text/css"?>\n';
	assertEquals("The processing instructions should match", PI, mozile.save.getProcessingInstructions());
}

/**
 * 
 */
function testCleanDOM() {
	var root = mozile.dom.createElement("div");

	var link = mozile.dom.createElement("link");
	link.setAttribute("class", "mozileLink");
	root.appendChild(link);
	
	var p = mozile.dom.createElement("p");
	root.appendChild(p);
	
	var gui = mozile.dom.createElement("div");
	if(mozile.browser.isIE) gui.className = "mozileGUI";	
	else gui.setAttribute("class", "mozileGUI");
	root.appendChild(gui);

	var result = mozile.save.cleanDOM(root);
	assertEquals("There should be one child left", 1, result.childNodes.length);
	assertEquals("The one child should be p", p, result.firstChild);
}

/**
 * 
 */
function testCleanContent() {
	// Currently trivial.
}

/**
 * 
 */
function testCleanMarkup() {
	var before = '<h3 id="heading">Heading</h3>';
	var after = '&lt;h3 id="heading"&gt;Heading&lt;/h3&gt;';
	assertEquals("The clean 'before' should match 'after'", after, mozile.save.cleanMarkup(before));
}

/**
 * 
 */
function testToUpperCase() {
	var before = '<h3 id="heading">Heading</h3>';
	var after = '<H3 id="heading">Heading</H3>';
	assertEquals("The clean 'before' should match 'after'", after, mozile.save.toUpperCase(before));
}

/**
 * 
 */
function testToLowerCase() {
	var before = '<H3 id="heading">Heading</H3>';
	var after = '<h3 id="heading">Heading</h3>';
	assertEquals("The clean 'before' should match 'after'", after, mozile.save.toLowerCase(before));
}
