/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


/*
 *  npupp.h Mozilla Revision:3.26 
 *  BUT (Peter Leese) - commented out new stuff for backwards compatibility 
 *  function call mecahnics needed by platform specific glue code.
 */


#ifndef _NPUPP_H_
#define _NPUPP_H_

#ifndef GENERATINGCFM
#define GENERATINGCFM 0
#endif

#ifndef _NPAPI_H_
#include "npapi.h"
#endif

#include "npruntime.h"


/******************************************************************************************
   plug-in function table macros
 	        for each function in and out of the plugin API we define
                    typedef NPP_FooUPP
 *******************************************************************************************/


/* NPP_Initialize */
typedef void (* NP_LOADDS NPP_InitializeUPP)(void);

/* NPP_Shutdown */
typedef void (* NP_LOADDS NPP_ShutdownUPP)(void);

/* NPP_New */
typedef NPError	(* NP_LOADDS NPP_NewUPP)(NPMIMEType pluginType, NPP instance, uint16_t mode, int16_t argc, char* argn[], char* argv[], NPSavedData* saved);

/* NPP_Destroy */
typedef NPError	(* NP_LOADDS NPP_DestroyUPP)(NPP instance, NPSavedData** save);

/* NPP_SetWindow */
typedef NPError	(* NP_LOADDS NPP_SetWindowUPP)(NPP instance, NPWindow* window);

/* NPP_NewStream */
typedef NPError	(* NP_LOADDS NPP_NewStreamUPP)(NPP instance, NPMIMEType type, NPStream* stream, NPBool seekable, uint16_t* stype);

/* NPP_DestroyStream */
typedef NPError	(* NP_LOADDS NPP_DestroyStreamUPP)(NPP instance, NPStream* stream, NPReason reason);

/* NPP_WriteReady */
typedef int32_t (* NP_LOADDS NPP_WriteReadyUPP)(NPP instance, NPStream* stream);

/* NPP_Write */
typedef int32_t (* NP_LOADDS NPP_WriteUPP)(NPP instance, NPStream* stream, int32_t offset, int32_t len, void* buffer);

/* NPP_StreamAsFile */
typedef void (* NP_LOADDS NPP_StreamAsFileUPP)(NPP instance, NPStream* stream, const char* fname);

/* NPP_Print */
typedef void (* NP_LOADDS NPP_PrintUPP)(NPP instance, NPPrint* platformPrint);

/* NPP_HandleEvent */
typedef int16_t (* NP_LOADDS NPP_HandleEventUPP)(NPP instance, void* event);

/* NPP_URLNotify */
typedef void (* NP_LOADDS NPP_URLNotifyUPP)(NPP instance, const char* url, NPReason reason, void* notifyData);

/* NPP_GetJavaClass */
typedef void (* NP_LOADDS NPP_GetJavaClassUPP)();

/* NPP_GetValue */
typedef NPError	(* NP_LOADDS NPP_GetValueUPP)(NPP instance, NPPVariable variable, void *ret_alue);

/* NPP_SetValue */
typedef NPError	(* NP_LOADDS NPP_SetValueUPP)(NPP instance, NPNVariable variable, void *ret_alue);

/*
 *  Netscape entry points
 */


/* NPN_GetValue */
typedef NPError	(* NP_LOADDS NPN_GetValueUPP)(NPP instance, NPNVariable variable, void *ret_alue);

/* NPN_SetValue */
typedef NPError	(* NP_LOADDS NPN_SetValueUPP)(NPP instance, NPPVariable variable, void *ret_alue);

/* NPN_GetUrlNotify */
typedef NPError	(* NP_LOADDS NPN_GetURLNotifyUPP)(NPP instance, const char* url, const char* window, void* notifyData);

/* NPN_PostUrlNotify */
typedef NPError (* NP_LOADDS NPN_PostURLNotifyUPP)(NPP instance, const char* url, const char* window, uint32_t len, const char* buf, NPBool file, void* notifyData);

/* NPN_GetUrl */
typedef NPError	(* NP_LOADDS NPN_GetURLUPP)(NPP instance, const char* url, const char* window);

/* NPN_PostUrl */
typedef NPError (* NP_LOADDS NPN_PostURLUPP)(NPP instance, const char* url, const char* window, uint32_t len, const char* buf, NPBool file);

/* NPN_RequestRead */
typedef NPError	(* NP_LOADDS NPN_RequestReadUPP)(NPStream* stream, NPByteRange* rangeList);

/* NPN_NewStream */
typedef NPError	(* NP_LOADDS NPN_NewStreamUPP)(NPP instance, NPMIMEType type, const char* window, NPStream** stream);

/* NPN_Write */
typedef int32_t (* NP_LOADDS NPN_WriteUPP)(NPP instance, NPStream* stream, int32_t len, void* buffer);

/* NPN_DestroyStream */
typedef NPError (* NP_LOADDS NPN_DestroyStreamUPP)(NPP instance, NPStream* stream, NPReason reason);

/* NPN_Status */
typedef void (* NP_LOADDS NPN_StatusUPP)(NPP instance, const char* message);

/* NPN_UserAgent */
typedef const char*	(* NP_LOADDS NPN_UserAgentUPP)(NPP instance);

/* NPN_MemAlloc */
typedef void* (* NP_LOADDS NPN_MemAllocUPP)(uint32_t size);

/* NPN__MemFree */
typedef void (* NP_LOADDS NPN_MemFreeUPP)(void* ptr);

/* NPN_MemFlush */
typedef uint32_t (* NP_LOADDS NPN_MemFlushUPP)(uint32_t size);

/* NPN_ReloadPlugins */
typedef void (* NP_LOADDS NPN_ReloadPluginsUPP)(NPBool reloadPages);

/* Peter Leese - obsolete functions types */
/* NPN_GetJavaEnv */
typedef void* (* NP_LOADDS NPN_GetJavaEnvUPP)(void);

/* NPN_GetJavaPeer */
typedef void * (* NP_LOADDS NPN_GetJavaPeerUPP)(NPP instance);

/* NPN_InvalidateRect */
typedef void (* NP_LOADDS NPN_InvalidateRectUPP)(NPP instance, NPRect *rect);

/* NPN_InvalidateRegion */
typedef void (* NP_LOADDS NPN_InvalidateRegionUPP)(NPP instance, NPRegion region);

/* NPN_ForceRedraw */
typedef void (* NP_LOADDS NPN_ForceRedrawUPP)(NPP instance);

/* NPN_GetStringIdentifier */
typedef NPIdentifier (* NP_LOADDS NPN_GetStringIdentifierUPP)(const NPUTF8* name);

/* NPN_GetStringIdentifiers */
typedef void (* NP_LOADDS NPN_GetStringIdentifiersUPP)(const NPUTF8** names,
                                                 int32_t nameCount,
                                                 NPIdentifier* identifiers);

/* NPN_GetIntIdentifier */
typedef NPIdentifier (* NP_LOADDS NPN_GetIntIdentifierUPP)(int32_t intid);

/* NPN_IdentifierIsString */
typedef bool (* NP_LOADDS NPN_IdentifierIsStringUPP)(NPIdentifier identifier);

/* NPN_UTF8FromIdentifier */
typedef NPUTF8* (* NP_LOADDS NPN_UTF8FromIdentifierUPP)(NPIdentifier identifier);

/* NPN_IntFromIdentifier */
typedef int32_t (* NP_LOADDS NPN_IntFromIdentifierUPP)(NPIdentifier identifier);

/* NPN_CreateObject */
typedef NPObject* (* NP_LOADDS NPN_CreateObjectUPP)(NPP npp, NPClass *aClass);

/* NPN_RetainObject */
typedef NPObject* (* NP_LOADDS NPN_RetainObjectUPP)(NPObject *obj);

/* NPN_ReleaseObject */
typedef void (* NP_LOADDS NPN_ReleaseObjectUPP)(NPObject *obj);

/* NPN_Invoke */
typedef bool (* NP_LOADDS NPN_InvokeUPP)(NPP npp, NPObject* obj, NPIdentifier methodName, const NPVariant *args, uint32_t argCount, NPVariant *result);

/* NPN_InvokeDefault */
typedef bool (* NP_LOADDS NPN_InvokeDefaultUPP)(NPP npp, NPObject* obj, const NPVariant *args, uint32_t argCount, NPVariant *result);

/* NPN_Evaluate */
typedef bool (* NP_LOADDS NPN_EvaluateUPP)(NPP npp, NPObject *obj, NPString *script, NPVariant *result);

/* NPN_GetProperty */
typedef bool (* NP_LOADDS NPN_GetPropertyUPP)(NPP npp, NPObject *obj, NPIdentifier propertyName, NPVariant *result);

/* NPN_SetProperty */
typedef bool (* NP_LOADDS NPN_SetPropertyUPP)(NPP npp, NPObject *obj, NPIdentifier propertyName, const NPVariant *value);

/* NPN_RemoveProperty */
typedef bool (* NP_LOADDS NPN_RemovePropertyUPP)(NPP npp, NPObject *obj, NPIdentifier propertyName);

/* NPN_HasProperty */
typedef bool (* NP_LOADDS NPN_HasPropertyUPP)(NPP npp, NPObject *obj, NPIdentifier propertyName);

/* NPN_HasMethod */
typedef bool (* NP_LOADDS NPN_HasMethodUPP)(NPP npp, NPObject *obj, NPIdentifier propertyName);

/* NPN_ReleaseVariantValue */
typedef void (* NP_LOADDS NPN_ReleaseVariantValueUPP)(NPVariant *variant);

/* NPN_SetException */
typedef void (* NP_LOADDS NPN_SetExceptionUPP)(NPObject *obj, const NPUTF8 *message);

/* NPN_PushPopupsEnabledStateUPP */
typedef bool (* NP_LOADDS NPN_PushPopupsEnabledStateUPP)(NPP npp, NPBool enabled);

/* NPN_PopPopupsEnabledState */
typedef bool (* NP_LOADDS NPN_PopPopupsEnabledStateUPP)(NPP npp);

/* NPN_Enumerate */
typedef bool (* NP_LOADDS NPN_EnumerateUPP)(NPP npp, NPObject *obj, NPIdentifier **identifier, uint32_t *count);

/* NPN_PluginThreadAsyncCall */
typedef void (* NP_LOADDS NPN_PluginThreadAsyncCallUPP)(NPP instance, void (*func)(void *), void *userData);

/* NPN_Construct */
typedef bool (* NP_LOADDS NPN_ConstructUPP)(NPP npp, NPObject* obj, const NPVariant *args, uint32_t argCount, NPVariant *result);

typedef NPError (*NP_LOADDS NPN_GetValueForURLUPP)(NPP npp, NPNURLVariable variable, const char *url, char **value, uint32_t *len);

typedef NPError (*NP_LOADDS NPN_SetValueForURLUPP)(NPP npp, NPNURLVariable variable, const char *url, const char *value, uint32_t len);

typedef NPError (*NP_LOADDS NPN_GetAuthenticationInfoUPP)(NPP npp, const char *protocol, const char *host, int32_t port, const char *scheme, const char *realm, char **username, uint32_t *ulen, char **password, uint32_t *plen);


/******************************************************************************************
 * The actual plugin function table definitions
 *******************************************************************************************/

typedef struct _NPPluginFuncs {
    uint16_t size;
    uint16_t version;
    NPP_NewUPP newp;
    NPP_DestroyUPP destroy;
    NPP_SetWindowUPP setwindow;
    NPP_NewStreamUPP newstream;
    NPP_DestroyStreamUPP destroystream;
    NPP_StreamAsFileUPP asfile;
    NPP_WriteReadyUPP writeready;
    NPP_WriteUPP write;
    NPP_PrintUPP print;
    NPP_HandleEventUPP event;
    NPP_URLNotifyUPP urlnotify;
    NPP_GetJavaClassUPP javaClass;             /* JRIGlobalRef replaced with void * */
    NPP_GetValueUPP getvalue;
    NPP_SetValueUPP setvalue;
} NPPluginFuncs;

typedef struct _NPNetscapeFuncs {
    uint16_t size;
    uint16_t version;
    NPN_GetURLUPP geturl;
    NPN_PostURLUPP posturl;
    NPN_RequestReadUPP requestread;
    NPN_NewStreamUPP newstream;
    NPN_WriteUPP write;
    NPN_DestroyStreamUPP destroystream;
    NPN_StatusUPP status;
    NPN_UserAgentUPP uagent;
    NPN_MemAllocUPP memalloc;
    NPN_MemFreeUPP memfree;
    NPN_MemFlushUPP memflush;
    NPN_ReloadPluginsUPP reloadplugins;
    NPN_GetJavaEnvUPP getJavaEnv;
    NPN_GetJavaPeerUPP getJavaPeer;
    NPN_GetURLNotifyUPP geturlnotify;
    NPN_PostURLNotifyUPP posturlnotify;
    NPN_GetValueUPP getvalue;
    NPN_SetValueUPP setvalue;
    NPN_InvalidateRectUPP invalidaterect;
    NPN_InvalidateRegionUPP invalidateregion;
    NPN_ForceRedrawUPP forceredraw;
    NPN_GetStringIdentifierUPP getstringidentifier;
    NPN_GetStringIdentifiersUPP getstringidentifiers;
    NPN_GetIntIdentifierUPP getintidentifier;
    NPN_IdentifierIsStringUPP identifierisstring;
    NPN_UTF8FromIdentifierUPP utf8fromidentifier;
    NPN_IntFromIdentifierUPP intfromidentifier;
    NPN_CreateObjectUPP createobject;
    NPN_RetainObjectUPP retainobject;
    NPN_ReleaseObjectUPP releaseobject;
    NPN_InvokeUPP invoke;
    NPN_InvokeDefaultUPP invokeDefault;
    NPN_EvaluateUPP evaluate;
    NPN_GetPropertyUPP getproperty;
    NPN_SetPropertyUPP setproperty;
    NPN_RemovePropertyUPP removeproperty;
    NPN_HasPropertyUPP hasproperty;
    NPN_HasMethodUPP hasmethod;
    NPN_ReleaseVariantValueUPP releasevariantvalue;
    NPN_SetExceptionUPP setexception;
    NPN_PushPopupsEnabledStateUPP pushpopupsenabledstate;
    NPN_PopPopupsEnabledStateUPP poppopupsenabledstate;
    NPN_EnumerateUPP enumerate;
    NPN_PluginThreadAsyncCallUPP pluginthreadasynccall;
    NPN_ConstructUPP construct;
    NPN_GetValueForURLUPP getvalueforurl;
    NPN_SetValueForURLUPP setvalueforurl;
    NPN_GetAuthenticationInfoUPP getauthenticationinfo;
} NPNetscapeFuncs;


#if defined(_WINDOWS)
#define OSCALL WINAPI
#else
#define OSCALL
#endif

#if defined(XP_UNIX)
/* GCC 3.3 and later support the visibility attribute. */
#if defined(__GNUC__) && \
    ((__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 3))
#define NP_VISIBILITY_DEFAULT __attribute__((visibility("default")))
#else
#define NP_VISIBILITY_DEFAULT
#endif

#define NP_EXPORT(__type) NP_VISIBILITY_DEFAULT __type
#endif

#if defined( _WINDOWS )

#ifdef __cplusplus
extern "C" {
#endif

/* plugin meta member functions */

NPError OSCALL NP_GetEntryPoints(NPPluginFuncs* pFuncs);

NPError OSCALL NP_Initialize(NPNetscapeFuncs* pFuncs);

NPError OSCALL NP_Shutdown();

char*	NP_GetMIMEDescription();

#ifdef __cplusplus
}
#endif

#endif /* _WINDOWS  */

#ifdef XP_UNIX

#ifdef __cplusplus
extern "C" {
#endif

/* plugin meta member functions */

NP_EXPORT(char*)   NP_GetMIMEDescription(void);
NP_EXPORT(NPError) NP_Initialize(NPNetscapeFuncs*, NPPluginFuncs*);
NP_EXPORT(NPError) NP_Shutdown(void);
NP_EXPORT(NPError) NP_GetValue(void *future, NPPVariable aVariable, void *aValue);

#ifdef __cplusplus
}
#endif

#endif /* XP_UNIX */

#endif /* _NPUPP_H_ */
