// That file may be redistributed under one of those licence: MPL/GPL/LGPL

function toOpenWindowByType(inType, uri, features)
{

    var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
    var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
    var topWindow = windowManagerInterface.getMostRecentWindow(inType);

    if (topWindow)
        topWindow.focus();
    else if (features)
        window.open(uri, "_blank", features);
    else
        window.open(uri, "_blank", "chrome,extrachrome,menubar,resizable,scrollbars,status,toolbar");
}

function console() {
    toOpenWindowByType("global:console", "chrome://global/content/console.xul");
}

// you may need to instal dom inspector by yourself.
// See http://developer.mozilla.org/en/docs/XULRunner_tips#DOM_Inspector
function domi() {
    window.openDialog("chrome://inspector/content/", "_blank",
                    "chrome,all,dialog=no", document);
}

function editxul() {
    window.openDialog("chrome://$APPNAME/content/xuledit.xul", "_blank",
                    "chrome,all,dialog=no,height=400,width=600", document);
}

function openuri () {
    var uri = prompt('enter uri to open');
    if (uri)
        window.openDialog("chrome://$APPNAME/content/browser.xul", "_blank", "chrome,extrachrome,menubar,resizable,scrollbars,status,toolbar", uri);
}

function restart () {
    var as = Components.classes["@mozilla.org/toolkit/app-startup;1"].getService(Components.interfaces.nsIAppStartup);
    as.quit(Components.interfaces.nsIAppStartup.eRestart | Components.interfaces.nsIAppStartup.eAttemptQuit);
}

function setDebug() {
    var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
    try {
        var debugmode=pref.getBoolPref("debug");
    } catch(e) {
        var debugmode=false;
    }
    
    // debug mode will enable all those prefs.
    // See http://developer.mozilla.org/en/docs/Setting_up_extension_development_environment#Development_preferences
    var debugPrefs = [ "browser.dom.window.dump.enabled",
                    "javascript.options.showInConsole",
                    "javascript.options.strict",
                    "nglayout.debug.disable_xul_cache",
                    "nglayout.debug.disable_xul_fastload"];

    for (var i = 0; i< debugPrefs.length; i++) {
        pref.setBoolPref(debugPrefs[i], debugmode);
    }


    if (!debugmode) { // hide debug toolbar
        var debugitems = document.getElementsByAttribute("class", "debug");
        for (var i = debugitems.length; i --> 0; ) {
            debugitems.item(i).setAttribute("hidden", "true");
        }
    }
}

window.addEventListener("load", setDebug, true);
