//   XUL Webmail, a web-based mailclient
//
//   Copyright (C) 2004 Wouter van Wijk (wvw@dds.nl),
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

function submitMessage() {
//    alert ('y');
  /*var httpRequest = new XMLHttpRequest();
  httpRequest.open("POST", "sendmessage.php", false, null, null);
  httpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
  httpRequest.send("test=8");
  var response = httpRequest.responseText;
  if (response == '') {
    window.close();
  } else {
    alert (response);
  }*/
  var subject = document.getElementById('subject');
  var to = document.getElementById('to');
  var message = document.getElementById('message');
  var htsub = document.getElementById('htsubject');
  var htto = document.getElementById('htto');
  var htmessage = document.getElementById('htmessage');
  htsub.value = subject.value;
  htto.value = to.value;
  htmessage.value = message.value;
  var htform = document.getElementById('htform');
  var res = htform.submit();
  if ( res ) {
     window.close();
  } else {
  }
}

function refreshMailboxes() {
	var tree=document.getElementById("MailBoxTree");
	tree.setAttribute('datasources', '');
	tree.builder.rebuild();
	tree.setAttribute('datasources', 'mailboxlist.rdf.php?ran=' + Math.random(0,99999));
	tree.builder.rebuild();
}

function refreshMessages() {
	var msglist = document.getElementById('msgTree');
	msglist.setAttribute('datasources', '');
	msglist.builder.rebuild();
	selectMailbox();
}

function selectMailbox() {
	var mailbox=getCurrentMailbox();
	var msglist = document.getElementById('msgTree');
	msglist.setAttribute('datasources', 'messagelist.rdf.php?mailbox=' + escape(mailbox) + '&ran=' + Math.random(0,99999));
//	alert(msglist.view.selection.getRangeCount());
//	msglist.treeBoxObject.selection.select(msglist.firstchild);
//	msglist.view.selectedIndex = 0;
//	node = msglist.view.selection.getItemAtIndex(1);

//	msglist.view.selectItems = node;
}

function selectMessage() {
	var id=getCurrentMessageId();
	var mailbox=getCurrentMailbox();
	var contentFrame = document.getElementById('contentFrame');
	if(id != null) {
		contentFrame.setAttribute('src', "mailsplash.php?id=" + escape(id) + "&mailbox=" + escape(mailbox));
	}
}

function showAbout() {
	window.open("about.xul.php",'about','width=400, height=200, location=no, menubar=no, status=no, toolbar=no, scrollbars=no, resizable=no');
}

function getCurrentMessageId() {
	var tree = document.getElementById('msgTree');
	try {
    	var id = tree.view.getCellValue(tree.currentIndex,"subject");
     } catch (e) {
        var id = null;
     }
     return(id);
}

function getCurrentMailbox() {
	var tree=document.getElementById("MailBoxTree");
	try {
    		var id = tree.view.getCellValue(tree.currentIndex,"mailboxName");
	} catch (e) {
        	var id = null;
     	}
	return(id);
}

function getCurrentMailboxOrAlert() {
	var id = getCurrentMailbox();
	if (id == null) {
		alert('Please select a mailbox!');
	}
	return(id);
}

function sendMessage(action) {
	var openoptions = 'width=750, height=500, location=no, menubar=no, status=no, toolbar=no, scrollbars=no, resizable=yes';
	var mailbox= getCurrentMailbox();

	//new message
	if (action == 0) {
		window.open('composemail.xul.php', '', openoptions);
	} else {
		var id = getCurrentMessageIdOrAlert();
	}

	if (id != null) {
		switch (action) {
		//reply
		case 1: {
			window.open('composemail.xul.php?action=reply&mailbox=' + escape(mailbox) + '&id=' + escape(id), '', openoptions);
		} break;
		//replyall
		case 2: {
			window.open('composemail.xul.php?action=replyall&mailbox=' + escape(mailbox) + '&id=' + escape(id), '', openoptions);
		} break;
		//forward
		case 3: {
		window.open('composemail.xul.php?action=forward&mailbox=' + escape(mailbox) + '&id=' + escape(id), '', openoptions);
		}
		}
	}
}

function closeSession() {
	this.location='logout.php';
}

function printMessage() {
//   obviously not done yet
//  var msgframe = frames[0];
//  var message = frames['ifr'].document.getElementById('message');
//	var contentFrame = document.getElementById('contentFrame');
	var id = getCurrentMessageIdOrAlert();
	if (id != null) {
		parent.contentFrame.print();
	}
}

function viewSource() {
	var mailbox= getCurrentMailbox();
	var id = getCurrentMessageIdOrAlert();
	if (id != null) {
		window.open("viewsource.xul.php?mailbox="  + escape(mailbox) + '&id=' + escape(id) ,'','width=600, height=400, location=no, menubar=no, status=yes, toolbar=no, scrollbars=no, resizable=no');
	}
}

function getCurrentMessageIdOrAlert() {
	var id = getCurrentMessageId();
	if (id == null) {
		alert('Please select a message!');
	}
	return(id);
}

function initMain($statusmessage) {

	var tree = document.getElementById("MailBoxTree");
	var ds = tree.getAttribute('datasources');
	if (ds == '') {
		tree.setAttribute('datasources', 'mailboxlist.rdf.php?ran=' + Math.random(0,99999));
	}
//	tree.builder.rebuild();
	window.defaultStatus = $statusmessage;
}

function deleteMessage() {
	var mailbox= getCurrentMailbox();
	var id = getCurrentMessageIdOrAlert();
	if (id != null) {
//		alert(id);
		var contentFrame = document.getElementById('contentFrame');
		contentFrame.setAttribute('src','managemail.php?action=delete&mailbox=' + escape(mailbox) + '&id=' + escape(id) + '&submit=1');
		refreshMessages();
	}
}

function copymoveMessage(targetmailbox, action) {
	var sourcemailbox= getCurrentMailbox();
	var id = getCurrentMessageIdOrAlert();
	if (id != null) {
		if (sourcemailbox == targetmailbox) {
			alert('You selected the current mailbox: ' + targetmailbox);
		} else {
			var contentFrame = document.getElementById('contentFrame');
			contentFrame.setAttribute('src','managemail.php?action=' + action + '&sourcemailbox=' + escape(sourcemailbox) + '&targetmailbox=' + escape(targetmailbox) + '&id=' + escape(id) + '&submit=1');
		}
		if (action == 'move') {
//			alert('move');
			refreshMessages();
		}
	}
}

function deleteMailbox() {
	var mailbox= getCurrentMailboxOrAlert();
	if (mailbox != null) {
//		alert(id);
		if(confirm('Delete this mailbox: ' + mailbox + '?')) {
			var contentFrame = document.getElementById('contentFrame');
			contentFrame.setAttribute('src','managefolders.php?action=delete&mailbox=' + escape(mailbox) + '&submit=1');
		}
		refreshMailboxes();
	}
}

function renameMailbox() {
	var mailbox= getCurrentMailboxOrAlert();
	if (mailbox != null) {
//		alert(id);
		var name = prompt('Please type the new name for the mailbox:', mailbox);
		if( (name != '') && (name != ' ') && (name != null) ) {
			var contentFrame = document.getElementById('contentFrame');
			contentFrame.setAttribute('src','managefolders.php?action=rename&oldname=' + escape(mailbox) + '&newname=' + name + '&submit=1');
		}
		refreshMailboxes();
	}
}

function createMailbox() {
	var mailbox= getCurrentMailboxOrAlert();
	if (mailbox != null) {
//		alert(id);
		var name = prompt('Please type the new name for the mailbox:', 'New Folder');
		if( (name != '') && (name != ' ') && (name != null) ) {
			var contentFrame = document.getElementById('contentFrame');
			contentFrame.setAttribute('src','managefolders.php?action=create&inmailbox=' + escape(mailbox) + '&name=' + name + '&submit=1');
		}
		refreshMailboxes();
	}
}

function emptyTrash() {
	if(confirm('Empty the trash?')) {
		var contentFrame = document.getElementById('contentFrame');
		contentFrame.setAttribute('src','managefolders.php?action=emptytrash&submit=1');
		refreshMessages();
	}
}

