
// 12ax7 table generated by DK/tube_table_gen.py -- do not modify manually

struct table1d { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

typedef struct {
    float c;
    float d;
    float e;
} average;

template <int tab_size>
struct table1d_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator table1d&() const { return *(table1d*)this; }
};

static table1d_imp<200> tube_table __rt_data = {
	0,0.704529,66.3333,200, {
	0.000000000000,0.008597754217,0.017234037157,0.025924876921,0.034699260111,
	0.043605389136,0.052725488943,0.062218199328,0.072522621387,0.085128809128,
	0.097655572804,0.109789081264,0.121541297048,0.132924748458,0.143952207041,
	0.154636468092,0.164990200340,0.175025843135,0.184755536822,0.194191076668,
	0.203343883675,0.212224987607,0.220845018881,0.229214206918,0.237342383172,
	0.245238987537,0.252913077155,0.260373336903,0.267628091001,0.274685315343,
	0.281552650225,0.288237413251,0.294746612226,0.301086957924,0.307264876618,
	0.313286522309,0.319157788605,0.324884320218,0.330471524055,0.335924579883,
	0.341248450577,0.346447891949,0.351527462144,0.356491530637,0.361344286825,
	0.366089748224,0.370731768294,0.375274043900,0.379720122416,0.384073408498,
	0.388337170536,0.392514546792,0.396608551247,0.400622079165,0.404557912392,
	0.408418724394,0.412207085055,0.415925465242,0.419576241151,0.423161698444,
	0.426684036180,0.430145370567,0.433547738524,0.436893101081,0.440183346611,
	0.443420293904,0.446605695108,0.449741238516,0.452828551229,0.455869201692,
	0.458864702111,0.461816510755,0.464726034153,0.467594629187,0.470423605090,
	0.473214225351,0.475967709530,0.478685234996,0.481367938578,0.484016918149,
	0.486633234132,0.489217910943,0.491771938367,0.494296272872,0.496791838868,
	0.499259529909,0.501700209839,0.504114713893,0.506503849747,0.508868398525,
	0.511209115758,0.513526732310,0.515821955254,0.518095468724,0.520347934714,
	0.522579993863,0.524792266191,0.526985351814,0.529159831625,0.531316267951,
	0.533455205177,0.535577170350,0.537682673760,0.539772209490,0.541846255950,
	0.543905276391,0.545949719392,0.547980019337,0.549996596862,0.551999859295,
	0.553990201077,0.555968004158,0.557933638390,0.559887461895,0.561829821428,
	0.563761052719,0.565681480804,0.567591420347,0.569491175943,0.571381042422,
	0.573261305123,0.575132240179,0.576994114775,0.578847187404,0.580691708114,
	0.582527918745,0.584356053154,0.586176337437,0.587988990140,0.589794222464,
	0.591592238463,0.593383235230,0.595167403083,0.596944925742,0.598715980499,
	0.600480738380,0.602239364304,0.603992017240,0.605738850348,0.607480011125,
	0.609215641541,0.610945878172,0.612670852325,0.614390690163,0.616105512821,
	0.617815436525,0.619520572697,0.621221028060,0.622916904748,0.624608300395,
	0.626295308234,0.627978017191,0.629656511966,0.631330873123,0.633001177168,
	0.634667496628,0.636329900128,0.637988452458,0.639643214646,0.641294244026,
	0.642941594294,0.644585315577,0.646225454485,0.647862054173,0.649495154387,
	0.651124791520,0.652750998657,0.654373805625,0.655993239032,0.657609322312,
	0.659222075762,0.660831516581,0.662437658904,0.664040513837,0.665640089484,
	0.667236390978,0.668829420512,0.670419177358,0.672005657892,0.673588855618,
	0.675168761187,0.676745362411,0.678318644284,0.679888588992,0.681455175929,
	0.683018381708,0.684578180167,0.686134542379,0.687687436658,0.689236828561,
	0.690782680897,0.692324953722,0.693863604339,0.695398587303,0.696929854410,
	0.698457354698,0.699981034439,0.701500837131,0.703016703492,0.704528571448
	}
};

average MA = (average) {0.0,0.0,0.0};

double always_inline tubeclip(double x) {
    double f = fabs(x);
    f = f * tube_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = tube_table.data[0];
    } else if (i >= tube_table.size-1) {
        f = tube_table.data[tube_table.size-1];
    } else {
	f -= i;
	f = tube_table.data[i]*(1-f) + tube_table.data[i+1]*f;
    }
    double fm = f*0.5 + MA.c*0.3 + MA.d*0.2 * MA.e*0.1;
    MA.e = MA.d;
    MA.d = MA.c;
    MA.c = f;
    return copysign(fm, x);
}

