/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.storage.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import org.objectweb.asm.tree.FrameNode;

public class FrameNodeSerializer
implements JsonSerializer<FrameNode>,
JsonDeserializer<FrameNode> {
    public FrameNode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = (JsonObject)json;
        List local = null;
        List stack = null;
        int opcode = jsonObject.get("opcode").getAsInt();
        int type = jsonObject.get("type").getAsInt();
        local = (List)context.deserialize(jsonObject.get("local"), List.class);
        stack = (List)context.deserialize(jsonObject.get("stack"), List.class);
        FrameNode node = new FrameNode(opcode, local.size(), local.toArray(), stack.size(), stack.toArray());
        node.type = type;
        return node;
    }

    public JsonElement serialize(FrameNode src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.add("opcode", context.serialize((Object)src.getOpcode()));
        object.add("type", context.serialize((Object)src.getType()));
        object.add("local", context.serialize((Object)src.local));
        object.add("stack", context.serialize((Object)src.stack));
        return object;
    }
}

